/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.IPatternStorage;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPatternStorage;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiPatternStorage;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCrystalMemory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TilePatternStorage
extends TileEntityInventory
implements IUpdatableTileEvent,
IPatternStorage {
    public final InvSlot diskSlot;
    private final List<RecipeInfo> patterns = new ArrayList<RecipeInfo>();
    public int index = 0;
    public int maxIndex;
    public RecipeInfo pattern;
    public double patternUu;
    public double patternEu;

    public TilePatternStorage(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.pattern_storage_iu, pos, state);
        this.diskSlot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() == IUItem.crystalMemory.getItem();
            }
        };
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.pattern_storage_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.readContents(this.provider, nbttagcompound);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        this.writeContentsAsNbtList(nbt);
        return nbt;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.maxIndex = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.pattern = (RecipeInfo)DecoderHandler.decode(customPacketBuffer);
            this.patternUu = (Double)DecoderHandler.decode(customPacketBuffer);
            this.patternEu = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.index);
            EncoderHandler.encode(packet, this.maxIndex);
            EncoderHandler.encode(packet, this.pattern);
            EncoderHandler.encode(packet, this.patternUu);
            EncoderHandler.encode(packet, this.patternEu);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (!this.getWorld().isClientSide) {
            CompoundTag nbt = ModUtils.nbt(stack);
            this.readContents((HolderLookup.Provider)placer.registryAccess(), nbt);
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).is(this.getPickBlock(null, null).getItem()) && (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self)) {
            CompoundTag nbt = ModUtils.nbt(drop);
            this.writeContentsAsNbtList(nbt);
        }
        return drop;
    }

    public void readContents(HolderLookup.Provider access, CompoundTag nbt) {
        ListTag patternList = nbt.getList("patterns", 10);
        for (int i = 0; i < patternList.size(); ++i) {
            CompoundTag contentTag = patternList.getCompound(i);
            ItemStack Item2 = ItemStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)contentTag);
            this.addPattern(new RecipeInfo(Item2, Recipes.recipes.getRecipeOutput((String)"replicator", (boolean)false, (ItemStack[])new ItemStack[]{Item2}).getOutput().metadata.getDouble("matter")));
        }
        this.refreshInfo();
    }

    private void writeContentsAsNbtList(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (RecipeInfo stack : this.patterns) {
            CompoundTag contentTag = new CompoundTag();
            stack.getStack().save(this.provider, (Tag)contentTag);
            list.add((Object)contentTag);
        }
        nbt.put("patterns", (Tag)list);
    }

    @Override
    public ContainerBase<TilePatternStorage> getGuiContainer(Player player) {
        return new ContainerPatternStorage(player, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiPatternStorage((ContainerPatternStorage)menu);
    }

    @Override
    public void updateTileServer(Player player, double event) {
        switch ((int)event) {
            case 0: {
                if (this.patterns.isEmpty()) break;
                this.index = this.index <= 0 ? this.patterns.size() - 1 : --this.index;
                this.refreshInfo();
                break;
            }
            case 1: {
                if (this.patterns.isEmpty()) break;
                this.index = this.index >= this.patterns.size() - 1 ? 0 : ++this.index;
                this.refreshInfo();
                break;
            }
            case 2: {
                ItemStack crystalMemory;
                if (this.index < 0 || this.index >= this.patterns.size() || this.diskSlot.isEmpty() || !((crystalMemory = this.diskSlot.get(0)).getItem() instanceof ItemCrystalMemory)) break;
                ((ItemCrystalMemory)crystalMemory.getItem()).writecontentsTag(this.registryAccess(), crystalMemory, this.patterns.get(this.index).getStack());
                break;
            }
            case 3: {
                ItemStack record;
                ItemStack crystalMemory;
                if (this.diskSlot.isEmpty() || !((crystalMemory = this.diskSlot.get(0)).getItem() instanceof ItemCrystalMemory) || (record = ((ItemCrystalMemory)crystalMemory.getItem()).readItemStack((HolderLookup.Provider)this.level.registryAccess(), crystalMemory)).isEmpty()) break;
                this.addPattern(new RecipeInfo(record, Recipes.recipes.getRecipeOutput((String)"replicator", (boolean)false, (ItemStack[])new ItemStack[]{record}).getOutput().metadata.getDouble("matter")));
            }
        }
    }

    public void refreshInfo() {
        if (this.index < 0 || this.index >= this.patterns.size()) {
            this.index = 0;
        }
        this.maxIndex = this.patterns.size();
        if (this.patterns.isEmpty()) {
            this.pattern = null;
        } else {
            this.pattern = this.patterns.get(this.index);
            this.patternUu = this.pattern.getCol();
            this.patternEu = this.patternUu * 1.0E9;
        }
    }

    @Override
    public boolean addPattern(RecipeInfo stack) {
        RecipeInfo pattern;
        if (ModUtils.isEmpty(stack.getStack())) {
            throw new IllegalArgumentException("empty stack: " + String.valueOf(stack.getStack()));
        }
        Iterator<RecipeInfo> var2 = this.patterns.iterator();
        do {
            if (var2.hasNext()) continue;
            this.patterns.add(stack);
            this.refreshInfo();
            return true;
        } while (!ModUtils.checkItemEquality((pattern = var2.next()).getStack(), stack.getStack()));
        return false;
    }

    @Override
    public List<RecipeInfo> getPatterns() {
        return this.patterns;
    }
}

