/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPlasticCreator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiPlasticCreator;
import com.denfop.invslot.InvSlot;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileBasePlasticCreator;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class TilePlasticCreator
extends TileBasePlasticCreator
implements IHasRecipe {
    public final InvSlot input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public TilePlasticCreator(BlockPos pos, BlockState state) {
        super(1, 300, 1, (IMultiTileBlock)BlockBaseMachine2.plastic_creator, pos, state);
        this.inputSlotA = new InvSlotRecipes(this, "plastic", this, this.fluidTank);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.inputSlotA.setInvSlotConsumableLiquidByList(this.fluidSlot);
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.INPUT);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        Recipes.recipes.addInitRecipes(this);
        this.input_slot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).isEmpty()) {
                    ((TilePlasticCreator)this.base).inputSlotA.changeAccepts(ItemStack.EMPTY);
                } else {
                    ((TilePlasticCreator)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
    }

    private static void spawnParticles(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 0.0, 0.3, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.1, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y - 0.1, z, 0.0, 0.025, 0.0);
    }

    private static void spawnFlame(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.025, 0.0);
    }

    public ContainerPlasticCreator getGuiContainer(Player entityPlayer) {
        return new ContainerPlasticCreator(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.EMPTY);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.plastic_creator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)Fluids.WATER, 1000), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(483), 1)), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(484), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.plast.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)Fluids.WATER, 1000), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getStack(38), 1)), input.getInput("c:dusts/Coal", 4)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iudust.getStack(39), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidHelium.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.cooling_mixture.getItem())), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(386), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.helium_cooling_mixture.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidcryogen.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.helium_cooling_mixture.getItem())), input.getInput(new ItemStack((ItemLike)IUItem.radiationresources.getStack(3), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.cryogenic_cooling_mixture.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidazot.getInstance().get(), 12000), input.getInput("c:storage_blocks/Vitalium"), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(269), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(270), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidpolyeth.getInstance().get(), 500), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(344), 1)), input.getInput("c:doubleplate/Titanium")), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(340), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidneft.getInstance().get(), 5000), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(283), 8)), input.getInput("c:ingots/Germanium", 4)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(386), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidtrinitrotoluene.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)Items.GUNPOWDER, 4)), input.getInput(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 3))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iudust.getStack(72), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidsulfuricacid.getInstance().get(), 100), input.getInput(new ItemStack((ItemLike)IUItem.classic_ore.getItem(3), 4)), input.getInput(IUItem.stoneDust, 2)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(21), 1))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidnitricacid.getInstance().get(), 100), input.getInput(new ItemStack((ItemLike)IUItem.toriyore.getItem(0))), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getStack(54), 2), 2)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(16), 9))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.beeswax.getItem())), input.getInput(new ItemStack((ItemLike)Items.STICK), 2)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.wax_stick.getItem()))));
        Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidhoney.getInstance().get(), 1000), input.getInput(new ItemStack((ItemLike)IUItem.wax_stick.getItem())), input.getInput(new ItemStack((ItemLike)IUItem.royal_jelly.getItem()), 1)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.polished_stick.getItem()))));
        for (int i = 0; i < 14; ++i) {
            Recipes.recipes.addRecipe("plastic", new BaseMachineRecipe(new Input(new FluidStack((Fluid)FluidName.fluidtemperedglass.getInstance().get(), 144), input.getInput(new ItemStack((ItemLike)IUItem.solar_day_glass.getStack(i), 1)), input.getInput(new ItemStack((ItemLike)IUItem.solar_night_glass.getStack(i), 1))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.solar_night_day_glass.getStack(i), 1))));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive() && this.getWorld().getGameTime() % 5L == 0L) {
            double x = this.pos.getX();
            double y = this.pos.getY();
            double z = this.pos.getZ();
            switch (this.getFacing()) {
                case NORTH: {
                    TilePlasticCreator.spawnParticles(this.level, x + 0.8, y + 1.2, z + 0.8);
                    TilePlasticCreator.spawnParticles(this.level, x + 0.2, y + 1.2, z + 0.8);
                    break;
                }
                case SOUTH: {
                    TilePlasticCreator.spawnFlame(this.level, x + 0.5, y + 1.2, z);
                    TilePlasticCreator.spawnFlame(this.level, x + 0.5, y + 1.2, z + 0.3);
                    TilePlasticCreator.spawnFlame(this.level, x + 0.7, y + 1.2, z + 0.3);
                    TilePlasticCreator.spawnFlame(this.level, x + 0.3, y + 1.2, z + 0.3);
                    break;
                }
                case WEST: {
                    TilePlasticCreator.spawnParticles(this.level, x + 0.8, y + 1.2, z + 0.8);
                    TilePlasticCreator.spawnParticles(this.level, x + 0.8, y + 1.2, z + 0.2);
                    break;
                }
                case EAST: {
                    TilePlasticCreator.spawnParticles(this.level, x + 0.2, y + 1.2, z + 0.8);
                    TilePlasticCreator.spawnParticles(this.level, x + 0.2, y + 1.2, z + 0.2);
                }
            }
        }
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockPlasticCreator.name");
    }

    @Override
    public int gaugeLiquidScaled(int i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0 : this.getFluidTank().getFluidAmount() * i / this.getFluidTank().getCapacity();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiPlasticCreator((ContainerPlasticCreator)isAdmin);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, new UpgradableProperty[]{UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract});
    }
}

