/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.multimechanism.simple;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMoreMachine1;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileMultiMachine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TileCombMacerator
extends TileMultiMachine {
    public static List<String> ores = new ArrayList<String>();
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public TileCombMacerator(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.COMB_MACERATOR.usagePerTick, EnumMultiMachine.COMB_MACERATOR.lenghtOperation, BlockMoreMachine1.comb_macerator, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
    }

    public static void addRecipe(String input, String output) {
        ResourceLocation input1 = ResourceLocation.parse((String)("c:" + output));
        TagKey tag = ItemTags.create((ResourceLocation)input1);
        Iterable holder = BuiltInRegistries.ITEM.getTagOrEmpty(tag);
        ItemStack stack = new ItemStack((Holder)holder.iterator().next());
        if (!stack.isEmpty()) {
            stack.setCount(3);
            IUCore.get_comb_crushed.add(stack);
            IInputHandler input2 = Recipes.inputFactory;
            Recipes.recipes.addRecipe("comb_macerator", new BaseMachineRecipe(new Input(input2.getInput("c:" + input)), new RecipeOutput(null, stack)));
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockMoreMachine1.comb_macerator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines_base1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        HashSet ores = new HashSet();
        BuiltInRegistries.ITEM.getTags().forEach(tag -> {
            ResourceLocation tagId = ((TagKey)tag.getFirst()).location();
            String name = tagId.getPath();
            if (name.startsWith("crushed/") && !name.startsWith("purifiedcrushed/")) {
                Object name1 = name.substring("crushed".length());
                if (((String)name1).startsWith("/uranium")) {
                    return;
                }
                name1 = "ores" + (String)name1;
                String name2 = "raw_materials" + name.substring("crushed".length());
                if (this.isTagNotEmpty((String)name1) && this.isTagNotEmpty(name)) {
                    if (this.isTagNotEmpty(name2)) {
                        if (!ores.contains(name)) {
                            TileCombMacerator.addRecipe(name2, name);
                            ores.add(name);
                        }
                    } else if (!ores.contains(name)) {
                        TileCombMacerator.addRecipe((String)name1, name);
                        ores.add(name);
                    }
                }
            }
        });
    }

    private boolean isTagNotEmpty(String tagName) {
        return !BuiltInRegistries.ITEM.getTags().filter(tag -> ((TagKey)tag.getFirst()).location().getPath().equals(tagName)).toList().isEmpty();
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.COMB_MACERATOR;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockCombMacerator.name");
    }

    public String getStartSoundFile() {
        return "Machines/MaceratorOp.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

