/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerAdvSteamQuarry;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiAdvSteamQuarry;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCraftingElements;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class TileAdvSteamQuarry
extends TileEntityInventory {
    public final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank fluidTank1 = this.fluids.addTank("fluidTank2", 4000, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()), InvSlot.TypeItemSlot.NONE);
    public final ComponentSteamEnergy steam;
    public final InvSlot invSlot;
    public final InvSlot invSlot1;
    public final InvSlotOutput output = new InvSlotOutput(this, 24);
    public final ItemStack stackPipe;
    public int y;
    public int x;
    public int z;
    public FakePlayerSpawner entity;
    public boolean work;

    public TileAdvSteamQuarry(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.adv_steam_quarry, pos, state);
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank1);
        this.y = 0;
        this.x = 0;
        this.z = 0;
        this.invSlot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof ItemCraftingElements && ((ISubEnum)((ItemCraftingElements)stack.getItem()).getElement()).getId() == 517;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.BIT;
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }
        };
        this.stackPipe = new ItemStack(IUItem.basemachine2.getItem(197), 1);
        this.invSlot1 = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() == IUItem.basemachine2.getItem(197);
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.TUBE;
            }
        };
        this.work = true;
    }

    public static int onBlockBreakEvent(Level level, GameType gameType, ServerPlayer entityPlayer, BlockPos pos) {
        Boolean preCancelEvent = false;
        ItemStack itemstack = entityPlayer.getMainHandItem();
        if (!itemstack.isEmpty() && !itemstack.getItem().canAttackBlock(level.getBlockState(pos), level, pos, (Player)entityPlayer)) {
            preCancelEvent = true;
        }
        if (gameType.isBlockPlacingRestricted()) {
            if (gameType == GameType.SPECTATOR) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.mayBuild() || !itemstack.isEmpty() && itemstack.canBreakBlockInAdventureMode(new BlockInWorld((LevelReader)level, pos, false)))) {
                preCancelEvent = true;
            }
        }
        BlockState state = level.getBlockState(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)entityPlayer);
        event.setCanceled(preCancelEvent.booleanValue());
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            entityPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                // empty if block
            }
        }
        return event.isCanceled() ? -1 : 1;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putInt("x1", this.x);
        nbtTagCompound.putInt("y1", this.y);
        nbtTagCompound.putInt("z1", this.z);
        nbtTagCompound.putBoolean("work", this.work);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.x = nbtTagCompound.getInt("x1");
        this.y = nbtTagCompound.getInt("y1");
        this.z = nbtTagCompound.getInt("z1");
        this.work = nbtTagCompound.getBoolean("work");
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        this.y = this.getPos().getY() - 1;
        this.x = this.getPos().getX() - 1;
        this.z = this.getPos().getZ() - 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiAdvSteamQuarry((ContainerAdvSteamQuarry)menu);
    }

    public ContainerAdvSteamQuarry getGuiContainer(Player entityPlayer) {
        return new ContainerAdvSteamQuarry(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.entity = new FakePlayerSpawner(this.level);
            this.entity.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.adv_steam_quarry;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.invSlot.isEmpty() && this.steam.canUseEnergy(2.0) && this.work && !this.invSlot1.isEmpty() && this.y > -30) {
            BlockPos pos1 = new BlockPos(this.x, this.y, this.z);
            BlockState state = this.level.getBlockState(pos1);
            Block block1 = state.getBlock();
            this.steam.useEnergy(2.0);
            if ((state.isAir() || state.getDestroySpeed((BlockGetter)this.level, pos1) < 0.0f) && TileAdvSteamQuarry.onBlockBreakEvent(this.level, GameType.SURVIVAL, (ServerPlayer)this.entity, pos1) != -1) {
                if (state.getDestroySpeed((BlockGetter)this.level, pos1) < 0.0f) {
                    return;
                }
                if (this.x == this.pos.getX() && this.z == this.pos.getZ()) {
                    this.invSlot1.get(0).shrink(1);
                    ItemBlockTileEntity blockTileEntity = (ItemBlockTileEntity)this.stackPipe.getItem();
                    blockTileEntity.placeTeBlock(this.stackPipe, this.entity, this.level, pos1);
                }
                if (this.x == this.pos.getX() + 3) {
                    this.x = this.pos.getX() - 3;
                    ++this.z;
                    if (this.z == this.pos.getZ() + 4) {
                        this.z = this.pos.getZ() - 3;
                        --this.y;
                    }
                } else {
                    ++this.x;
                }
                return;
            }
            if (TileAdvSteamQuarry.onBlockBreakEvent(this.level, GameType.SURVIVAL, (ServerPlayer)this.entity, pos1) == -1) {
                if (this.x == this.pos.getX() + 3) {
                    this.x = this.pos.getX() - 3;
                    ++this.z;
                    if (this.z == this.pos.getZ() + 4) {
                        this.z = this.pos.getZ() - 3;
                        --this.y;
                    }
                } else {
                    ++this.x;
                }
                return;
            }
            if (!(block1 instanceof BlockTileEntity) && block1.onDestroyedByPlayer(state, this.level, pos1, (Player)this.entity, true, this.level.getFluidState(pos1))) {
                block1.destroy((LevelAccessor)this.level, pos1, state);
                block1.playerDestroy(this.level, (Player)this.entity, pos1, state, null, this.entity.getMainHandItem());
                List items = this.entity.level().getEntitiesOfClass(ItemEntity.class, new AABB((double)(pos1.getX() - 1), (double)(pos1.getY() - 1), (double)(pos1.getZ() - 1), (double)(pos1.getX() + 1), (double)(pos1.getY() + 1), (double)(pos1.getZ() + 1)));
                for (ItemEntity item : items) {
                    if (this.entity.level().isClientSide || item.isRemoved() || !this.output.addWithoutIgnoring(Collections.singletonList(item.getItem()), false)) continue;
                    item.setRemoved(Entity.RemovalReason.KILLED);
                }
                if (this.x == this.getPos().getX() && this.z == this.getPos().getZ()) {
                    ItemBlockTileEntity blockTileEntity = (ItemBlockTileEntity)this.stackPipe.getItem();
                    blockTileEntity.placeTeBlock(this.stackPipe, this.entity, this.level, pos1);
                    this.invSlot1.get(0).shrink(1);
                }
            } else {
                if (this.x != this.getPos().getX() || this.z != this.getPos().getZ() || !(block1 instanceof BlockTileEntity) || ((BlockTileEntity)block1).item == this.stackPipe.getItem()) {
                    // empty if block
                }
                if (this.x == this.pos.getX() + 3) {
                    this.x = this.pos.getX() - 3;
                    ++this.z;
                    if (this.z == this.pos.getZ() + 4) {
                        this.z = this.pos.getZ() - 3;
                        --this.y;
                    }
                } else {
                    ++this.x;
                }
            }
        }
    }
}

