/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.worlcollector;

import com.denfop.IUItem;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.EnumTypeCollector;
import com.denfop.tiles.base.IIsMolecular;
import com.denfop.tiles.base.TileBaseWorldCollector;
import com.denfop.tiles.base.TileEntityBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;

public class TileCrystallize
extends TileBaseWorldCollector
implements IIsMolecular {
    protected ItemStack output_stack;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel bakedModel;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel transformedModel;

    public TileCrystallize(BlockPos pos, BlockState state) {
        super(EnumTypeCollector.DEFAULT, BlockBaseMachine3.crystallize, pos, state);
    }

    @Override
    public void init() {
        this.addRecipe(IUItem.diamondDust, 0.125, new ItemStack((ItemLike)Items.DIAMOND));
        this.addRecipe(IUItem.lapiDust, 0.0625, new ItemStack((ItemLike)Items.LAPIS_LAZULI));
        this.addRecipe(new ItemStack((ItemLike)Items.DIAMOND), 0.25, new ItemStack((ItemLike)Items.EMERALD));
        this.addRecipe(new ItemStack((ItemLike)Items.EMERALD), 0.25, new ItemStack((ItemLike)Items.DIAMOND));
        this.addRecipe(new ItemStack((ItemLike)IUItem.preciousgem.getStack(0)), 0.25, new ItemStack((ItemLike)Items.EMERALD));
        this.addRecipe(new ItemStack((ItemLike)IUItem.preciousgem.getStack(1)), 0.25, new ItemStack((ItemLike)Items.EMERALD));
        this.addRecipe(IUItem.iridiumOre, 20.0, new ItemStack((ItemLike)IUItem.iuingot.getStack(17)));
        this.addRecipe(new ItemStack((ItemLike)Items.DIAMOND_ORE), 4.0, new ItemStack((ItemLike)Items.DIAMOND, 2));
        this.addRecipe(new ItemStack((ItemLike)Items.EMERALD_ORE), 4.0, new ItemStack((ItemLike)Items.EMERALD, 2));
        this.addRecipe(new ItemStack((ItemLike)Items.REDSTONE_ORE), 1.0, new ItemStack((ItemLike)Items.REDSTONE, 4));
        this.addRecipe(new ItemStack((ItemLike)Items.LAPIS_ORE), 1.0, new ItemStack((ItemLike)Items.LAPIS_LAZULI, 4));
        this.addRecipe(new ItemStack((ItemLike)Items.GOLDEN_APPLE), 4.0, new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE));
        this.addRecipe(new ItemStack((ItemLike)Items.ROTTEN_FLESH), 4.0, new ItemStack((ItemLike)Items.PORKCHOP));
        this.addRecipe(new ItemStack((ItemLike)Items.SPIDER_EYE), 4.0, new ItemStack((ItemLike)Items.BEEF));
        this.addRecipe(new ItemStack((ItemLike)Items.STRING), 20.0, new ItemStack((ItemLike)Blocks.COBWEB));
        this.addRecipe(IUItem.latex, 10.0, new ItemStack((ItemLike)Items.SLIME_BALL));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.crystallize;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.machineRecipe = output;
        this.output_stack = this.machineRecipe != null ? this.machineRecipe.getRecipe().output.items.get(0) : new ItemStack((ItemLike)Items.AIR);
        new PacketUpdateFieldTile(this, "output", this.output_stack);
        this.setOverclockRates();
    }

    @Override
    public MachineRecipe getOutput() {
        this.machineRecipe = this.inputSlot.process();
        this.output_stack = this.machineRecipe != null ? this.machineRecipe.getRecipe().output.items.get(0) : new ItemStack((ItemLike)Items.AIR);
        return this.machineRecipe;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.output_stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("output")) {
            try {
                this.output_stack = (ItemStack)DecoderHandler.decode(is);
                if (!this.output_stack.isEmpty()) {
                    this.bakedModel = Minecraft.getInstance().getItemRenderer().getModel(this.output_stack, this.getWorld(), null, 0);
                    this.transformedModel = ClientHooks.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)this.bakedModel, (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.output_stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            this.bakedModel = Minecraft.getInstance().getItemRenderer().getModel(this.output_stack, this.getWorld(), null, 0);
            this.transformedModel = ClientHooks.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)this.bakedModel, (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getTransformedModel() {
        return this.transformedModel;
    }

    @Override
    public int getMode() {
        return 5;
    }

    @Override
    public ItemStack getItemStack() {
        return this.output_stack;
    }

    @Override
    public TileEntityBlock getEntityBlock() {
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getBakedModel() {
        return this.bakedModel;
    }
}

