/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.quarry_earth;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DataPos {
    public final BlockPos pos;
    public final BlockState state;

    public DataPos(BlockPos pos, BlockState state) {
        this.pos = pos;
        this.state = state;
    }

    public static DataPos load(CompoundTag tag) {
        BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        Block block = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)tag.getString("block"))).orElse(Blocks.AIR);
        BlockState state = block.defaultBlockState();
        CompoundTag props = tag.getCompound("properties");
        for (String key : props.getAllKeys()) {
            Property property = state.getBlock().getStateDefinition().getProperty(key);
            if (property == null) continue;
            state = DataPos.setValue(state, property, props.getString(key));
        }
        return new DataPos(pos, state);
    }

    private static <T extends Comparable<T>> String getName(BlockState state, Property<T> property) {
        Comparable value = state.getValue(property);
        return property.getName(value);
    }

    private static <T extends Comparable<T>> BlockState setValue(BlockState state, Property<T> property, String name) {
        return property.getValue(name).map(v -> (BlockState)state.setValue(property, v)).orElse(state);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", this.pos.getX());
        tag.putInt("y", this.pos.getY());
        tag.putInt("z", this.pos.getZ());
        tag.putString("block", BuiltInRegistries.BLOCK.getKey((Object)this.state.getBlock()).toString());
        CompoundTag props = new CompoundTag();
        for (Property property : this.state.getProperties()) {
            String name = property.getName();
            props.putString(name, DataPos.getName(this.state, property));
        }
        tag.put("properties", (Tag)props);
        return tag;
    }
}

