/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.graphite.controller;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.multiblock.IMultiElement;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.EnumTypeWork;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.api.reactors.InvSlotReactorModules;
import com.denfop.api.reactors.LogicGraphiteReactor;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerGraphiteReactor;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiGraphiteController;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotScheduleReactor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketExplosion;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.graphite.ICapacitor;
import com.denfop.tiles.reactors.graphite.ICooling;
import com.denfop.tiles.reactors.graphite.IExchanger;
import com.denfop.tiles.reactors.graphite.IGraphiteController;
import com.denfop.tiles.reactors.graphite.ISocket;
import com.denfop.tiles.reactors.graphite.ITank;
import com.denfop.tiles.reactors.graphite.controller.EnumGraphiteReactors;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityMainController
extends TileMultiBlockBase
implements IGraphiteReactor,
IUpdatableTileEvent {
    public final EnumGraphiteReactors enumFluidReactors;
    public final InvSlot reactorsElements;
    public final InvSlotReactorModules<TileEntityMainController> reactorsModules;
    public final InvSlotScheduleReactor scheduleReactor;
    private final ComponentBaseEnergy rad;
    public Timer timer = new Timer(9999, 0, 0);
    public Timer red_timer = new Timer(0, 2, 30);
    public Timer yellow_timer = new Timer(0, 15, 0);
    public Energy energy;
    public EnumTypeWork typeWork = EnumTypeWork.WORK;
    public int pressure = 1;
    public boolean work = false;
    public double heat;
    public double output = 0.0;
    public LogicGraphiteReactor reactor;
    public EnumTypeSecurity security = EnumTypeSecurity.NONE;
    public int levelBlock = 0;
    public boolean stable_sensor;
    public boolean heat_sensor;
    public List<Fluids.InternalFluidTank> cells = new ArrayList<Fluids.InternalFluidTank>();
    private List<IGraphiteController> listGraphiteController = new ArrayList<IGraphiteController>();
    private List<IExchanger> listExchanger = new ArrayList<IExchanger>();
    private List<ICapacitor> listCapacitor = new ArrayList<ICapacitor>();
    private List<ICooling> listCoolant = new ArrayList<ICooling>();

    public TileEntityMainController(MultiBlockStructure multiBlockStructure, EnumGraphiteReactors enumFluidReactors, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(multiBlockStructure, block, pos, state);
        this.enumFluidReactors = enumFluidReactors;
        this.reactorsModules = new InvSlotReactorModules<TileEntityMainController>(this);
        this.reactorsElements = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, enumFluidReactors.getHeight() * enumFluidReactors.getWidth()){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (TileEntityMainController.this.scheduleReactor.getAccepts().isEmpty()) {
                    if (stack.getItem() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.getItem();
                        return ((TileEntityMainController)this.base).getLevelReactor() >= iReactorItem.getLevel() && iReactorItem.getType() != EnumTypeComponent.HEAT_EXCHANGER;
                    }
                    return false;
                }
                ItemStack stack1 = TileEntityMainController.this.scheduleReactor.getAccepts().get(index);
                if (stack1.isEmpty()) {
                    return false;
                }
                return stack1.is(stack.getItem());
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityMainController.this.reactor = null;
                return content;
            }
        };
        this.reactorsElements.setStackSizeLimit(1);
        this.scheduleReactor = new InvSlotScheduleReactor(this, 3, enumFluidReactors.ordinal() + 1, enumFluidReactors.getWidth(), enumFluidReactors.getHeight());
        this.rad = this.addComponent(new ComponentBaseEnergy(EnergyType.RADIATION, this, enumFluidReactors.getRadiation() * 100.0));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.reactor_safety_doom.info"));
    }

    @Override
    public double getModuleStableHeat() {
        return this.reactorsModules.getStableHeat();
    }

    @Override
    public double getModuleRadiation() {
        return this.reactorsModules.getRadiation();
    }

    @Override
    public double getModuleGeneration() {
        return this.reactorsModules.getGeneration();
    }

    @Override
    public double getModuleVent() {
        return this.reactorsModules.getVent();
    }

    @Override
    public double getModuleExchanger() {
        return this.reactorsModules.getExchanger();
    }

    @Override
    public double getModuleComponentVent() {
        return this.reactorsModules.getComponentVent();
    }

    @Override
    public double getModuleCapacitor() {
        return this.reactorsModules.getCapacitor();
    }

    public LogicReactor getReactor() {
        if (this.reactor == null) {
            this.reactor = new LogicGraphiteReactor(this);
        }
        return this.reactor;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("pressure")) {
            try {
                this.pressure = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("reactor")) {
            if (this.reactor == null) {
                this.reactor = new LogicGraphiteReactor(this);
            }
            try {
                this.reactor.setGeneration((Integer)DecoderHandler.decode(is));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.cells.clear();
            this.listCapacitor.clear();
            this.listExchanger.clear();
            this.listGraphiteController.clear();
            this.listCoolant.clear();
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0) {
            if (this.levelBlock > 0) {
                this.setWork(!this.work);
            }
        } else if (var2 == 1.0) {
            ++this.pressure;
            this.pressure = Math.min(5, this.pressure);
        } else if (var2 == 2.0) {
            --this.pressure;
            this.pressure = Math.max(1, this.pressure);
        } else if (var2 == -1.0) {
            if (!this.stable_sensor) {
                this.heat_sensor = !this.heat_sensor;
            }
        } else if (var2 == -2.0) {
            if (!this.heat_sensor) {
                this.stable_sensor = !this.stable_sensor;
            }
        } else if (this.typeWork == EnumTypeWork.WORK && this.getLevelReactor() < this.getMaxLevelReactor()) {
            this.typeWork = EnumTypeWork.LEVEL_INCREASE;
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            switch (this.levelBlock) {
                case 0: {
                    this.energy.setCapacity(4000000.0);
                    break;
                }
                case 1: {
                    this.energy.setCapacity(5.0E7);
                    break;
                }
                case 2: {
                    this.energy.setCapacity(2.0E8);
                    break;
                }
                case 3: {
                    this.energy.setCapacity(5.0E8);
                }
            }
        } else if (this.typeWork == EnumTypeWork.LEVEL_INCREASE && this.getLevelReactor() < this.getMaxLevelReactor()) {
            this.typeWork = EnumTypeWork.WORK;
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.noFacings, ModUtils.allFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            this.energy.setCapacity(this.energy.defaultCapacity);
            this.energy.buffer.storage = 0.0;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.scheduleReactor.update();
            this.reactorsModules.load();
            try {
                if (this.typeWork == EnumTypeWork.LEVEL_INCREASE) {
                    this.energy.onUnloaded();
                    this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
                    this.energy.delegate = null;
                    this.energy.createDelegate();
                    this.energy.onLoaded();
                    switch (this.levelBlock) {
                        case 0: {
                            this.energy.setCapacity(4000000.0);
                            break;
                        }
                        case 1: {
                            this.energy.setCapacity(5.0E7);
                            break;
                        }
                        case 2: {
                            this.energy.setCapacity(2.0E8);
                            break;
                        }
                        case 3: {
                            this.energy.setCapacity(5.0E8);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ChunkPos chunkPos = this.getWorld().getChunkAt(this.pos).getPos();
            List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos, k -> new ArrayList());
            list.add(this);
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().isClientSide) {
            ChunkPos chunkPos = this.getWorld().getChunkAt(this.pos).getPos();
            List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos, k -> new ArrayList());
            list.remove(this);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.reactor == null) {
            this.reactor = new LogicGraphiteReactor(this);
            this.reactor.temp_heat = this.heat;
            new PacketUpdateFieldTile(this, "reactor", this.reactor.getGeneration());
        } else if (this.full) {
            if (this.typeWork == EnumTypeWork.WORK) {
                this.energy.buffer.capacity = Math.max(this.output, this.energy.getDefaultCapacity());
                if (this.getWorld().getGameTime() % 20L == 0L && this.work) {
                    this.reactor.onTick();
                    if (this.rad.getEnergy() >= this.rad.getCapacity() * 0.5 && this.rad.getEnergy() < this.rad.getCapacity() * 0.75) {
                        this.setSecurity(EnumTypeSecurity.UNSTABLE);
                    }
                    this.workTimer();
                    if (!this.timer.canWork()) {
                        this.explode();
                        this.reactor = null;
                    } else if (!this.yellow_timer.canWork()) {
                        this.explode();
                        this.reactor = null;
                    } else if (!this.red_timer.canWork()) {
                        this.explode();
                        this.reactor = null;
                    } else if (this.reactor != null && this.getHeat() >= (double)this.getMaxHeat() && this.reactor.getMaxHeat() >= (double)this.getMaxHeat() * 1.5) {
                        this.explode();
                        this.reactor = null;
                    }
                }
                if (this.work && this.reactor != null) {
                    this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.output));
                    this.energy.addEnergy(this.output);
                }
            } else if (this.energy.getEnergy() >= this.energy.getCapacity()) {
                ++this.levelBlock;
                this.typeWork = EnumTypeWork.WORK;
                this.energy.onUnloaded();
                this.energy.setCapacity(this.energy.defaultCapacity);
                this.energy.setDirections(ModUtils.noFacings, ModUtils.allFacings);
                this.energy.delegate = null;
                this.energy.createDelegate();
                this.energy.onLoaded();
                this.energy.buffer.storage = 0.0;
            }
        }
        if (this.heat < 0.0) {
            this.heat = 0.0;
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.pressure = customPacketBuffer.readInt();
        this.work = customPacketBuffer.readBoolean();
        boolean socket = customPacketBuffer.readBoolean();
        if (socket) {
            try {
                this.energy.onNetworkUpdate(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.security = EnumTypeSecurity.values()[customPacketBuffer.readInt()];
        this.heat = customPacketBuffer.readDouble();
        this.output = customPacketBuffer.readDouble();
        try {
            this.timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.levelBlock = customPacketBuffer.readInt();
        this.typeWork = EnumTypeWork.values()[customPacketBuffer.readInt()];
        try {
            this.red_timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.yellow_timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.pressure);
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBoolean(this.energy != null);
        if (this.energy != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.energy, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        customPacketBuffer.writeInt(this.security.ordinal());
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeDouble(this.output);
        this.timer.writeBuffer(customPacketBuffer);
        customPacketBuffer.writeInt(this.levelBlock);
        customPacketBuffer.writeInt(this.typeWork.ordinal());
        this.red_timer.writeBuffer(customPacketBuffer);
        this.yellow_timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.getBoolean("work");
        this.pressure = nbttagcompound.getInt("pressure");
        this.levelBlock = nbttagcompound.getInt("level");
        this.timer.readNBT(nbttagcompound);
        this.red_timer.readNBT(nbttagcompound.getCompound("red"));
        this.yellow_timer.readNBT(nbttagcompound.getCompound("yellow"));
        this.heat = nbttagcompound.getDouble("heat");
        this.typeWork = EnumTypeWork.values()[nbttagcompound.getInt("typeWork")];
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        CompoundTag nbt = super.writeToNBT(nbttagcompound);
        nbt.putBoolean("work", this.work);
        nbt.putInt("pressure", this.pressure);
        nbt.putInt("level", this.levelBlock);
        this.timer.writeNBT(nbt);
        CompoundTag nbt1 = new CompoundTag();
        this.red_timer.writeNBT(nbt1);
        nbt.put("red", (Tag)nbt1);
        CompoundTag nbt2 = new CompoundTag();
        this.yellow_timer.writeNBT(nbt2);
        nbt.put("yellow", (Tag)nbt2);
        nbt.putDouble("heat", this.heat);
        nbt.putInt("typeWork", this.typeWork.ordinal());
        return nbt;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        return super.writePacket();
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        return super.writeUpdatePacket();
    }

    @Override
    public void updateAfterAssembly() {
        IMultiElement compressor;
        int i;
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        for (i = 0; i < pos1.size(); ++i) {
            int k = i % 4;
            ITank tank = (ITank)this.getWorld().getBlockEntity(pos1.get(i));
            switch (k) {
                case 0: {
                    tank.setFluid((Fluid)Fluids.WATER);
                    if (tank.getTank().getFluid().isEmpty() || tank.getTank().getFluid().getFluid().equals(Fluids.WATER)) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
                case 1: {
                    tank.setFluid((Fluid)FluidName.fluidco2.getInstance().get());
                    if (tank.getTank().getFluid().isEmpty() || tank.getTank().getFluid().getFluid().equals(FluidName.fluidco2.getInstance().get())) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
                case 2: {
                    tank.setFluid((Fluid)FluidName.fluidsteam.getInstance().get());
                    if (tank.getTank().getFluid().isEmpty() || tank.getTank().getFluid().getFluid().equals(FluidName.fluidsteam.getInstance().get())) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
                case 3: {
                    tank.setFluid((Fluid)FluidName.fluidoxy.getInstance().get());
                    if (tank.getTank().getFluid().isEmpty() || tank.getTank().getFluid().getFluid().equals(FluidName.fluidoxy.getInstance().get())) break;
                    tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            this.cells.add(tank.getTank());
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IGraphiteController.class);
        i = 0;
        for (BlockPos pos2 : pos1) {
            IGraphiteController recirculationPump = (IGraphiteController)this.getWorld().getBlockEntity(pos2);
            recirculationPump.setIndex(i);
            this.listGraphiteController.add(recirculationPump);
            ++i;
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICapacitor.class);
        for (BlockPos pos2 : pos1) {
            ICapacitor iInterCooler = (ICapacitor)this.getWorld().getBlockEntity(pos2);
            this.listCapacitor.add(iInterCooler);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IExchanger.class);
        for (BlockPos pos2 : pos1) {
            compressor = (IExchanger)this.getWorld().getBlockEntity(pos2);
            this.listExchanger.add((IExchanger)compressor);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICooling.class);
        for (BlockPos pos2 : pos1) {
            compressor = (ICooling)this.getWorld().getBlockEntity(pos2);
            this.listCoolant.add((ICooling)compressor);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        for (BlockPos pos2 : pos1) {
            ISocket socket = (ISocket)this.getWorld().getBlockEntity(pos2);
            this.energy = socket.getEnergy();
        }
        this.reactor = new LogicGraphiteReactor(this);
        this.reactor.temp_heat = this.heat;
        new PacketUpdateFieldTile(this, "reactor", this.reactor.getGeneration());
        this.reactorsModules.load();
        if (this.isFull() && this.typeWork == EnumTypeWork.LEVEL_INCREASE) {
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            switch (this.levelBlock) {
                case 0: {
                    this.energy.setCapacity(4000000.0);
                    break;
                }
                case 1: {
                    this.energy.setCapacity(5.0E7);
                    break;
                }
                case 2: {
                    this.energy.setCapacity(2.0E8);
                    break;
                }
                case 3: {
                    this.energy.setCapacity(5.0E8);
                }
            }
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public boolean isWork() {
        return this.work;
    }

    @Override
    public void setWork(boolean work) {
        this.work = work;
        if (this.work) {
            this.setSecurity(EnumTypeSecurity.STABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.NONE);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiGraphiteController((ContainerGraphiteReactor)menu);
    }

    public ContainerGraphiteReactor getGuiContainer(Player entityPlayer) {
        return new ContainerGraphiteReactor(this, entityPlayer);
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(double var1) {
        this.heat = var1;
        if (this.heat > (double)this.getMaxHeat()) {
            this.heat = this.getMaxHeat();
        }
        if (this.getStableMaxHeat() == 0) {
            this.setSecurity(EnumTypeSecurity.STABLE);
            this.setTime(EnumTypeSecurity.STABLE);
        } else if (this.heat < (double)this.getStableMaxHeat()) {
            this.setSecurity(EnumTypeSecurity.STABLE);
            this.setTime(EnumTypeSecurity.STABLE);
        } else if (this.heat >= (double)this.getStableMaxHeat() && this.heat <= (double)this.getStableMaxHeat() + (double)(this.getMaxHeat() - this.getStableMaxHeat()) * 0.75) {
            this.setSecurity(EnumTypeSecurity.UNSTABLE);
            this.setTime(EnumTypeSecurity.UNSTABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.ERROR);
            this.setTime(EnumTypeSecurity.ERROR);
        }
    }

    @Override
    public void setUpdate() {
        this.reactor = null;
    }

    @Override
    public int getBlockLevel() {
        return this.enumFluidReactors.ordinal();
    }

    @Override
    public int getMaxHeat() {
        return (int)((double)this.enumFluidReactors.getMaxHeat() * this.reactorsModules.getStableHeat());
    }

    @Override
    public int getStableMaxHeat() {
        return (int)((double)this.enumFluidReactors.getMaxStable() * this.reactorsModules.getStableHeat());
    }

    @Override
    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public double getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(double output) {
        this.output = output * this.reactorsModules.getGeneration();
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.reactorsElements.get(y * this.getWidth() + x);
    }

    @Override
    public void setItemAt(int x, int y) {
        this.reactorsElements.set(y * this.getWidth() + x, ItemStack.EMPTY);
    }

    @Override
    public void explode() {
        int weight = this.getMultiBlockStucture().maxWeight + this.getMultiBlockStucture().minWeight;
        int height = this.getMultiBlockStucture().maxHeight + this.getMultiBlockStucture().minHeight;
        int length = this.getMultiBlockStucture().maxLength + this.getMultiBlockStucture().maxLength;
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        ChunkPos chunkPos = this.getWorld().getChunkAt(this.pos).getPos();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                chunkPosList.add(new ChunkPos(chunkPos.x + x, chunkPos.z + z));
            }
        }
        double rad = this.rad.getEnergy() / 9.0;
        this.setFull(false);
        this.activate = false;
        Explosion explosion = new Explosion(this.level, null, (double)(this.getPos().getX() + weight), (double)(this.getPos().getY() + height), (double)(this.getPos().getZ() + length), 25.0f, false, Explosion.BlockInteraction.KEEP);
        this.level.setBlock(this.pos, Blocks.AIR.defaultBlockState(), 3);
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.getMultiBlockStucture().blockPosMap.entrySet()) {
            if (this.level.random.nextInt(2) == 0) continue;
            this.level.setBlock(switch (Direction.values()[this.facing]) {
                case Direction.NORTH -> this.pos.offset((Vec3i)entry.getKey());
                case Direction.EAST -> this.pos.offset(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> this.pos.offset(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                case Direction.SOUTH -> this.pos.offset(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + this.facing);
            }, Blocks.AIR.defaultBlockState(), 3);
        }
        if (this.level.dimension() == Level.OVERWORLD) {
            for (ChunkPos pos1 : chunkPosList) {
                if (this.level.isClientSide) continue;
                if (!pos1.equals((Object)chunkPos)) {
                    new PacketUpdateRadiationValue(pos1, (int)(rad * 10.0), (ServerLevel)this.level);
                    continue;
                }
                new PacketUpdateRadiationValue(pos1, (int)(rad * 50.0), (ServerLevel)this.level);
            }
        }
        new PacketExplosion(explosion, 25, false, false);
    }

    public EnumTypeWork getTypeWork() {
        return this.typeWork;
    }

    public ComponentBaseEnergy getRad() {
        return this.rad;
    }

    @Override
    public void setRad(double rad) {
        this.rad.addEnergy(rad * this.reactorsModules.getRadiation());
        if (this.rad.getEnergy() >= this.rad.getCapacity()) {
            this.explode();
        }
    }

    @Override
    public ITypeRector getTypeRector() {
        return ITypeRector.FLUID;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTime(EnumTypeSecurity enumTypeSecurity) {
        if (this.security == enumTypeSecurity) {
            switch (enumTypeSecurity) {
                case STABLE: {
                    this.timer = new Timer(9999, 0, 0);
                    break;
                }
                case ERROR: {
                    this.timer = new Timer(0, 2, 30);
                    break;
                }
                case UNSTABLE: {
                    this.timer = new Timer(0, 15, 0);
                }
            }
        }
    }

    @Override
    public void workTimer() {
        switch (this.security) {
            case UNSTABLE: {
                this.yellow_timer.work();
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case STABLE: {
                this.timer.work();
                if (!this.yellow_timer.getMinute(15)) {
                    this.yellow_timer.rework();
                }
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case ERROR: {
                this.red_timer.work();
            }
        }
    }

    @Override
    public EnumTypeSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void setSecurity(EnumTypeSecurity enumTypeSecurity) {
        if (this.security != enumTypeSecurity) {
            this.security = enumTypeSecurity;
            new PacketUpdateFieldTile(this, "security", (Object)this.security);
        }
    }

    @Override
    public int getWidth() {
        return this.enumFluidReactors.getWidth();
    }

    @Override
    public int getHeight() {
        return this.enumFluidReactors.getHeight();
    }

    @Override
    public int getLevelReactor() {
        return this.levelBlock;
    }

    @Override
    public int getMaxLevelReactor() {
        return this.enumFluidReactors.ordinal() + 1;
    }

    @Override
    public void increaseLevelReactor() {
        ++this.levelBlock;
    }

    @Override
    public ComponentBaseEnergy getRadiation() {
        return this.rad;
    }

    @Override
    public FluidTank getWaterTank() {
        return this.cells.get(0);
    }

    @Override
    public FluidTank getCoalDioxideTank() {
        return this.cells.get(1);
    }

    @Override
    public ItemStack getGraphite(int index) {
        return this.listGraphiteController.get(index).getGraphite();
    }

    @Override
    public boolean canWorkWithGraphite() {
        List<Integer> list = this.reactor.getListIndexRod();
        for (int i : list) {
            if (!this.getGraphite(i).isEmpty() || !(this.getFuelGraphite(i) <= 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getLevelGraphite(int index) {
        return this.listGraphiteController.get(index).getLevelGraphite();
    }

    @Override
    public double getFuelGraphite(int index) {
        return this.listGraphiteController.get(index).getFuelGraphite();
    }

    @Override
    public void consumeFuelGraphite(int index, double fuel) {
        this.listGraphiteController.get(index).consumeFuelGraphite(fuel);
    }

    @Override
    public void consumeGraphite(int index) {
        this.listGraphiteController.get(index).consumeGraphite();
    }

    @Override
    public FluidTank getSteamTank() {
        return this.cells.get(2);
    }

    @Override
    public FluidTank getOxideTank() {
        return this.cells.get(3);
    }

    @Override
    public double workCoolant(double heat) {
        for (ICooling cooling : this.listCoolant) {
            heat = cooling.work(heat);
        }
        return heat;
    }

    @Override
    public double getMulHeatRod(int x, int y, ItemStack stack) {
        double coef = 1.0;
        for (ICapacitor capacitor : this.listCapacitor) {
            coef *= capacitor.getPercent(x);
        }
        return coef *= 1.0 + (double)(this.listGraphiteController.get(x).getLevelGraphite() - 1) / 55.0;
    }

    @Override
    public double getMulHeat(int x, int y, ItemStack stack) {
        double coef = 1.0;
        for (IExchanger exchanger : this.listExchanger) {
            coef *= exchanger.getPercent(x);
        }
        return coef;
    }

    @Override
    public double getMulOutput(int x, int y, ItemStack stack) {
        IGraphiteController controller = this.listGraphiteController.get(x);
        double level = 1.0 + ((double)controller.getLevelGraphite() - 0.25) * 0.05;
        return 1.0 * level;
    }

    @Override
    public void updateDataReactor() {
        this.reactor = null;
    }
}

