/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerCable;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.gui.GuiCable;
import com.denfop.gui.GuiCore;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.transport.DataCable;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.transport.types.ICableItem;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMultiCable
extends TileEntityInventory
implements IUpdatableTileEvent {
    public static final NumberFormat lossFormat = new DecimalFormat("0.00#");
    public static List<BlockEntityType<? extends TileEntityMultiCable>> list = new ArrayList<BlockEntityType<? extends TileEntityMultiCable>>();
    public ICableItem cableItem;
    public byte connectivity;
    public ItemStack stackFacade = ItemStack.EMPTY;
    @OnlyIn(value=Dist.CLIENT)
    public DataCable dataCable;
    private ResourceLocation texture;
    private List<Direction> blackList = new ArrayList<Direction>();

    public TileEntityMultiCable(ICableItem name, IMultiTileBlock tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
        this.cableItem = name;
        this.connectivity = 0;
        if (list != null && pos.equals((Object)BlockPos.ZERO)) {
            list.add(tileBlock.getBlockType());
        }
    }

    public List<Direction> getBlackList() {
        return this.blackList;
    }

    public ICableItem getCableItem() {
        return this.cableItem;
    }

    public ResourceLocation getTexture() {
        if (this.texture == null) {
            this.texture = ResourceLocation.tryBuild((String)"industrialupgrade", (String)("blocks/wiring/" + this.getCableItem().getMainPath() + "/" + this.getCableItem().getNameCable()));
        }
        return this.texture;
    }

    public void removeConductor() {
        this.getWorld().setBlock(this.pos, Blocks.AIR.defaultBlockState(), 3);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt = super.writeToNBT(nbt);
        CompoundTag nbt1 = new CompoundTag();
        if (!this.blackList.isEmpty()) {
            nbt1.putInt("size", this.blackList.size());
            for (int i = 0; i < this.blackList.size(); ++i) {
                nbt1.putInt(String.valueOf(i), this.blackList.get(i).ordinal());
            }
            nbt.put("list", (Tag)nbt1);
        }
        if (this.stackFacade != null && !this.stackFacade.isEmpty()) {
            CompoundTag nbt2 = new CompoundTag();
            this.stackFacade.save(this.provider, (Tag)nbt2);
            nbt.put("stackFacade", (Tag)nbt2);
        }
        return nbt;
    }

    @Override
    public <T> T getCapability(@NotNull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            return null;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.contains("list")) {
            CompoundTag tagList = nbtTagCompound.getCompound("list");
            int size = tagList.getInt("size");
            for (int i = 0; i < size; ++i) {
                this.blackList.add(Direction.values()[tagList.getInt(String.valueOf(i))]);
            }
        }
        if (nbtTagCompound.contains("stackFacade")) {
            CompoundTag stackFacade = nbtTagCompound.getCompound("stackFacade");
            this.stackFacade = ItemStack.parseOptional((HolderLookup.Provider)this.provider, (CompoundTag)stackFacade);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
            this.updateConnectivity();
        }
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.WOOL;
    }

    @Override
    public AABB getVisualBoundingBox() {
        return super.getVisualBoundingBox();
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        if (this.stackFacade == null || this.stackFacade.isEmpty() && !forCollision) {
            Direction[] var5;
            float th = this.cableItem.getThickness();
            float sp = (1.0f - th) / 2.0f;
            ArrayList<AABB> ret = new ArrayList<AABB>();
            ret.add(new AABB((double)sp, (double)sp, (double)sp, (double)(sp + th), (double)(sp + th), (double)(sp + th)));
            for (Direction facing : var5 = Direction.values()) {
                float zE;
                boolean hasConnection;
                boolean bl = hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                if (!hasConnection) continue;
                float zS = sp;
                float yS = sp;
                float xS = sp;
                float yE = zE = sp + th;
                float xE = zE;
                switch (facing) {
                    case DOWN: {
                        xS = sp + th;
                        xE = 1.0f;
                        break;
                    }
                    case UP: {
                        xS = 0.0f;
                        xE = sp;
                        break;
                    }
                    case NORTH: {
                        zS = sp + th;
                        zE = 1.0f;
                        break;
                    }
                    case SOUTH: {
                        zS = 0.0f;
                        zE = sp;
                        break;
                    }
                    case WEST: {
                        yS = sp + th;
                        yE = 1.0f;
                        break;
                    }
                    case EAST: {
                        yS = 0.0f;
                        yE = sp;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                ret.add(new AABB((double)xS, (double)yS, (double)zS, (double)xE, (double)yE, (double)zE));
            }
            return ret;
        }
        return super.getAabbs(forCollision);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }

    public void setConnectivity(byte connectivity) {
        if (this.connectivity != connectivity) {
            this.connectivity = connectivity;
            new PacketUpdateFieldTile(this, "connectivity", this.connectivity);
            Direction[] var5 = Direction.values();
            HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
            for (Direction facing : var5) {
                boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                booleanMap.put(facing, hasConnection);
            }
            this.setBlockState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getBlockState().setValue((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).setValue((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).setValue((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).setValue((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).setValue((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).setValue((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST))));
            this.getWorld().setBlock(this.worldPosition, this.getBlockState(), 3);
        }
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.level.isClientSide) {
            return false;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEmpty() && !this.stackFacade.isEmpty()) {
            this.stackFacade = ItemStack.EMPTY;
            new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
        }
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player var1, ContainerBase<?> var2) {
        return new GuiCable(this.getGuiContainer(var1));
    }

    public ContainerCable getGuiContainer(Player var1) {
        return new ContainerCable(var1, this);
    }

    @Override
    public BlockState getBlockState() {
        if (this.blockState == null) {
            try {
                Direction[] var5 = Direction.values();
                HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
                for (Direction facing : var5) {
                    boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                    booleanMap.put(facing, hasConnection);
                }
                this.blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.block.defaultBlockState().setValue((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).setValue(this.block.facingProperty, (Comparable)this.getFacing())).setValue((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).setValue((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).setValue((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).setValue((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).setValue((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).setValue((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST)));
            }
            catch (Exception e) {
                this.blockState = this.block.defaultBlockState();
            }
            return this.blockState;
        }
        return this.blockState;
    }

    public void updateConnectivity() {
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.getWorld().isClientSide && stack.getItem() == IUItem.facadeItem.getItem() && stack.has(DataComponentsInit.CONTAINER) && !((ContainerItem)stack.get(DataComponentsInit.CONTAINER)).listItem().isEmpty()) {
            Block block;
            ContainerItem containerItem = (ContainerItem)stack.get(DataComponentsInit.CONTAINER);
            this.stackFacade = containerItem.listItem().get(0).copy();
            Block block2 = block = this.stackFacade.getItem() instanceof BlockItem ? ((BlockItem)this.stackFacade.getItem()).getBlock() : Blocks.AIR;
            if (block != Blocks.AIR) {
                this.stackFacade = this.stackFacade.copy();
                new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
            } else {
                this.stackFacade = ItemStack.EMPTY;
            }
        } else if (stack.getItem() == IUItem.connect_item.getItem()) {
            return super.onActivated(player, hand, side, vec3);
        }
        if (this instanceof ITransportConductor) {
            boolean can;
            boolean bl = can = ((ITransportConductor)((Object)this)).isInput() || ((ITransportConductor)((Object)this)).isOutput();
            if (can) {
                return super.onActivated(player, hand, side, vec3);
            }
            return false;
        }
        return false;
    }

    public void rerenderCable(ItemStack stack) {
        this.stackFacade = stack != ItemStack.EMPTY ? stack.copy() : stack;
        new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("connectivity")) {
            try {
                this.connectivity = (Byte)DecoderHandler.decode(is);
                Direction[] var5 = Direction.values();
                HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
                for (Direction facing : var5) {
                    boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                    booleanMap.put(facing, hasConnection);
                }
                this.setBlockState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.block.defaultBlockState().setValue((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).setValue(this.block.facingProperty, (Comparable)this.getFacing())).setValue((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).setValue((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).setValue((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).setValue((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).setValue((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).setValue((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST))));
                this.getWorld().setBlock(this.worldPosition, super.getBlockState(), 3);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("stackFacade")) {
            try {
                this.stackFacade = (ItemStack)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.stackFacade);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.stackFacade = (ItemStack)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer buffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(buffer, this.blackList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.blackList = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasSpecialModel() {
        return true;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        byte event1 = (byte)var2;
        Direction facing1 = Direction.values()[event1];
        if (this.blackList.contains(facing1)) {
            this.blackList.remove(facing1);
        } else {
            this.blackList.add(facing1);
        }
    }
}

