/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein;

import com.denfop.IUItem;
import com.denfop.blocks.BlockDeposits;
import com.denfop.blocks.BlockDeposits1;
import com.denfop.blocks.BlockDeposits2;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinStructure;
import com.denfop.world.vein.VeinType;
import com.denfop.world.vein.noise.PerlinNoiseViewer;
import com.denfop.world.vein.noise.Point;
import com.denfop.world.vein.noise.ShellCluster;
import com.mojang.serialization.Codec;
import java.awt.Color;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.Tags;

public class AlgorithmVein
extends Feature<NoneFeatureConfiguration> {
    public static List<VeinStructure> veinStructureList = new LinkedList<VeinStructure>();
    public static ShellCluster volcano;
    public static Map<Integer, Map<Integer, Tuple<Color, Integer>>> shellClusterChuncks;
    static Random random;
    private static Map<ChunkPos, ChunkAccess> chunkPosChunkMap;
    private static List<ShellCluster> shellClusterList;

    public AlgorithmVein(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private static boolean generate(WorldGenLevel level, VeinType veinType, BlockPos blockPos, ChunkAccess chunk, int meta1, Color color) {
        block124: {
            block125: {
                BlockPos pos1;
                int chance_type;
                block123: {
                    int k;
                    int height2 = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ());
                    Holder biome = level.getBiome(new BlockPos(blockPos.getX(), height2, blockPos.getZ()));
                    if (color == Color.LIGHT_GRAY) {
                        veinType.setVein(TypeVein.SMALL);
                    } else if (color == Color.GRAY) {
                        veinType.setVein(TypeVein.MEDIUM);
                    } else if (color == Color.BLACK) {
                        veinType.setVein(TypeVein.BIG);
                    }
                    chance_type = random.nextInt(101);
                    if (chance_type > 15 || !biome.is(BiomeTags.IS_HILL)) break block123;
                    ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
                    int height = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ());
                    int radius = 10;
                    if (veinType.getVein() == TypeVein.SMALL) {
                        radius = level.getRandom().nextInt(4) + 2;
                    } else if (veinType.getVein() == TypeVein.MEDIUM) {
                        radius = level.getRandom().nextInt(6) + 3;
                    } else if (veinType.getVein() == TypeVein.BIG) {
                        radius = level.getRandom().nextInt(7) + 5;
                    }
                    BlockPos pos = new BlockPos(blockPos.getX(), (int)((double)height - (double)radius * 0.9 - (double)random.nextInt(35)), blockPos.getZ());
                    ChunkPos chunkPos = null;
                    ChunkAccess chunk1 = null;
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                double distance = Math.sqrt(x * x + y * y + z * z);
                                if (distance <= (double)radius && distance > (double)radius * 0.45) {
                                    int meta = random.nextInt(veinType.getOres().size());
                                    ChanceOre ore = veinType.getOres().get(meta);
                                    BlockPos pos12 = pos.offset(x, y, z);
                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = level.getChunk(pos12.getX() >> 4, pos12.getZ() >> 4, ChunkStatus.EMPTY, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.getPos();
                                    } else if (pos12.getX() >> 4 != chunkPos.x && pos12.getZ() >> 4 != chunk.getPos().z) {
                                        chunk1 = level.getChunk(pos12.getX() >> 4, pos12.getZ() >> 4, ChunkStatus.EMPTY, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.getPos();
                                    }
                                    if (!AlgorithmVein.canGenerateSphere(level, pos12, chunk1)) continue;
                                    blockPosList.add(pos12);
                                    AlgorithmVein.setBlockState1(level, pos12, ore.getBlock(), 2, chunk1);
                                    continue;
                                }
                                if (distance <= (double)radius && distance >= (double)radius * 0.35) {
                                    BlockPos pos13 = pos.offset(x, y, z);
                                    if (veinType.getHeavyOre() != null) {
                                        if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerateSphere(level, pos13, chunk1)) continue;
                                        blockPosList.add(pos13);
                                        AlgorithmVein.setBlockState1(level, pos13, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2, chunk1);
                                        continue;
                                    }
                                    int meta = random.nextInt(veinType.getOres().size());
                                    ChanceOre ore = veinType.getOres().get(meta);
                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                                    if (chunk1 == null || chunkPos == null) {
                                        chunk1 = level.getChunk(pos13.getX() >> 4, pos13.getZ() >> 4, ChunkStatus.EMPTY, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.getPos();
                                    } else if (pos13.getX() >> 4 != chunkPos.x && pos13.getZ() >> 4 != chunk.getPos().z) {
                                        chunk1 = level.getChunk(pos13.getX() >> 4, pos13.getZ() >> 4, ChunkStatus.EMPTY, false);
                                        if (chunk1 == null) continue;
                                        chunkPos = chunk1.getPos();
                                    }
                                    if (!AlgorithmVein.canGenerateSphere(level, pos13, chunk1)) continue;
                                    blockPosList.add(pos13);
                                    AlgorithmVein.setBlockState1(level, pos13, ore.getBlock(), 2, chunk1);
                                    continue;
                                }
                                if (!(distance <= (double)radius) || !(distance < (double)radius * 0.35)) continue;
                                BlockPos pos14 = pos.offset(x, y, z);
                                AlgorithmVein.setBlockState1(level, pos14, Blocks.AIR.defaultBlockState(), 2, chunk1);
                            }
                        }
                    }
                    int ii = 0;
                    switch (veinType.getVein()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case SMALL: {
                            int n = 5;
                            break;
                        }
                        case MEDIUM: {
                            int n = 10;
                            break;
                        }
                        case BIG: {
                            int n = k = 15;
                        }
                    }
                    while (ii < k && !blockPosList.isEmpty()) {
                        int y;
                        BlockPos pos15 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                        if (chunk1 == null) {
                            chunk1 = level.getChunk(pos15.getX() >> 4, pos15.getZ() >> 4, ChunkStatus.EMPTY, false);
                            chunkPos = chunk1.getPos();
                        } else if (pos15.getX() >> 4 != chunkPos.x && pos15.getZ() >> 4 != chunk.getPos().z) {
                            chunk1 = level.getChunk(pos15.getX() >> 4, pos15.getZ() >> 4, ChunkStatus.EMPTY, false);
                            chunkPos = chunk1.getPos();
                        }
                        int height1 = y = chunk1.getHeight(Heightmap.Types.WORLD_SURFACE, pos15.getX(), pos15.getZ());
                        BlockPos pos2 = null;
                        boolean need = false;
                        while (height1 - 3 < y) {
                            pos2 = new BlockPos(pos15.getX(), y - 1, pos15.getZ());
                            BlockState oldState = level.getBlockState(pos2);
                            pos2 = new BlockPos(pos15.getX(), y + 1, pos15.getZ());
                            BlockState upState = level.getBlockState(pos2);
                            pos2 = new BlockPos(pos15.getX(), y, pos15.getZ());
                            BlockState oldState1 = level.getBlockState(pos2);
                            boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                            if (canSpawn) {
                                need = true;
                                break;
                            }
                            --y;
                        }
                        blockPosList.remove(pos15);
                        if (!need) continue;
                        FluidState fluidState = level.getFluidState(pos2);
                        if (meta1 < 16) {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                        } else if (meta1 < 32) {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                        } else {
                            AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                        }
                        ++ii;
                    }
                    break block124;
                }
                if (chance_type > 80) break block125;
                AbstractList blockPosList = new LinkedList<BlockPos>();
                int height = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ());
                BlockPos pos = new BlockPos(blockPos.getX(), height / 2 + height / 4, blockPos.getZ());
                int x1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int y1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int z1 = random.nextInt(veinType.getVein().getMax()) + 3;
                int minX = 10;
                int minY = 10;
                int minZ = 10;
                int maxX = -10;
                int maxY = -10;
                int maxZ = -10;
                ChunkPos chunkPos = null;
                ChunkAccess chunk1 = null;
                for (int x = -x1; x < x1 + 1; ++x) {
                    for (int y = -y1; y < y1; ++y) {
                        for (int z = -z1; z < z1 + 1; ++z) {
                            int meta = random.nextInt(veinType.getOres().size());
                            ChanceOre ore = veinType.getOres().get(meta);
                            int need = Math.max(Math.max(x, y), z);
                            if (need < veinType.getVein().getMinNeed()) {
                                need = 0;
                            }
                            BlockPos pos16 = pos.offset(x, y, z);
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = level.getChunk(pos16.getX() >> 4, pos16.getZ() >> 4, ChunkStatus.EMPTY, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.getPos();
                            } else if (pos16.getX() >> 4 != chunkPos.x && pos16.getZ() >> 4 != chunk.getPos().z) {
                                chunk1 = level.getChunk(pos16.getX() >> 4, pos16.getZ() >> 4, ChunkStatus.EMPTY, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.getPos();
                            }
                            if (random.nextInt(50) > 10 && ore.needGenerate(level) && (need == 0 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) > 50) && AlgorithmVein.canGenerate(level, pos16, chunk1)) {
                                if (x < minX) {
                                    minX = x;
                                }
                                if (x > maxX) {
                                    maxX = x;
                                }
                                if (y < minY) {
                                    minY = y;
                                }
                                if (y > maxY) {
                                    maxY = y;
                                }
                                if (z < minZ) {
                                    minZ = z;
                                }
                                if (z > maxZ) {
                                    maxZ = z;
                                }
                                blockPosList.add(pos16);
                                AlgorithmVein.setBlockState1(level, pos16, ore.getBlock(), 2, chunk1);
                                continue;
                            }
                            if (veinType.getHeavyOre() == null || random.nextInt(50) <= 40 || random.nextInt(100 - Math.min(need * veinType.getVein().getNeed(), 90)) <= 50 || !AlgorithmVein.canGenerate(level, pos16, chunk1)) continue;
                            blockPosList.add(pos16);
                            AlgorithmVein.setBlockState1(level, pos16, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2, chunk1);
                            if (x < minX) {
                                minX = x;
                            }
                            if (x > maxX) {
                                maxX = x;
                            }
                            if (y < minY) {
                                minY = y;
                            }
                            if (y > maxY) {
                                maxY = y;
                            }
                            if (z < minZ) {
                                minZ = z;
                            }
                            if (z <= maxZ) continue;
                            maxZ = z;
                        }
                    }
                }
                int[] numbers = new int[]{maxY, minY, maxX, minX, maxZ, minZ};
                int[] number2 = new int[]{1, 0, 3, 2, 5, 4};
                int[] yxz = new int[]{0, 0, 0};
                int[][] yxz1 = new int[][]{{1, 2}, {0, 2}, {0, 1}};
                int[][] numbers1 = new int[][]{{3, 2, 5, 4}, {1, 0, 5, 4}, {1, 0, 3, 2}};
                chunk1 = null;
                chunkPos = null;
                int level1 = 1;
                int i = random.nextInt(6);
                while (level1 < veinType.getVein().getLevel() + 1) {
                    block130: {
                        ChanceOre ore;
                        int meta;
                        block126: {
                            if (i % 2 != 0) break block126;
                            yxz[i / 2] = numbers[i];
                            while (yxz[i / 2] < random.nextInt(veinType.getVein().getMax_length()) + 3 + numbers[i] + 1) {
                                yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level1 * 2;
                                while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level1 * 2 + 1) {
                                    yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level1 * 2;
                                    while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level1 * 2 + 1) {
                                        block127: {
                                            block129: {
                                                block128: {
                                                    meta = random.nextInt(veinType.getOres().size());
                                                    ore = veinType.getOres().get(meta);
                                                    if (!ore.needGenerate(level) || random.nextInt(100) <= 50) break block127;
                                                    pos1 = pos.offset(yxz[1], yxz[0], yxz[2]);
                                                    if (chunk1 != null && chunkPos != null) break block128;
                                                    chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                                                    if (chunk1 == null) break block127;
                                                    chunkPos = chunk1.getPos();
                                                    break block129;
                                                }
                                                if (pos1.getX() >> 4 == chunkPos.x || pos1.getZ() >> 4 == chunk.getPos().z) break block129;
                                                chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                                                if (chunk1 == null) break block127;
                                                chunkPos = chunk1.getPos();
                                            }
                                            if (AlgorithmVein.canGenerate(level, pos1, chunk1)) {
                                                blockPosList.add(pos1);
                                                AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                                            }
                                        }
                                        int n = yxz1[i / 2][1];
                                        yxz[n] = yxz[n] + 1;
                                    }
                                    int n = yxz1[i / 2][0];
                                    yxz[n] = yxz[n] + 1;
                                }
                                int n = i / 2;
                                yxz[n] = yxz[n] + 1;
                            }
                            break block130;
                        }
                        yxz[i / 2] = numbers[i];
                        while (yxz[i / 2] > numbers[i] - random.nextInt(veinType.getVein().getMax_length()) - 4) {
                            yxz[yxz1[i / 2][0]] = numbers[numbers1[i / 2][0]] + level1 * 2;
                            while (yxz[yxz1[i / 2][0]] < numbers[numbers1[i / 2][1]] - level1 * 2 + 1) {
                                yxz[yxz1[i / 2][1]] = numbers[numbers1[i / 2][2]] + level1 * 2;
                                while (yxz[yxz1[i / 2][1]] < numbers[numbers1[i / 2][3]] - level1 * 2 + 1) {
                                    block131: {
                                        block133: {
                                            block132: {
                                                meta = random.nextInt(veinType.getOres().size());
                                                ore = veinType.getOres().get(meta);
                                                if (!ore.needGenerate(level) || random.nextInt(100) <= 50) break block131;
                                                pos1 = pos.offset(yxz[1], yxz[0], yxz[2]);
                                                if (chunk1 != null && chunkPos != null) break block132;
                                                chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                                                if (chunk1 == null) break block131;
                                                chunkPos = chunk1.getPos();
                                                break block133;
                                            }
                                            if (pos1.getX() >> 4 == chunkPos.x || pos1.getZ() >> 4 == chunk.getPos().z) break block133;
                                            chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                                            if (chunk1 == null) break block131;
                                            chunkPos = chunk1.getPos();
                                        }
                                        if (AlgorithmVein.canGenerate(level, pos1, chunk1)) {
                                            blockPosList.add(pos1);
                                            AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                                        }
                                    }
                                    int n = yxz1[i / 2][1];
                                    yxz[n] = yxz[n] + 1;
                                }
                                int n = yxz1[i / 2][0];
                                yxz[n] = yxz[n] + 1;
                            }
                            int n = i / 2;
                            yxz[n] = yxz[n] - 1;
                        }
                    }
                    int n = number2[i];
                    numbers[n] = numbers[n] + (yxz[i / 2] - numbers[i]);
                    numbers[i] = yxz[i / 2];
                    ++level1;
                    int prev = i;
                    random.nextInt();
                    i = random.nextInt(6);
                    while (i != prev) {
                        i = random.nextInt(6);
                    }
                }
                int k = 0;
                switch (veinType.getVein()) {
                    case SMALL: {
                        k = 5;
                        break;
                    }
                    case MEDIUM: {
                        k = 10;
                        break;
                    }
                    case BIG: {
                        k = 15;
                    }
                }
                chunk1 = null;
                int ii = 0;
                blockPosList = new ArrayList(blockPosList);
                while (ii < k && !blockPosList.isEmpty()) {
                    int y;
                    pos1 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                    if (chunk1 == null) {
                        chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                        if (chunk1 == null) {
                            ++i;
                            continue;
                        }
                        chunkPos = chunk1.getPos();
                    } else if (pos1.getX() >> 4 != chunkPos.x && pos1.getZ() >> 4 != chunk.getPos().z) {
                        chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                        if (chunk1 == null) {
                            ++i;
                            continue;
                        }
                        chunkPos = chunk1.getPos();
                    }
                    int height1 = y = chunk1.getHeight(Heightmap.Types.WORLD_SURFACE, pos1.getX(), pos1.getZ());
                    BlockPos pos2 = null;
                    boolean need = false;
                    while (height1 - 3 < y) {
                        pos2 = new BlockPos(pos1.getX(), y - 1, pos1.getZ());
                        BlockState oldState = level.getBlockState(pos2);
                        pos2 = new BlockPos(pos1.getX(), y + 1, pos1.getZ());
                        BlockState upState = level.getBlockState(pos2);
                        pos2 = new BlockPos(pos1.getX(), y, pos1.getZ());
                        BlockState oldState1 = level.getBlockState(pos2);
                        boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                        if (canSpawn) {
                            need = true;
                            break;
                        }
                        --y;
                    }
                    blockPosList.remove(pos1);
                    if (!need) continue;
                    FluidState fluidState = level.getFluidState(pos2);
                    if (meta1 < 16) {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                    } else if (meta1 < 32) {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                    } else {
                        AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                    }
                    ++ii;
                }
                break block124;
            }
            int height = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ());
            BlockPos pos = new BlockPos(blockPos.getX(), height / 2 + height / 4, blockPos.getZ());
            int centerX = pos.getX();
            int centerY = pos.getY();
            int centerZ = pos.getZ();
            int R = 0;
            int r = 0;
            int y1 = 0;
            if (veinType.getVein() == TypeVein.SMALL) {
                R = level.getRandom().nextInt(4) + 3;
                r = level.getRandom().nextInt(3) + 2;
                y1 = level.getRandom().nextInt(3) + 1;
            } else if (veinType.getVein() == TypeVein.MEDIUM) {
                R = level.getRandom().nextInt(6) + 3;
                r = level.getRandom().nextInt(4) + 3;
                y1 = level.getRandom().nextInt(3) + 2;
            } else if (veinType.getVein() == TypeVein.BIG) {
                R = level.getRandom().nextInt(7) + 5;
                r = level.getRandom().nextInt(4) + 4;
                y1 = level.getRandom().nextInt(5) + 3;
            }
            AbstractList blockPosList = new LinkedList();
            ChunkPos chunkPos = null;
            ChunkAccess chunk1 = null;
            for (int y2 = centerY - y1; y2 < centerY + y1; ++y2) {
                for (int x = -(R + r); x <= R + r; ++x) {
                    for (int z = -(R + r); z <= R + r; ++z) {
                        ChanceOre ore;
                        int meta;
                        BlockPos pos1;
                        if (x * x + z * z <= (R + r) * (R + r) && x * x + z * z > r * r) {
                            pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                            meta = random.nextInt(veinType.getOres().size());
                            ore = veinType.getOres().get(meta);
                            if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                            if (chunk1 == null || chunkPos == null) {
                                chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.getPos();
                            } else if (pos1.getX() >> 4 != chunkPos.x && pos1.getZ() >> 4 != chunk.getPos().z) {
                                chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                                if (chunk1 == null) continue;
                                chunkPos = chunk1.getPos();
                            }
                            if (!AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                            blockPosList.add(pos1);
                            AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                            continue;
                        }
                        if (x * x + z * z > (R + r) * (R + r) || x * x + z * z < r * r) continue;
                        pos1 = new BlockPos(centerX + x, y2, centerZ + z);
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.getPos();
                        } else if (pos1.getX() >> 4 != chunkPos.x && pos1.getZ() >> 4 != chunk.getPos().z) {
                            chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.getPos();
                        }
                        if (veinType.getHeavyOre() != null) {
                            if (random.nextInt(100) <= 40 || !AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                            blockPosList.add(pos1);
                            AlgorithmVein.setBlockState1(level, pos1, veinType.getHeavyOre().getStateMeta(veinType.getMeta()), 2, chunk1);
                            continue;
                        }
                        meta = random.nextInt(veinType.getOres().size());
                        ore = veinType.getOres().get(meta);
                        if (!ore.needGenerate(level) || random.nextInt(100) <= 50) continue;
                        if (chunk1 == null || chunkPos == null) {
                            chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.getPos();
                        } else if (pos1.getX() >> 4 != chunkPos.x && pos1.getZ() >> 4 != chunk.getPos().z) {
                            chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                            if (chunk1 == null) continue;
                            chunkPos = chunk1.getPos();
                        }
                        if (!AlgorithmVein.canGenerate(level, pos1, chunk1)) continue;
                        blockPosList.add(pos1);
                        AlgorithmVein.setBlockState1(level, pos1, ore.getBlock(), 2, chunk1);
                    }
                }
            }
            chunk1 = null;
            int ii = 0;
            int k = 0;
            switch (veinType.getVein()) {
                case SMALL: {
                    k = 5;
                    break;
                }
                case MEDIUM: {
                    k = 10;
                    break;
                }
                case BIG: {
                    k = 15;
                }
            }
            blockPosList = new ArrayList(blockPosList);
            while (ii < k && !blockPosList.isEmpty()) {
                int y;
                BlockPos pos1 = (BlockPos)blockPosList.get(random.nextInt(blockPosList.size()));
                if (chunk1 == null) {
                    chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                    chunkPos = chunk1.getPos();
                } else if (pos1.getX() >> 4 != chunkPos.x && pos1.getZ() >> 4 != chunk.getPos().z) {
                    chunk1 = level.getChunk(pos1.getX() >> 4, pos1.getZ() >> 4, ChunkStatus.EMPTY, false);
                    chunkPos = chunk1.getPos();
                }
                int height1 = y = chunk1.getHeight(Heightmap.Types.WORLD_SURFACE, pos1.getX(), pos1.getZ());
                BlockPos pos2 = null;
                boolean need = false;
                while (height1 - 3 < y) {
                    pos2 = new BlockPos(pos1.getX(), y - 1, pos1.getZ());
                    BlockState oldState = level.getBlockState(pos2);
                    pos2 = new BlockPos(pos1.getX(), y + 1, pos1.getZ());
                    BlockState upState = level.getBlockState(pos2);
                    pos2 = new BlockPos(pos1.getX(), y, pos1.getZ());
                    BlockState oldState1 = level.getBlockState(pos2);
                    boolean canSpawn = AlgorithmVein.canSpawn(oldState, oldState1, upState);
                    if (canSpawn) {
                        need = true;
                        break;
                    }
                    --y;
                }
                blockPosList.remove(pos1);
                if (!need) continue;
                FluidState fluidState = level.getFluidState(pos2);
                if (meta1 < 16) {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits)IUItem.blockdeposits.getBlock(BlockDeposits.Type.getFromID(meta1)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                } else if (meta1 < 32) {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits1)IUItem.blockdeposits1.getBlock(BlockDeposits1.Type.getFromID(meta1 - 16)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                } else {
                    AlgorithmVein.setBlockState1(level, pos2, (BlockState)((BlockDeposits2)IUItem.blockdeposits2.getBlock(BlockDeposits2.Type.getFromID(meta1 - 32)).get()).defaultBlockState().setValue((Property)BlockDeposits.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState != Fluids.EMPTY.defaultFluidState() && fluidState.getType() == Fluids.WATER)), 3, chunk1);
                }
                ++ii;
            }
        }
        chunkPosChunkMap.clear();
        return true;
    }

    public static void setBlockState1(WorldGenLevel level, BlockPos pPos, BlockState pState, int p_46607_, ChunkAccess access) {
        if (access != null) {
            access.setBlockState(pPos, pState, false);
        } else {
            ChunkPos chunkPos = new ChunkPos(pPos);
            level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.EMPTY, false).setBlockState(pPos, pState, false);
        }
    }

    private static boolean canGenerateSphere(WorldGenLevel world, BlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.getBlockState(pos);
        FluidState fluidState = chunk.getFluidState(pos);
        if (state.isAir() || state.liquid()) {
            return false;
        }
        if (!fluidState.isEmpty()) {
            return false;
        }
        if (pos.getY() >= world.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - 4) {
            return state.is(Tags.Blocks.STONES);
        }
        return state.is(Tags.Blocks.STONES);
    }

    private static boolean canSpawn(BlockState underState, BlockState state, BlockState upState) {
        boolean can;
        Block block = underState.getBlock();
        boolean bl = can = block == Blocks.GRASS_BLOCK || block == Blocks.GRAVEL || block == Blocks.DIRT || block == Blocks.SAND || block == Blocks.COBBLESTONE || block == Blocks.STONE;
        if (can) {
            if (AlgorithmVein.isCoralOrCoralBlock(underState) || AlgorithmVein.isWaterPlant(underState)) {
                return false;
            }
            return state.isAir() || state.getMapColor(null, null) == MapColor.PLANT || state.liquid();
        }
        return false;
    }

    private static boolean canGenerate(WorldGenLevel world, BlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.getBlockState(pos);
        FluidState fluidState = chunk.getFluidState(pos);
        if (state.isAir() || state.liquid()) {
            return false;
        }
        if (!fluidState.isEmpty()) {
            return false;
        }
        if (pos.getY() >= world.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) - 4) {
            return state.is(Tags.Blocks.STONES);
        }
        return state.is(Tags.Blocks.STONES);
    }

    private static boolean isCoralOrCoralBlock(BlockState state) {
        return state.is(BlockTags.CORALS) || state.is(BlockTags.CORAL_BLOCKS);
    }

    private static boolean isWaterPlant(BlockState state) {
        Block b = state.getBlock();
        return b instanceof SeagrassBlock || b instanceof KelpBlock || b == Blocks.SEAGRASS || b == Blocks.TALL_SEAGRASS || b == Blocks.KELP || b == Blocks.KELP_PLANT || b == Blocks.SEA_PICKLE;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159749_) {
        if (shellClusterChuncks.isEmpty()) {
            shellClusterList = PerlinNoiseViewer.createClusters(p_159749_.random());
            shellClusterList = new ArrayList<ShellCluster>(shellClusterList);
            for (ShellCluster cluster : shellClusterList) {
                Map tupleMap;
                if (WorldBaseGen.veinTypes1.isEmpty()) {
                    WorldBaseGen.veinTypes1 = new ArrayList<VeinType>(WorldBaseGen.veinTypes);
                }
                int meta = WorldBaseGen.random.nextInt(WorldBaseGen.veinTypes1.size());
                VeinType veinType = WorldBaseGen.veinTypes1.remove(meta);
                for (Point point : cluster.blacks) {
                    tupleMap = shellClusterChuncks.computeIfAbsent(point.x - 256, k -> new HashMap());
                    tupleMap.put(point.y - 256, new Tuple((Object)Color.BLACK, (Object)veinType.getId()));
                }
                for (Point point : cluster.grays) {
                    tupleMap = shellClusterChuncks.computeIfAbsent(point.x - 256, k -> new HashMap());
                    tupleMap.put(point.y - 256, new Tuple((Object)Color.GRAY, (Object)veinType.getId()));
                }
                for (Point point : cluster.lightGrays) {
                    tupleMap = shellClusterChuncks.computeIfAbsent(point.x - 256, k -> new HashMap());
                    tupleMap.put(point.y - 256, new Tuple((Object)Color.LIGHT_GRAY, (Object)veinType.getId()));
                }
            }
            volcano = PerlinNoiseViewer.createVolcanoClusters(p_159749_.random());
        }
        BlockPos origin = p_159749_.origin();
        ChunkPos chunkPos = new ChunkPos(origin);
        Map<Integer, Tuple<Color, Integer>> tupleMap = shellClusterChuncks.get(chunkPos.x % 256);
        if (tupleMap == null) {
            return false;
        }
        Tuple<Color, Integer> tuple = tupleMap.get(chunkPos.z % 256);
        if (tuple != null) {
            ChunkAccess chunk = p_159749_.level().getChunk(chunkPos.x, chunkPos.z, ChunkStatus.EMPTY, false);
            VeinType veinType = VeinType.veinTypeMap.get(tuple.getB());
            Color color = (Color)tuple.getA();
            VeinStructure veinStructure = new VeinStructure(p_159749_.level(), veinType, new BlockPos(chunkPos.x * 16 + random.nextInt(16), 2, chunkPos.z * 16 + random.nextInt(16)), chunk, veinType.getDeposits_meta());
            return AlgorithmVein.generate(p_159749_.level(), veinStructure.getVeinType(), veinStructure.getBlockPos(), veinStructure.getChunk(), veinStructure.getDepositsMeta(), color);
        }
        return false;
    }

    static {
        shellClusterChuncks = new HashMap<Integer, Map<Integer, Tuple<Color, Integer>>>();
        random = new Random();
        chunkPosChunkMap = new HashMap<ChunkPos, ChunkAccess>();
        shellClusterList = new ArrayList<ShellCluster>();
    }
}

