/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.api.gui.Component;
import com.denfop.api.gui.ComponentCustomizeSize;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.EnumTypeRender;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.api.recipe.InvSlotMultiRecipes;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.vein.Vein;
import com.denfop.componets.BioProcessMultiComponent;
import com.denfop.componets.ComponentBioProcessRender;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentProcessRender;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.ComponentSteamProcessRender;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.ComponentValue;
import com.denfop.componets.PressureComponent;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.componets.SteamProcessMultiComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.SlotInvSlot;
import com.denfop.container.SlotVirtual;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiIU;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class GuiComponent
extends GuiElement<GuiComponent> {
    public static final ResourceLocation commonTexture1 = new ResourceLocation("industrialupgrade", "textures/gui/gui_progressbars.png");
    public static final ResourceLocation commonTexture2 = new ResourceLocation("industrialupgrade", "textures/gui/gui_progressbars.png");
    public static final ResourceLocation commonTexture5 = new ResourceLocation("industrialupgrade", "textures/gui/slot_render.png");
    private final EnumTypeComponent type;
    private final Component<?> component;
    private final GuiIU<?> gui_iu;
    private int index = 0;

    public GuiComponent(GuiIU<?> gui, int x, int y, EnumTypeComponent type, Component<?> component) {
        super(gui, x, y, type.getWeight(), type.getHeight());
        this.type = type;
        this.gui_iu = gui;
        this.component = component;
    }

    public GuiComponent(GuiIU<?> gui, int x, int y, int width, int height, Component<?> component) {
        super(gui, x, y, width, height);
        this.type = null;
        this.gui_iu = gui;
        this.component = component;
    }

    public static void addLines(List<String> list, String str) {
        int pos;
        int startPos = 0;
        while ((pos = str.indexOf(10, startPos)) != -1) {
            list.add(GuiComponent.processText(str.substring(startPos, pos)));
            startPos = pos + 1;
        }
        if (startPos == 0) {
            list.add(GuiComponent.processText(str));
        } else {
            list.add(GuiComponent.processText(str.substring(startPos)));
        }
    }

    public static void bindCommonTexture() {
        GuiCore.bindTexture(commonTexture1);
    }

    @Override
    public boolean visible() {
        return true;
    }

    public Component<?> getComponent() {
        return this.component;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void buttonClicked(int mouseX, int mouseY) {
        if (this.component.getComponent() instanceof ComponentButton && this.contains(mouseX, mouseY)) {
            ComponentButton button = (ComponentButton)this.component.getComponent();
            button.ClickEvent();
        }
    }

    public EnumTypeComponent getType() {
        return this.type;
    }

    @Override
    public GuiCore<?> getGui() {
        return this.gui;
    }

    @Override
    public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
        if (this.contains(mouseX, mouseY) && !this.suppressTooltip(mouseX, mouseY)) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if ((this.getType() == null || this.getType().isHasDescription()) && (tooltip = this.component.getText(this)) != null && !tooltip.isEmpty()) {
                GuiComponent.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
        if (this.component.getComponent() instanceof PressureComponent) {
            PressureComponent pressureComponent = (PressureComponent)this.component.getComponent();
            this.gui_iu.drawString(poseStack, String.valueOf(pressureComponent.storage), this.x + 2, this.y + 2, 0x404040);
            if (mouseX >= this.x - 2 && mouseX <= this.x + 4 + this.gui_iu.getStringWidth(String.valueOf(pressureComponent.storage)) && mouseY >= this.y + 2 && mouseY <= this.y + 10) {
                List<String> lines = this.getToolTip();
                String tooltip = this.component.getText(this);
                if (tooltip != null && !tooltip.isEmpty()) {
                    GuiComponent.addLines(lines, tooltip);
                }
                if (!lines.isEmpty()) {
                    this.gui.drawTooltip(mouseX, mouseY, lines);
                }
            }
        }
    }

    public void renderBar(GuiGraphics poseStack, int mouseX, int mouseY, double bar) {
        GuiCore.bindTexture(commonTexture1);
        if (this.component.getComponent() instanceof ComponentProcessRender) {
            int down;
            ComponentProcessRender component = (ComponentProcessRender)this.component.getComponent();
            EnumTypeMachines type_machines = component.getTypeMachines();
            int x = 0;
            int xx = 0;
            int yy = 0;
            int xx1 = 0;
            int yy1 = 0;
            int xx2 = 0;
            switch (type_machines) {
                case MACERATOR: 
                case COMBMACERATOR: {
                    down = 0;
                    xx -= 2;
                    break;
                }
                case COMPRESSOR: {
                    down = 24;
                    xx1 += 3;
                    yy -= 2;
                    ++yy1;
                    break;
                }
                case ELECTRICFURNACE: {
                    down = 54;
                    xx -= 2;
                    break;
                }
                case EXTRACTOR: {
                    down = 79;
                    --xx;
                    xx1 += 2;
                    ++x;
                    break;
                }
                case METALFOMER: 
                case ROLLING: 
                case CUTTING: 
                case EXTRUDING: {
                    down = 68;
                    --xx;
                    x += 37;
                    xx1 += 0;
                    break;
                }
                case RECYCLER: 
                case COMBRECYCLER: {
                    down = 90;
                    --xx;
                    x += 36;
                    xx1 += 2;
                    break;
                }
                case FARMER: {
                    down = 112;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case ASSAMPLERSCRAP: {
                    down = 136;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case OreWashing: {
                    down = 46;
                    --xx;
                    x += 36;
                    yy -= 2;
                    xx1 += 2;
                    break;
                }
                case Centrifuge: {
                    down = 160;
                    --xx;
                    x += 38;
                    --yy;
                    --xx1;
                    break;
                }
                case Gearing: {
                    down = 183;
                    --xx;
                    x += 35;
                    xx1 += 4;
                    yy1 -= 5;
                    yy += 2;
                    ++xx2;
                    break;
                }
                default: {
                    down = 0;
                }
            }
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + x, this.type.getY() + down, this.type.getWeight() + 1 + xx2, this.type.getHeight() + yy1);
            int progress = (int)((double)(24.0f + (float)yy1) * bar);
            progress = Math.min(progress, 24 + yy1);
            if (progress >= 0) {
                if (x < 0) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + 2 + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                } else {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                }
            }
        } else {
            if (this.type.isNextBar()) {
                GuiComponent.bindCommonTexture2();
            }
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
            if (this.type.getRender() == EnumTypeRender.WIDTH) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), (int)(bar * (double)this.type.getWeight()), this.type.getHeight());
            }
            if (this.type.getRender() == EnumTypeRender.HEIGHT) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), this.type.getWeight(), (int)(bar * (double)this.type.getHeight()));
            }
        }
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        if (this.component == null || this.component.getComponent() == null || !this.visible() || this.type == null) {
            return;
        }
        GuiComponent.bindCommonTexture();
        if (this.type.isNextBar()) {
            GuiComponent.bindCommonTexture2();
        }
        if (this.type.isSteam()) {
            GuiComponent.bindCommonTexture3();
        }
        if (this.type.isBio()) {
            GuiComponent.bindCommonTexture4();
        }
        if (this.type.isSpace()) {
            GuiComponent.bindCommonTexture5();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.component.getComponent() instanceof ComponentCustomizeSize) {
            ComponentCustomizeSize componentSoundButton = (ComponentCustomizeSize)this.component.getComponent();
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), componentSoundButton.getWidth(), componentSoundButton.getHeight());
        } else if (this.component.getComponent() instanceof ComponentButton) {
            if (this.component.getComponent() instanceof ComponentSoundButton) {
                ComponentSoundButton componentSoundButton = (ComponentSoundButton)this.component.getComponent();
                if (componentSoundButton.getAudioFixer().getEnable()) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                } else {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), this.type.getWeight(), this.type.getHeight());
                }
            } else {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                ComponentButton button = (ComponentButton)this.component.getComponent();
                if (button.active()) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), this.type.getWeight(), this.type.getHeight());
                }
            }
            return;
        }
        if (!(this.component.getComponent() instanceof ComponentRenderInventory || this.component.getComponent() instanceof ComponentProcessRender || this.component.getComponent() instanceof ComponentValue || this.component.getComponent() instanceof ComponentSteamProcessRender || this.component.getComponent() instanceof ComponentBioProcessRender || this.component.getComponent() instanceof ComponentTimer || this.component.getComponent() instanceof ComponentProgress || this.component.getComponent() instanceof Vein)) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
            this.component.drawBackground(poseStack, mouseX, mouseY, this);
        } else if (this.component.getComponent() instanceof ComponentProgress) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
            component = (ComponentProgress)this.component.getComponent();
            double scale = ((ComponentProgress)component).getBar();
            if (this.type.getRender() == EnumTypeRender.WIDTH) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), (int)(Math.min(1.0, scale) * (double)this.type.getWeight()), this.type.getHeight());
            }
            if (this.type.getRender() == EnumTypeRender.HEIGHT) {
                if (this.type != EnumTypeComponent.FIRE) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), this.type.getWeight(), (int)(scale * (double)this.type.getHeight()));
                } else {
                    int chargeLevel = (int)(scale *= (double)this.type.getHeight());
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.getX() + this.type.getEndX(), mouseY + this.type.getEndY() + this.getY() + this.type.getHeight() - chargeLevel, this.type.getX1(), this.type.getY1() + this.type.getHeight() - chargeLevel, this.type.getWeight(), chargeLevel);
                }
            }
        } else if (this.component.getComponent() instanceof Vein) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
            component = (Vein)this.component.getComponent();
            double scale = (double)((Vein)component).getCol() * 1.0 / (double)((Vein)component).getMaxCol();
            if (this.type.getRender() == EnumTypeRender.WIDTH) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), (int)(Math.min(1.0, scale) * (double)this.type.getWeight()), this.type.getHeight());
            }
            if (this.type.getRender() == EnumTypeRender.HEIGHT) {
                int chargeLevel = (int)(scale *= (double)this.type.getHeight());
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.getX() + this.type.getEndX(), mouseY + this.type.getEndY() + this.getY() + this.type.getHeight() - chargeLevel, this.type.getX1(), this.type.getY1() + this.type.getHeight() - chargeLevel, this.type.getWeight(), chargeLevel);
            }
        } else if (this.component.getComponent() instanceof ComponentTimer) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
            component = (ComponentTimer)this.component.getComponent();
            double scale = ((ComponentTimer)component).getTimes();
            if (this.type.getRender() == EnumTypeRender.WIDTH) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), (int)(scale * (double)this.type.getWeight()), this.type.getHeight());
            }
            if (this.type.getRender() == EnumTypeRender.HEIGHT) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX1(), this.type.getY1(), this.type.getWeight(), (int)(scale * (double)this.type.getHeight()));
            }
        } else if (this.component.getComponent() instanceof ComponentProcessRender) {
            int down;
            component = (ComponentProcessRender)this.component.getComponent();
            ProcessMultiComponent processMultiComponent = ((ComponentProcessRender)component).getProcess();
            EnumTypeMachines type_machines = ((ComponentProcessRender)component).getTypeMachines();
            int x = 0;
            int xx = 0;
            int yy = 0;
            int xx1 = 0;
            int yy1 = 0;
            int xx2 = 0;
            switch (type_machines) {
                case MACERATOR: 
                case COMBMACERATOR: {
                    down = 0;
                    xx -= 2;
                    break;
                }
                case COMPRESSOR: {
                    down = 24;
                    xx1 += 3;
                    yy -= 2;
                    ++yy1;
                    break;
                }
                case ELECTRICFURNACE: {
                    down = 54;
                    xx -= 2;
                    xx1 += 2;
                    break;
                }
                case EXTRACTOR: {
                    down = 79;
                    --xx;
                    xx1 += 2;
                    ++x;
                    break;
                }
                case METALFOMER: 
                case ROLLING: 
                case CUTTING: 
                case EXTRUDING: {
                    down = 68;
                    --xx;
                    x += 37;
                    xx1 += 0;
                    break;
                }
                case RECYCLER: 
                case COMBRECYCLER: {
                    down = 90;
                    --xx;
                    x += 36;
                    xx1 += 2;
                    break;
                }
                case FARMER: {
                    down = 112;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case ASSAMPLERSCRAP: {
                    down = 136;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case OreWashing: {
                    down = 46;
                    --xx;
                    x += 36;
                    yy -= 2;
                    xx1 += 2;
                    break;
                }
                case Centrifuge: {
                    down = 160;
                    --xx;
                    x += 38;
                    --yy;
                    --xx1;
                    break;
                }
                case Gearing: {
                    down = 183;
                    --xx;
                    x += 35;
                    xx1 += 4;
                    yy1 -= 5;
                    yy += 2;
                    ++xx2;
                    break;
                }
                default: {
                    down = 0;
                }
            }
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + x, this.type.getY() + down, this.type.getWeight() + 1 + xx2, this.type.getHeight() + yy1);
            int progress = (int)((double)(24.0f + (float)yy1) * processMultiComponent.getProgress(this.index));
            progress = Math.min(progress, 24 + yy1);
            if (progress >= 0) {
                if (x < 0) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + 2 + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                } else {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                }
            }
        } else if (this.component.getComponent() instanceof ComponentSteamProcessRender) {
            int down;
            component = (ComponentSteamProcessRender)this.component.getComponent();
            SteamProcessMultiComponent processMultiComponent = ((ComponentSteamProcessRender)component).getProcess();
            EnumTypeMachines type_machines = ((ComponentSteamProcessRender)component).getTypeMachines();
            int x = 0;
            int xx = 0;
            int yy = 0;
            int xx1 = 0;
            int yy1 = 0;
            int xx2 = 0;
            switch (type_machines) {
                case MACERATOR: 
                case COMBMACERATOR: {
                    down = 0;
                    --yy1;
                    xx1 += 2;
                    break;
                }
                case COMPRESSOR: {
                    down = 23;
                    xx1 += 2;
                    --yy;
                    ++yy1;
                    break;
                }
                case ELECTRICFURNACE: {
                    down = 54;
                    xx -= 2;
                    xx1 += 2;
                    break;
                }
                case EXTRACTOR: {
                    down = 87;
                    ++xx1;
                    break;
                }
                case METALFOMER: 
                case ROLLING: 
                case CUTTING: 
                case EXTRUDING: {
                    down = 111;
                    yy += 4;
                    ++xx1;
                    break;
                }
                case RECYCLER: 
                case COMBRECYCLER: {
                    down = 90;
                    --xx;
                    x += 36;
                    xx1 += 2;
                    break;
                }
                case FARMER: {
                    down = 112;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case ASSAMPLERSCRAP: {
                    down = 136;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case OreWashing: {
                    down = 46;
                    --xx;
                    x += 36;
                    yy -= 2;
                    xx1 += 2;
                    break;
                }
                case Centrifuge: {
                    down = 160;
                    --xx;
                    x += 38;
                    --yy;
                    --xx1;
                    break;
                }
                case Gearing: {
                    down = 183;
                    --xx;
                    x += 35;
                    xx1 += 4;
                    yy1 -= 5;
                    yy += 2;
                    ++xx2;
                    break;
                }
                default: {
                    down = 0;
                }
            }
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + x, this.type.getY() + down, this.type.getWeight() + 1 + xx2, this.type.getHeight() + yy1);
            int progress = (int)((double)(24.0f + (float)yy1) * processMultiComponent.getProgress(this.index));
            progress = Math.min(progress, 24 + yy1);
            if (progress >= 0) {
                if (x < 0) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + 2 + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                } else {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                }
            }
        } else if (this.component.getComponent() instanceof ComponentBioProcessRender) {
            int down;
            component = (ComponentBioProcessRender)this.component.getComponent();
            BioProcessMultiComponent processMultiComponent = ((ComponentBioProcessRender)component).getProcess();
            EnumTypeMachines type_machines = ((ComponentBioProcessRender)component).getTypeMachines();
            int x = 0;
            int xx = 0;
            int yy = 0;
            int xx1 = 0;
            int yy1 = 0;
            int xx2 = 0;
            int weight = 0;
            switch (type_machines) {
                case MACERATOR: 
                case COMBMACERATOR: {
                    down = 0;
                    --yy1;
                    xx1 += 2;
                    break;
                }
                case COMPRESSOR: {
                    down = 23;
                    xx1 += 2;
                    --yy;
                    ++yy1;
                    break;
                }
                case ELECTRICFURNACE: {
                    down = 47;
                    xx1 += 2;
                    --yy;
                    yy1 += 0;
                    break;
                }
                case EXTRACTOR: {
                    down = 87;
                    ++xx1;
                    break;
                }
                case METALFOMER: 
                case ROLLING: 
                case CUTTING: 
                case EXTRUDING: {
                    down = 111;
                    yy += 4;
                    ++xx1;
                    --yy1;
                    break;
                }
                case RECYCLER: 
                case COMBRECYCLER: {
                    down = 90;
                    --xx;
                    x += 36;
                    xx1 += 2;
                    break;
                }
                case FARMER: {
                    down = 112;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case ASSAMPLERSCRAP: {
                    down = 136;
                    --xx;
                    x += 38;
                    --xx1;
                    break;
                }
                case OreWashing: {
                    down = 131;
                    yy += 0;
                    --xx;
                    ++xx1;
                    --xx2;
                    break;
                }
                case Centrifuge: {
                    down = 155;
                    ++yy;
                    --xx;
                    ++xx1;
                    --xx2;
                    break;
                }
                case Gearing: {
                    down = 182;
                    ++yy;
                    --xx;
                    xx1 += 2;
                    ++xx2;
                    ++weight;
                    break;
                }
                default: {
                    down = 0;
                }
            }
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + x, this.type.getY() + down, this.type.getWeight() + 1 + xx2, this.type.getHeight() + yy1);
            int progress = (int)((double)(24.0f + (float)yy1) * processMultiComponent.getProgress(this.index));
            progress = Math.min(progress, 24 + yy1);
            if (progress >= 0) {
                if (x < 0) {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + 2 + xx1, this.type.getY() + down, this.type.getWeight() + 1, progress);
                } else {
                    this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + xx, mouseY + this.y + yy, this.type.getX() + 16 + x + xx1, this.type.getY() + down, this.type.getWeight() + 1 + weight, progress);
                }
            }
        } else if (this.component.getComponent() instanceof ComponentValue) {
            ComponentValue componentValue = (ComponentValue)this.component.getComponent();
            if (this.type.isNextBar()) {
                GuiComponent.bindCommonTexture2();
            }
            if (this.getType() == EnumTypeComponent.CIRCLE_BAR) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                block136: for (int i = 0; i <= (Integer)componentValue.getValue(); ++i) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    switch (i) {
                        case 1: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 16, mouseY + this.y, this.type.getX1() + 16, this.type.getY1(), 2, 6);
                            continue block136;
                        }
                        case 2: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 17 + 1, mouseY + this.y, this.type.getX1() + 17 + 1, this.type.getY1(), 2, 6);
                            continue block136;
                        }
                        case 3: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 19 + 1, mouseY + this.y + 1, this.type.getX1() + 19 + 1, this.type.getY1() + 1, 2, 6);
                            continue block136;
                        }
                        case 4: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 21 + 1, mouseY + this.y + 2, this.type.getX1() + 21 + 1, this.type.getY1() + 2, 2, 7);
                            continue block136;
                        }
                        case 5: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 15 + 8 + 1, mouseY + this.y + 3, this.type.getX1() + 15 + 8 + 1, this.type.getY1() + 3, 4, 4);
                            continue block136;
                        }
                        case 6: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 59 - 51 + 15 + 1, mouseY + this.y + 41 - 34, this.type.getX1() + 221 - 213 + 15 + 1, this.type.getY1() - 2 + 9, 6, 2);
                            continue block136;
                        }
                        case 7: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 59 - 51 + 15 + 1, mouseY + this.y + 43 - 34, this.type.getX1() + 221 - 213 + 15 + 1, this.type.getY1() - 2 + 11, 7, 2);
                            continue block136;
                        }
                        case 8: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 60 - 51 + 15 + 1, mouseY + this.y + 45 - 34, this.type.getX1() + 222 - 213 + 15 + 1, this.type.getY1() - 2 + 13, 6, 2);
                            continue block136;
                        }
                        case 9: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 61 - 51 + 15 + 1, mouseY + this.y + 47 - 34, this.type.getX1() + 223 - 213 + 15 + 1, this.type.getY1() - 2 + 15, 6, 2);
                            continue block136;
                        }
                        case 10: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 61 - 51 + 15 + 1, mouseY + this.y + 49 - 34, this.type.getX1() + 223 - 213 + 15 + 1, this.type.getY1() - 2 + 17, 6, 2);
                            continue block136;
                        }
                        case 11: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 61 - 51 + 15 + 1, mouseY + this.y + 51 - 34, this.type.getX1() + 223 - 213 + 15 + 1, this.type.getY1() - 2 + 19, 6, 2);
                            continue block136;
                        }
                        case 12: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 60 - 51 + 15 + 1, mouseY + this.y + 53 - 34, this.type.getX1() + 222 - 213 + 15 + 1, this.type.getY1() - 2 + 21, 6, 2);
                            continue block136;
                        }
                        case 13: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 58 - 51 + 15 + 1, mouseY + this.y + 55 - 34, this.type.getX1() + 220 - 213 + 15 + 1, this.type.getY1() - 2 + 23, 7, 2);
                            continue block136;
                        }
                        case 14: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 57 - 51 + 15 + 1, mouseY + this.y + 57 - 34, this.type.getX1() + 219 - 213 + 15 + 1, this.type.getY1() - 2 + 25, 7, 2);
                            continue block136;
                        }
                        case 15: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 57 - 51 + 15 + 1, mouseY + this.y + 59 - 34, this.type.getX1() + 219 - 213 + 15 + 1, this.type.getY1() - 2 + 27, 5, 4);
                            continue block136;
                        }
                        case 16: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 55 - 51 + 15 + 1, mouseY + this.y + 58 - 34, this.type.getX1() + 217 - 213 + 15 + 1, this.type.getY1() - 2 + 26, 2, 6);
                            continue block136;
                        }
                        case 17: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 53 - 51 + 15 + 1, mouseY + this.y + 59 - 34, this.type.getX1() + 215 - 213 + 15 + 1, this.type.getY1() - 2 + 27, 2, 6);
                            continue block136;
                        }
                        case 18: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 51 - 51 + 15 + 1, mouseY + this.y + 59 - 34, this.type.getX1() + 213 - 213 + 15 + 1, this.type.getY1() - 2 + 27, 2, 6);
                            continue block136;
                        }
                        case 19: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 49 - 51 + 15 + 1, mouseY + this.y + 59 - 34, this.type.getX1() + 211 - 213 + 15 + 1, this.type.getY1() - 2 + 27, 2, 6);
                            continue block136;
                        }
                        case 20: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 47 - 51 + 15 + 1, mouseY + this.y + 59 - 34, this.type.getX1() + 209 - 213 + 15 + 1, this.type.getY1() - 2 + 27, 2, 6);
                            continue block136;
                        }
                        case 21: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 45 - 51 + 15 + 1, mouseY + this.y + 57 - 34, this.type.getX1() + 207 - 213 + 15 + 1, this.type.getY1() - 2 + 25, 2, 7);
                            continue block136;
                        }
                        case 22: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 43 - 51 + 15 + 1, mouseY + this.y + 55 - 34, this.type.getX1() + 205 - 213 + 15 + 1, this.type.getY1() - 2 + 23, 2, 8);
                            continue block136;
                        }
                        case 23: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 38 - 51 + 15 + 1, mouseY + this.y + 54 - 34, this.type.getX1() + 200 - 213 + 15 + 1, this.type.getY1() - 2 + 22, 5, 8);
                            continue block136;
                        }
                        case 24: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 37 - 51 + 15 + 1, mouseY + this.y + 52 - 34, this.type.getX1() + 199 - 213 + 15 + 1, this.type.getY1() - 2 + 20, 6, 4);
                            continue block136;
                        }
                        case 25: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 37 - 51 + 15 + 1, mouseY + this.y + 49 - 34, this.type.getX1() + 199 - 213 + 15 + 1, this.type.getY1() - 2 + 17, 6, 4);
                            continue block136;
                        }
                        case 26: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 37 - 51 + 15 + 1, mouseY + this.y + 46 - 34, this.type.getX1() + 199 - 213 + 15 + 1, this.type.getY1() - 2 + 14, 6, 4);
                            continue block136;
                        }
                        case 27: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 37 - 51 + 15 + 1, mouseY + this.y + 43 - 34, this.type.getX1() + 199 - 213 + 15 + 1, this.type.getY1() - 2 + 11, 7, 4);
                            continue block136;
                        }
                        case 28: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 38 - 51 + 15 + 1, mouseY + this.y + 40 - 34, this.type.getX1() + 200 - 213 + 15 + 1, this.type.getY1() - 2 + 8, 8, 4);
                            continue block136;
                        }
                        case 29: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 41 - 51 + 15 + 1, mouseY + this.y + 36 - 34, this.type.getX1() + 203 - 213 + 15 + 1, this.type.getY1() - 2 + 4, 4, 4);
                            continue block136;
                        }
                        case 30: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 45 - 51 + 15 + 1, mouseY + this.y + 35 - 34, this.type.getX1() + 207 - 213 + 15 + 1, this.type.getY1() - 2 + 3, 2, 5);
                            continue block136;
                        }
                        case 31: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 47 - 51 + 15 + 1, mouseY + this.y + 35 - 34, this.type.getX1() + 209 - 213 + 15 + 1, this.type.getY1() - 2 + 3, 2, 5);
                            continue block136;
                        }
                        case 32: {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 49 - 51 + 15 + 1, mouseY + this.y + 35 - 34, this.type.getX1() + 211 - 213 + 15 + 1, this.type.getY1() - 2 + 3, 2, 5);
                        }
                    }
                }
            }
        } else if (this.component.getComponent() instanceof ComponentRenderInventory) {
            component = (ComponentRenderInventory)this.component.getComponent();
            switch (((ComponentRenderInventory)component).getTypeComponentSlot()) {
                case SLOTS_UPGRADE: {
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        int yY;
                        int xX;
                        if (slot instanceof SlotInvSlot) {
                            InvSlot typeSlot;
                            EnumTypeSlot type;
                            xX = slot.f_40220_;
                            yY = slot.f_40221_;
                            this.setX(xX - 1);
                            this.setY(yY - 1);
                            SlotInvSlot slotInvSlot = (SlotInvSlot)slot;
                            if (((ComponentRenderInventory)component).getBlackSlotList().contains(slotInvSlot.invSlot)) continue;
                            if (((ComponentRenderInventory)component).contains(slotInvSlot.invSlot)) {
                                int xx = 0;
                                if (this.type.isNextBar()) {
                                    GuiComponent.bindCommonTexture2();
                                } else if (this.type.isSteam()) {
                                    GuiComponent.bindCommonTexture3();
                                } else if (this.type.isBio()) {
                                    GuiComponent.bindCommonTexture4();
                                } else if (this.type.isSpace()) {
                                    GuiComponent.bindCommonTexture5();
                                } else {
                                    GuiComponent.bindCommonTexture();
                                }
                                int yy = 0;
                                switch (this.type) {
                                    case ADVANCED: {
                                        xx = 8;
                                        break;
                                    }
                                    case IMPROVED: {
                                        xx = 16;
                                        break;
                                    }
                                    case PERFECT: {
                                        xx = 24;
                                        break;
                                    }
                                    case PHOTONIC: {
                                        xx = 2;
                                        yy = 42;
                                    }
                                }
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x - 4, mouseY + this.y - 4, this.type.getX() + 24 - xx, this.type.getY() + 19 + yy, 26, 26);
                            } else if (!this.gui_iu.isBlack) {
                                if (this.type.isNextBar()) {
                                    GuiComponent.bindCommonTexture2();
                                } else if (this.type.isSteam()) {
                                    GuiComponent.bindCommonTexture3();
                                } else if (this.type.isBio()) {
                                    GuiComponent.bindCommonTexture4();
                                } else if (this.type.isSpace()) {
                                    GuiComponent.bindCommonTexture5();
                                } else {
                                    GuiComponent.bindCommonTexture();
                                }
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            } else {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                            }
                            if (((SlotInvSlot)slot).invSlot == null || (type = (typeSlot = ((SlotInvSlot)slot).invSlot).getTypeSlot(((SlotInvSlot)slot).index)) == null) continue;
                            GuiComponent.bindCommonTexture();
                            if (type.next) {
                                this.bindCommonTexture6();
                            }
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, type.getX(), type.getY(), type.getWeight(), type.getHeight());
                            continue;
                        }
                        if (!(slot instanceof SlotVirtual)) continue;
                        xX = slot.f_40220_;
                        yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        int xx = 0;
                        switch (this.type) {
                            case ADVANCED: {
                                xx = 8;
                                break;
                            }
                            case IMPROVED: {
                                xx = 16;
                                break;
                            }
                            case PERFECT: {
                                xx = 24;
                            }
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case SLOTS_UPGRADE_JEI: {
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        if (slot instanceof SlotInvSlot) {
                            InvSlot typeSlot;
                            EnumTypeSlot type;
                            InvSlot invslot = ((SlotInvSlot)slot).invSlot;
                            if (((SlotInvSlot)slot).invSlot instanceof InvSlotUpgrade) continue;
                            int xX = slot.f_40220_;
                            int yY = slot.f_40221_;
                            this.setX(xX - 1);
                            this.setY(yY - 1);
                            SlotInvSlot slotInvSlot = (SlotInvSlot)slot;
                            if (((ComponentRenderInventory)component).getBlackSlotList().contains(slotInvSlot.invSlot)) continue;
                            if (((ComponentRenderInventory)component).contains(slotInvSlot.invSlot)) {
                                int xx = 0;
                                switch (this.type) {
                                    case ADVANCED: {
                                        xx = 8;
                                        break;
                                    }
                                    case IMPROVED: {
                                        xx = 16;
                                        break;
                                    }
                                    case PERFECT: 
                                    case PHOTONIC: {
                                        xx = 24;
                                    }
                                }
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x - 4, mouseY + this.y - 4, this.type.getX() - 160 - xx, this.type.getY() + 114, 26, 26);
                            } else if (!this.gui_iu.isBlack) {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            } else {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                            }
                            if (!(((SlotInvSlot)slot).invSlot instanceof ITypeSlot) || (type = (typeSlot = ((SlotInvSlot)slot).invSlot).getTypeSlot(((SlotInvSlot)slot).index)) == null) continue;
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, type.getX(), type.getY(), type.getWeight(), type.getHeight());
                            continue;
                        }
                        if (!(slot instanceof SlotVirtual)) continue;
                        int xX = slot.f_40220_;
                        int yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        int xx = 0;
                        switch (this.type) {
                            case ADVANCED: {
                                xx = 8;
                                break;
                            }
                            case IMPROVED: {
                                xx = 16;
                                break;
                            }
                            case PERFECT: {
                                xx = 24;
                            }
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case SLOTS__JEI: {
                    InvSlotOutput output = null;
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        if (slot instanceof SlotInvSlot) {
                            InvSlot typeSlot;
                            EnumTypeSlot type;
                            InvSlotOutput output1;
                            InvSlot invslot = ((SlotInvSlot)slot).invSlot;
                            if (((SlotInvSlot)slot).invSlot instanceof InvSlotUpgrade || !(invslot instanceof InvSlotRecipes) && !(invslot instanceof InvSlotMultiRecipes) && !(invslot instanceof InvSlotOutput)) continue;
                            if (output == null && invslot instanceof InvSlotOutput) {
                                output = (InvSlotOutput)invslot;
                            } else if (invslot instanceof InvSlotOutput && (output1 = (InvSlotOutput)invslot) != output) continue;
                            int xX = slot.f_40220_;
                            int yY = slot.f_40221_;
                            this.setX(xX - 1);
                            this.setY(yY - 1);
                            SlotInvSlot slotInvSlot = (SlotInvSlot)slot;
                            if (((ComponentRenderInventory)component).getBlackSlotList().contains(slotInvSlot.invSlot)) continue;
                            if (((ComponentRenderInventory)component).contains(slotInvSlot.invSlot)) {
                                int xx = 0;
                                switch (this.type) {
                                    case ADVANCED: {
                                        xx = 8;
                                        break;
                                    }
                                    case IMPROVED: {
                                        xx = 16;
                                        break;
                                    }
                                    case PERFECT: {
                                        xx = 24;
                                    }
                                }
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x - 4, mouseY + this.y - 4, this.type.getX() - 160 - xx, this.type.getY() + 114, 26, 26);
                            } else if (!this.gui_iu.isBlack) {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            } else {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                            }
                            if (!(((SlotInvSlot)slot).invSlot instanceof ITypeSlot) || (type = (typeSlot = ((SlotInvSlot)slot).invSlot).getTypeSlot(((SlotInvSlot)slot).index)) == null) continue;
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, type.getX(), type.getY(), type.getWeight(), type.getHeight());
                            continue;
                        }
                        if (!(slot instanceof SlotVirtual)) continue;
                        int xX = slot.f_40220_;
                        int yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        int xx = 0;
                        switch (this.type) {
                            case ADVANCED: {
                                xx = 8;
                                break;
                            }
                            case IMPROVED: {
                                xx = 16;
                                break;
                            }
                            case PERFECT: {
                                xx = 24;
                            }
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case SLOTS__JEI_OUTPUT: {
                    InvSlotOutput output = null;
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        if (slot instanceof SlotInvSlot) {
                            InvSlot typeSlot;
                            EnumTypeSlot type;
                            InvSlot invslot = ((SlotInvSlot)slot).invSlot;
                            if (!(invslot instanceof InvSlotOutput)) continue;
                            if (output == null && invslot instanceof InvSlotOutput) {
                                output = (InvSlotOutput)invslot;
                            } else {
                                InvSlotOutput output1 = (InvSlotOutput)invslot;
                                if (output1 != output) continue;
                            }
                            int xX = slot.f_40220_;
                            int yY = slot.f_40221_;
                            this.setX(xX - 1);
                            this.setY(yY - 1);
                            SlotInvSlot slotInvSlot = (SlotInvSlot)slot;
                            if (((ComponentRenderInventory)component).getBlackSlotList().contains(slotInvSlot.invSlot)) continue;
                            if (((ComponentRenderInventory)component).contains(slotInvSlot.invSlot)) {
                                int xx = 0;
                                switch (this.type) {
                                    case ADVANCED: {
                                        xx = 8;
                                        break;
                                    }
                                    case IMPROVED: {
                                        xx = 16;
                                        break;
                                    }
                                    case PERFECT: {
                                        xx = 24;
                                    }
                                }
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x - 4, mouseY + this.y - 4, this.type.getX() - 160 - xx, this.type.getY() + 114, 26, 26);
                            } else if (!this.gui_iu.isBlack) {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            } else {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                            }
                            if (!(((SlotInvSlot)slot).invSlot instanceof ITypeSlot) || (type = (typeSlot = ((SlotInvSlot)slot).invSlot).getTypeSlot(((SlotInvSlot)slot).index)) == null) continue;
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, type.getX(), type.getY(), type.getWeight(), type.getHeight());
                            continue;
                        }
                        if (!(slot instanceof SlotVirtual)) continue;
                        int xX = slot.f_40220_;
                        int yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        int xx = 0;
                        switch (this.type) {
                            case ADVANCED: {
                                xx = 8;
                                break;
                            }
                            case IMPROVED: {
                                xx = 16;
                                break;
                            }
                            case PERFECT: {
                                xx = 24;
                            }
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case SLOTS__JEI_INPUT: {
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        if (slot instanceof SlotInvSlot) {
                            InvSlot typeSlot;
                            EnumTypeSlot type;
                            InvSlot invslot = ((SlotInvSlot)slot).invSlot;
                            if (((SlotInvSlot)slot).invSlot instanceof InvSlotUpgrade || !(invslot instanceof InvSlotRecipes) && !(invslot instanceof InvSlotMultiRecipes)) continue;
                            int xX = slot.f_40220_;
                            int yY = slot.f_40221_;
                            this.setX(xX - 1);
                            this.setY(yY - 1);
                            SlotInvSlot slotInvSlot = (SlotInvSlot)slot;
                            if (((ComponentRenderInventory)component).getBlackSlotList().contains(slotInvSlot.invSlot)) continue;
                            if (((ComponentRenderInventory)component).contains(slotInvSlot.invSlot)) {
                                int xx = 0;
                                switch (this.type) {
                                    case ADVANCED: {
                                        xx = 8;
                                        break;
                                    }
                                    case IMPROVED: {
                                        xx = 16;
                                        break;
                                    }
                                    case PERFECT: {
                                        xx = 24;
                                    }
                                }
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x - 4, mouseY + this.y - 4, this.type.getX() - 160 - xx, this.type.getY() + 114, 26, 26);
                            } else if (!this.gui_iu.isBlack) {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            } else {
                                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                            }
                            if (!(((SlotInvSlot)slot).invSlot instanceof ITypeSlot) || (type = (typeSlot = ((SlotInvSlot)slot).invSlot).getTypeSlot(((SlotInvSlot)slot).index)) == null) continue;
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, type.getX(), type.getY(), type.getWeight(), type.getHeight());
                            continue;
                        }
                        if (!(slot instanceof SlotVirtual)) continue;
                        int xX = slot.f_40220_;
                        int yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        int xx = 0;
                        switch (this.type) {
                            case ADVANCED: {
                                xx = 8;
                                break;
                            }
                            case IMPROVED: {
                                xx = 16;
                                break;
                            }
                            case PERFECT: {
                                xx = 24;
                            }
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case SLOT: {
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        int yY;
                        int xX;
                        if (slot instanceof SlotInvSlot && ((ComponentRenderInventory)component).contains(((SlotInvSlot)slot).invSlot)) {
                            xX = slot.f_40220_;
                            yY = slot.f_40221_;
                            this.setX(xX - 1);
                            this.setY(yY - 1);
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                        }
                        if (!(slot instanceof SlotVirtual)) continue;
                        xX = slot.f_40220_;
                        yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case DEFAULT: {
                    for (Slot slot : ((ContainerBase)((Object)this.gui.getContainer())).f_38839_) {
                        int xX = slot.f_40220_;
                        int yY = slot.f_40221_;
                        this.setX(xX - 1);
                        this.setY(yY - 1);
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case ALL: {
                    if (this.type.isNextBar()) {
                        GuiComponent.bindCommonTexture2();
                    } else if (this.type.isSteam()) {
                        GuiComponent.bindCommonTexture3();
                    } else if (this.type.isBio()) {
                        GuiComponent.bindCommonTexture4();
                    } else if (this.type.isSpace()) {
                        GuiComponent.bindCommonTexture5();
                    } else {
                        GuiComponent.bindCommonTexture();
                    }
                    for (int i = 0; i < 27; ++i) {
                        if (!this.gui_iu.isBlack) {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 18 * (i % 9), mouseY + this.y + 18 * (i / 9), this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            continue;
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 18 * (i % 9), mouseY + this.y + 18 * (i / 9), this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                    }
                    for (int j = 0; j < 9; ++j) {
                        if (!this.gui_iu.isBlack) {
                            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 18 * (j % 9), mouseY + this.y + 58, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                            continue;
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 18 * (j % 9), mouseY + this.y + 58, this.type.getX(), this.type.getY() + 18, this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case INVENTORY: {
                    if (this.type.isNextBar()) {
                        GuiComponent.bindCommonTexture2();
                    } else if (this.type.isSteam()) {
                        GuiComponent.bindCommonTexture3();
                    } else if (this.type.isBio()) {
                        GuiComponent.bindCommonTexture4();
                    } else if (this.type.isSpace()) {
                        GuiComponent.bindCommonTexture5();
                    } else {
                        GuiComponent.bindCommonTexture();
                    }
                    for (int i = 0; i < 27; ++i) {
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 18 * (i % 9), mouseY + this.y + 18 * (i / 9), this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
                case MAIN_INVENTORY: {
                    if (this.type.isNextBar()) {
                        GuiComponent.bindCommonTexture2();
                    } else {
                        GuiComponent.bindCommonTexture();
                    }
                    for (int j = 0; j < 9; ++j) {
                        this.gui.drawTexturedModalRect(poseStack, mouseX + this.x + 18 * (j % 9), mouseY + this.y, this.type.getX(), this.type.getY(), this.type.getWeight(), this.type.getHeight());
                    }
                    break;
                }
            }
        }
    }

    private void bindCommonTexture6() {
        GuiCore.bindTexture(commonTexture5);
    }
}

