/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class InputFluid
implements IInputFluid {
    private final List<FluidStack> inputsfluid;
    private IInputItemStack stack = null;

    public InputFluid(FluidStack ... inputs) {
        this.inputsfluid = Arrays.asList(inputs);
    }

    public InputFluid(List<FluidStack> inputs) {
        this.inputsfluid = inputs;
    }

    public InputFluid(String stack) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Collections.emptyList();
    }

    public InputFluid(ItemStack stack) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Collections.emptyList();
    }

    public InputFluid(IInputItemStack stack) {
        this.stack = stack;
        this.inputsfluid = Collections.emptyList();
    }

    public InputFluid(IInputItemStack stack, FluidStack ... inputs) {
        this.stack = stack;
        this.inputsfluid = Arrays.asList(inputs);
    }

    public InputFluid(ItemStack stack, FluidStack ... inputs) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Arrays.asList(inputs);
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag fluidsTag = new ListTag();
        for (FluidStack fluid : this.inputsfluid) {
            CompoundTag fluidTag = new CompoundTag();
            fluid.writeToNBT(fluidTag);
            fluidsTag.add((Object)fluidTag);
        }
        tag.m_128365_("Fluids", (Tag)fluidsTag);
        if (this.stack != null) {
            tag.m_128365_("Stack", (Tag)this.stack.writeNBT());
        }
        return tag;
    }

    public static InputFluid readNBT(CompoundTag tag) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ListTag fluidsTag = tag.m_128437_("Fluids", 10);
        for (Tag fluidTag : fluidsTag) {
            if (!(fluidTag instanceof CompoundTag)) continue;
            CompoundTag fluidCompound = (CompoundTag)fluidTag;
            fluids.add(FluidStack.loadFluidStackFromNBT((CompoundTag)fluidCompound));
        }
        IInputItemStack stack = null;
        if (tag.m_128425_("Stack", 10)) {
            stack = InputItemStack.create(tag.m_128469_("Stack"));
        }
        InputFluid inputFluid = new InputFluid(fluids);
        if (stack != null) {
            inputFluid.setStack(stack);
        }
        return inputFluid;
    }

    private void setStack(IInputItemStack stack) {
        this.stack = stack;
    }

    @Override
    public List<FluidStack> getInputs() {
        return this.inputsfluid;
    }

    @Override
    public IInputItemStack getStack() {
        return this.stack;
    }
}

