/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataMultiBlock;
import com.denfop.IUItem;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;

public class BlockSwampRubWood<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public static final EnumProperty<RubberWoodState> stateProperty = EnumProperty.m_61587_((String)"state", RubberWoodState.class);

    public BlockSwampRubWood(T[] element, DataMultiBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_155954_(1.0f).m_60977_().m_60918_(SoundType.f_56736_).m_60999_(), element, dataBlock);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(stateProperty, (Comparable)((Object)RubberWoodState.plain_y)));
        BlockTagsProvider.list.add(this);
    }

    public static void spawnAsEntity(Level worldIn, BlockPos pos, ItemStack stack) {
        if (!(worldIn.f_46443_ || stack.m_41619_() || worldIn.restoringBlockSnapshots)) {
            float f = 0.5f;
            double d0 = (double)(worldIn.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.f_46441_.m_188501_() * 0.5f) + 0.25;
            ItemEntity entityitem = new ItemEntity(worldIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, stack);
            entityitem.m_32060_();
            worldIn.m_7967_((Entity)entityitem);
        }
    }

    private static RubberWoodState getPlainAxisState(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> RubberWoodState.plain_x;
            case Direction.Axis.Y -> RubberWoodState.plain_y;
            case Direction.Axis.Z -> RubberWoodState.plain_z;
        };
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        RubberWoodState rstate = (RubberWoodState)((Object)state.m_61143_(stateProperty));
        return rstate != RubberWoodState.plain_x && rstate != RubberWoodState.plain_y && rstate != RubberWoodState.plain_z ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((RubberWoodState)((Object)state.m_61143_(stateProperty))).getId();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.m_61104_(new Property[]{stateProperty});
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(stateProperty, (Comparable)((Object)BlockSwampRubWood.getPlainAxisState(context.m_43719_().m_122434_())));
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(stateProperty, (Comparable)((Object)RubberWoodState.values()[((ISubEnum)((Object)element)).getId()]))).m_60734_()));
    }

    @Override
    public List<ItemStack> m_49635_(BlockState p_60537_, LootParams.Builder p_60538_) {
        if (!p_60538_.m_287258_().f_46443_) {
            int count = 1;
            for (int j1 = 0; j1 < count; ++j1) {
                boolean chance = true;
                if (p_60538_.m_287258_().f_46441_.m_188501_() > (float)chance) continue;
                ItemBlockCore item = this.getMultiData().getItem(RubberWoodState.plain_y.getId());
                BlockSwampRubWood.spawnAsEntity((Level)p_60538_.m_287258_(), new BlockPos((int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82479_, (int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82480_, (int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82481_), new ItemStack(item, 1));
                if (((RubberWoodState)((Object)p_60537_.m_61143_(stateProperty))).isPlain() || p_60538_.m_287258_().f_46441_.m_188503_(6) != 0) continue;
                BlockSwampRubWood.spawnAsEntity((Level)p_60538_.m_287258_(), new BlockPos((int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82479_, (int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82480_, (int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82481_), IUItem.latex.m_41777_());
            }
        }
        return List.of();
    }

    @Override
    public Block getBlock() {
        return this;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(7) == 0) {
            RubberWoodState rwState = (RubberWoodState)((Object)state.m_61143_(stateProperty));
            if (!rwState.canRegenerate()) {
                return;
            }
            world.m_7731_(pos, (BlockState)state.m_61124_(stateProperty, (Comparable)((Object)rwState.getWet())), 3);
        }
    }

    public void m_6810_(BlockState p_60515_, Level world, BlockPos pos, BlockState p_60518_, boolean p_60519_) {
        super.m_6810_(p_60515_, world, pos, p_60518_, p_60519_);
        int range = 4;
        BlockPos.MutableBlockPos cPos = new BlockPos.MutableBlockPos();
        for (int y = -range; y <= range; ++y) {
            for (int z = -range; z <= range; ++z) {
                for (int x = -range; x <= range; ++x) {
                    cPos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    BlockState cState = world.m_8055_((BlockPos)cPos);
                    Block cBlock = cState.m_60734_();
                    if (!cState.m_204336_(BlockTags.f_13035_)) continue;
                    cBlock.m_6786_((LevelAccessor)world, (BlockPos)cPos, cState);
                }
            }
        }
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"axe", (Object)0);
    }

    public static enum RubberWoodState implements ISubEnum
    {
        plain_y(Direction.Axis.Y, null, false),
        plain_x(Direction.Axis.X, null, false),
        plain_z(Direction.Axis.Z, null, false),
        dry_north(Direction.Axis.Y, Direction.NORTH, false),
        dry_south(Direction.Axis.Y, Direction.SOUTH, false),
        dry_west(Direction.Axis.Y, Direction.WEST, false),
        dry_east(Direction.Axis.Y, Direction.EAST, false),
        wet_north(Direction.Axis.Y, Direction.NORTH, true),
        wet_south(Direction.Axis.Y, Direction.SOUTH, true),
        wet_west(Direction.Axis.Y, Direction.WEST, true),
        wet_east(Direction.Axis.Y, Direction.EAST, true);

        private static final RubberWoodState[] values;
        public final Direction.Axis axis;
        public final Direction facing;
        public final boolean wet;

        private RubberWoodState(Direction.Axis axis, Direction facing, boolean wet) {
            this.axis = axis;
            this.facing = facing;
            this.wet = wet;
        }

        public static RubberWoodState getWet(Direction facing) {
            return switch (facing) {
                case Direction.NORTH -> wet_north;
                case Direction.SOUTH -> wet_south;
                case Direction.WEST -> wet_west;
                case Direction.EAST -> wet_east;
                default -> throw new IllegalArgumentException("incompatible facing: " + facing);
            };
        }

        @Override
        public boolean registerOnlyBlock() {
            return true;
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public boolean registerVariants() {
            return false;
        }

        @Override
        public String getMainPath() {
            return "swamp_rubber_wood";
        }

        public boolean isPlain() {
            return this.facing == null;
        }

        public boolean canRegenerate() {
            return !this.isPlain() && !this.wet;
        }

        public RubberWoodState getWet() {
            if (this.isPlain()) {
                return null;
            }
            return this.wet ? this : values[this.ordinal() + 4];
        }

        public RubberWoodState getDry() {
            return !this.isPlain() && this.wet ? values[this.ordinal() - 4] : this;
        }

        static {
            values = RubberWoodState.values();
        }
    }
}

