/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodAntennaMast;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodCasing;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodController;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodGrounding;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodPoles;
import com.denfop.tiles.lightning_rod.TileEntityLightningRodReceiver;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

public enum BlockLightningRod implements IMultiTileBlock
{
    lightning_rod_controller(TileEntityLightningRodController.class, 0),
    lightning_rod_casing(TileEntityLightningRodCasing.class, 1),
    lightning_rod_grounding(TileEntityLightningRodGrounding.class, 2),
    lightning_rod_poles(TileEntityLightningRodPoles.class, 3),
    lightning_rod_antenna_mast(TileEntityLightningRodAntennaMast.class, 4),
    lightning_rod_receiver(TileEntityLightningRodReceiver.class, 5);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final Rarity rarity;
    int idBlock;
    private TileEntityBlock dummyTe;
    private BlockState defaultState;
    private RegistryObject<BlockEntityType<? extends TileEntityBlock>> blockType;

    private BlockLightningRod(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, Rarity.UNCOMMON);
    }

    private BlockLightningRod(Class<? extends TileEntityBlock> teClass, int itemMeta, Rarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public MapColor getMaterial() {
        return MapColor.f_283906_;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = ModLoadingContext.get().getActiveContainer();
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (TileEntityBlock)((Object)this.teClass.getConstructors()[0].newInstance(BlockPos.f_121853_, this.defaultState));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    @Override
    public void setType(RegistryObject<BlockEntityType<? extends TileEntityBlock>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    @Override
    public BlockEntityType<? extends TileEntityBlock> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    @Override
    public String getMainPath() {
        return "lightning_rod";
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 1.0f;
    }

    @Override
    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Self;
    }

    @Override
    public boolean allowWrenchRotating() {
        return false;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    @Override
    public String[] getMultiModels(IMultiTileBlock teBlock) {
        return IMultiTileBlock.super.getMultiModels(teBlock);
    }
}

