/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.TileEntityMiniPanels;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class ComponentMiniPanel
extends AbstractComponent {
    public final boolean fullEnergy;
    private final double defaultCapacity;
    public double tick;
    public double capacity;
    public double storage;
    public int sourceTier;
    public int defaultSourceTier;
    public Set<Direction> sourceDirections;
    public boolean multiSource = false;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    protected double pastEnergy;
    protected double perenergy;
    protected double bonusCapacity;
    protected double bonusProdution;
    Map<BlockPos, IEnergyStorage> energyStorageMap = new HashMap<BlockPos, IEnergyStorage>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    private double prodution;
    private ChunkPos chunkPos;

    public ComponentMiniPanel(TileEntityMiniPanels parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), 1);
    }

    public ComponentMiniPanel(TileEntityInventory parent, double capacity, Set<Direction> sourceDirections, int tier) {
        this(parent, capacity, sourceDirections, tier, false);
    }

    public ComponentMiniPanel(TileEntityInventory parent, double capacity, Set<Direction> sourceDirections, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sourceTier = sourceTier;
        this.sourceDirections = sourceDirections == null ? Collections.emptySet() : sourceDirections;
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
        this.defaultSourceTier = sourceTier;
        this.defaultCapacity = capacity;
        this.prodution = 0.0;
    }

    public static ComponentMiniPanel asBasicSource(TileEntityInventory parent, double capacity) {
        return ComponentMiniPanel.asBasicSource(parent, capacity, 1);
    }

    public static ComponentMiniPanel asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentMiniPanel(parent, capacity, ModUtils.allFacings, tier);
    }

    public double getBonusCapacity() {
        return this.bonusCapacity;
    }

    public void setBonusCapacity(double bonusCapacity) {
        this.bonusCapacity = bonusCapacity;
    }

    public double getBonusProdution() {
        return this.bonusProdution;
    }

    public void setBonusProdution(double bonusProdution) {
        this.bonusProdution = bonusProdution;
    }

    @Override
    public void onNeighborChange(BlockState srcBlock, BlockPos srcPos) {
        BlockEntity tile = this.getParent().getWorld().m_7702_(srcPos);
        boolean hasElement = this.energyStorageMap.containsKey(srcPos);
        if (srcBlock.m_60734_() == Blocks.f_50016_ && hasElement) {
            this.energyStorageMap.remove(srcPos);
        } else if (hasElement) {
            this.energyStorageMap.remove(srcPos);
        }
        if (tile instanceof TileEntityInventory) {
            return;
        }
        if (tile == null) {
            return;
        }
    }

    @Override
    public void updateEntityServer() {
        if (!this.energyStorageMap.isEmpty() && this.getDelegate() != null && !this.sourceDirections.isEmpty()) {
            for (Map.Entry<BlockPos, IEnergyStorage> iEnergyStorageEntry : this.energyStorageMap.entrySet()) {
                this.useEnergy(4 * iEnergyStorageEntry.getValue().receiveEnergy((int)Math.min(Math.min(this.getEnergy() / 4.0, 2.147483646E9), ((IEnergySource)this.getDelegate()).canExtractEnergy() / 4.0), false));
                if (!(this.getEnergy() <= 0.0)) continue;
                break;
            }
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.storage = nbt.m_128459_("storage");
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.m_128347_("storage", this.storage);
        return ret;
    }

    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void onLoaded() {
        if (this.capacity < this.defaultCapacity) {
            this.capacity = this.defaultCapacity;
        }
        if (!this.parent.getWorld().f_46443_) {
            for (Direction facing : Direction.values()) {
                BlockPos srcPos = this.parent.getPos().m_121955_(facing.m_122436_());
                BlockEntity tile = this.getParent().getWorld().m_7702_(srcPos);
                boolean hasElement = this.energyStorageMap.containsKey(srcPos);
                if (!hasElement && !(tile instanceof TileEntityInventory) && tile != null) continue;
            }
        }
        assert (this.delegate == null);
        if (!this.parent.getWorld().f_46443_) {
            if (!this.sourceDirections.isEmpty()) {
                this.energyConductorMap.clear();
                this.validReceivers.clear();
                this.createDelegate();
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.getWorld(), this.delegate));
            }
            this.loaded = true;
        }
    }

    public int getComparatorValue() {
        return Math.min((int)(this.storage * 15.0 / this.capacity), 15);
    }

    private void createDelegate() {
        if (this.delegate == null) {
            this.delegate = new EnergyNetDelegateSource();
            this.delegate.m_142339_(this.parent.getWorld());
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.getWorld(), this.delegate));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeDouble(this.bonusCapacity);
        buffer.writeDouble(this.bonusProdution);
        buffer.writeDouble(this.prodution);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeDouble(this.bonusCapacity);
        buffer.writeDouble(this.bonusProdution);
        buffer.writeDouble(this.prodution);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
        this.bonusCapacity = is.readDouble();
        this.bonusProdution = is.readDouble();
        this.prodution = is.readDouble();
    }

    public double getCapacity() {
        return this.capacity * (1.0 + this.bonusCapacity);
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        this.storage = Math.min(this.capacity, this.storage);
    }

    public double getProdution() {
        return this.prodution * (1.0 + this.bonusProdution);
    }

    public void setProdution(double prodution) {
        this.prodution = prodution;
    }

    public double getStorage() {
        return this.storage;
    }

    public void addCapacity(double capacity) {
        this.capacity += capacity;
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFreeEnergy() {
        return Math.max(0.0, this.capacity - this.storage);
    }

    public double getFillRatio() {
        return this.storage / this.getCapacity();
    }

    public double addEnergy(double amount) {
        amount = Math.min(this.getCapacity() - this.storage, amount);
        this.storage += amount;
        this.storage = Math.min(this.storage, this.getCapacity());
        return amount;
    }

    public void forceAddEnergy(double amount) {
        this.storage += amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
        }
        return ret;
    }

    public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<Direction> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.getWorld().f_46443_);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.getWorld(), this.delegate));
        }
        this.sourceDirections = sourceDirections;
        if (sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.getWorld().f_46443_);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.getWorld(), this.delegate));
        }
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.getParent().getPos().m_123341_() >> 4, this.getParent().getPos().m_123343_() >> 4);
        }
        return this.chunkPos;
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public IEnergyTile getDelegate() {
        return this.delegate;
    }

    private double getSourceEnergy() {
        return Math.min(this.storage, this.getProdution());
    }

    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.parent.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.parent.getWorld().f_46443_) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.m_122424_()));
        }
    }

    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    private abstract class EnergyNetDelegate
    extends BlockEntity
    implements IEnergyTile {
        private EnergyNetDelegate() {
            super(ComponentMiniPanel.this.parent.m_58903_(), ComponentMiniPanel.this.parent.m_58899_(), ComponentMiniPanel.this.parent.m_58900_());
        }
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements IEnergySource {
        int hashCodeSource;
        private long id;

        private EnergyNetDelegateSource() {
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public long getIdNetwork() {
            return this.id;
        }

        @Override
        public void setId(long id) {
            this.id = id;
        }

        @Override
        public List<InfoTile<IEnergyTile>> getValidReceivers() {
            return ComponentMiniPanel.this.validReceivers;
        }

        @Override
        public void RemoveTile(IEnergyTile tile, Direction facing1) {
            if (!ComponentMiniPanel.this.parent.getWorld().f_46443_) {
                ComponentMiniPanel.this.RemoveTile(tile, facing1);
            }
        }

        @Override
        public void AddTile(IEnergyTile tile, Direction facing1) {
            if (!ComponentMiniPanel.this.parent.getWorld().f_46443_) {
                ComponentMiniPanel.this.AddTile(tile, facing1);
            }
        }

        @Override
        public Map<Direction, IEnergyTile> getTiles() {
            return ComponentMiniPanel.this.energyConductorMap;
        }

        @NotNull
        public BlockPos m_58899_() {
            return ComponentMiniPanel.this.parent.getPos();
        }

        @Override
        public int getSourceTier() {
            return ComponentMiniPanel.this.sourceTier;
        }

        @Override
        public boolean emitsEnergyTo(IEnergyAcceptor receiver, Direction dir) {
            return ComponentMiniPanel.this.sourceDirections.contains(dir);
        }

        @Override
        public double canExtractEnergy() {
            return !ComponentMiniPanel.this.sendingSidabled ? ComponentMiniPanel.this.getSourceEnergy() : 0.0;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= ComponentMiniPanel.this.storage);
            ComponentMiniPanel.this.storage -= amount;
        }

        @Override
        public double getPerEnergy() {
            return ComponentMiniPanel.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentMiniPanel.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentMiniPanel.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentMiniPanel.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return true;
        }

        @Override
        public BlockPos getPos() {
            return ComponentMiniPanel.this.parent.getPos();
        }
    }
}

