/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.entity;

import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityNuclearBombPrimed
extends Entity {
    private static final EntityDataAccessor<Integer> FUSE = SynchedEntityData.m_135353_(EntityNuclearBombPrimed.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity owner;

    public EntityNuclearBombPrimed(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public EntityNuclearBombPrimed(Level level, double x, double y, double z, LivingEntity igniter) {
        this((EntityType)IUItem.entity_nuclear_bomb.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.owner = igniter;
        this.setFuse(80);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FUSE, (Object)80);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(FUSE);
    }

    public void setFuse(int ticks) {
        this.f_19804_.m_135381_(FUSE, (Object)ticks);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        this.m_20334_(motion.f_82479_, motion.f_82480_ - 0.04, motion.f_82481_);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            Vec3 damp = this.m_20184_().m_82542_(0.7, -0.5, 0.7);
            this.m_20256_(damp);
        }
        int fuse = this.getFuse() - 1;
        this.setFuse(fuse);
        if (fuse <= 0) {
            this.m_146870_();
            this.explode();
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 20.0f, Level.ExplosionInteraction.TNT);
        BlockPos explosionPos = new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46472_() == Level.f_46428_) {
            int radiationValue = 5000;
            new PacketUpdateRadiationValue(this.m_9236_().m_46865_(explosionPos).m_7697_(), radiationValue);
            this.spreadRadiation(explosionPos, radiationValue);
            this.affectNearbyPlayers(explosionPos, 30.0);
        }
    }

    private void spreadRadiation(BlockPos explosionPos, int initialRadiation) {
        int radius = 3;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos chunkCenter = explosionPos.m_7918_(x * 16, 0, z * 16);
                int radiationLevel = (int)((double)initialRadiation / (1.0 + Math.sqrt(x * x + z * z)));
                new PacketUpdateRadiationValue(this.m_9236_().m_46865_(chunkCenter).m_7697_(), radiationLevel);
            }
        }
    }

    private void affectNearbyPlayers(BlockPos explosionPos, double radius) {
        List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(radius));
        for (Player player : players) {
            if (this.hasRadiationSuit(player)) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)IUPotion.radiation, 200, 0));
        }
    }

    private boolean hasRadiationSuit(Player player) {
        return IHazmatLike.hasCompleteHazmat((LivingEntity)player, EnumLevelRadiation.LOW);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setFuse(tag.m_128448_("Fuse"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128376_("Fuse", (short)this.getFuse());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LivingEntity getOwner() {
        return this.owner;
    }
}

