/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.api.item.IHazmatLike;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.ISubEnum;
import com.denfop.gui.GuiCore;
import com.denfop.items.ItemCraftingElements;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientTickHandler {
    public static void onTickRender1(GuiGraphics pose) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack guiGraphics = pose.m_280168_();
        if (ClientTickHandler.shouldDisplayRadiationInfo(player)) {
            guiGraphics.m_85836_();
            double radiationLevel = player.getPersistentData().m_128459_("radiation");
            String radiationText = String.format("%.2f Sv", radiationLevel);
            pose.m_280488_(Minecraft.m_91087_().f_91062_, radiationText, 40, 90, 0xFFFFFF);
            GuiCore.bindTexture(0, new ResourceLocation("industrialupgrade", "textures/gui/gui_dosimeter.png"));
            guiGraphics.m_85841_(0.4f, 0.4f, 0.4f);
            pose.m_280163_(GuiCore.currentTexture, 0, 10, 0.0f, 0.0f, 256, 256, 256, 256);
            ResourceLocation radiationTexture = ClientTickHandler.getRadiationTexture(player);
            GuiCore.bindTexture(0, radiationTexture);
            pose.m_280163_(GuiCore.currentTexture, 0, 10, 0.0f, 0.0f, 256, 256, 256, 256);
            guiGraphics.m_85849_();
        }
    }

    private static boolean shouldDisplayRadiationInfo(LocalPlayer player) {
        ItemStack stack = player.m_21205_();
        boolean isHoldingGeigerCounter = stack.m_41720_() instanceof ItemCraftingElements && ((ISubEnum)((ItemCraftingElements)stack.m_41720_()).getElement()).getId() == 40;
        boolean isWearingHazmat = IHazmatLike.hasCompleteHazmat((LivingEntity)player);
        return isHoldingGeigerCounter || isWearingHazmat;
    }

    private static ResourceLocation getRadiationTexture(LocalPlayer player) {
        boolean dimension = player.m_9236_().m_46472_() == Level.f_46428_;
        long worldTime = player.m_9236_().m_46467_();
        if (!dimension) {
            int frame = worldTime % 2L == 0L ? 0 : 1;
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + frame + ".png");
        }
        Radiation radiation = RadiationSystem.rad_system.getMap().get(player.m_146902_());
        if (radiation == null) {
            int frame = worldTime % 4L == 0L ? 0 : 1;
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + frame + ".png");
        }
        return ClientTickHandler.getRadiationLevelTexture(radiation, worldTime);
    }

    private static ResourceLocation getRadiationLevelTexture(Radiation radiation, long worldTime) {
        if (radiation == null) {
            if (Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() % 20L == 0L) {
                Minecraft.m_91087_().f_91074_.m_5496_(EnumSound.low_radiation.getSoundEvent(), 1.0f, 1.0f);
            }
            if (worldTime % 4L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/0.png");
            }
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/1.png");
        }
        if (Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() % 20L == 0L) {
            Minecraft.m_91087_().f_91074_.m_5496_(EnumSound.low_radiation.getSoundEvent(), 1.0f, 1.0f);
        }
        if (radiation.getLevel() == EnumLevelRadiation.LOW) {
            int col = (int)(radiation.getRadiation() / 800.0 * 2.0);
            if (worldTime % 2L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + col + ".png");
            }
            if (worldTime % 9L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + Math.max(0, col - 1) + ".png");
            }
            if (worldTime % 5L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (col + 1) + ".png");
            }
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + col + ".png");
        }
        if (radiation.getLevel() == EnumLevelRadiation.DEFAULT) {
            int col = (int)(radiation.getRadiation() / 800.0 * 4.0);
            if (Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() % 20L == 0L) {
                Minecraft.m_91087_().f_91074_.m_5496_(EnumSound.default_radiation.getSoundEvent(), 1.0f, 1.0f);
            }
            if (worldTime % 2L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (3 + col) + ".png");
            }
            if (worldTime % 9L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (2 + col) + ".png");
            }
            if (worldTime % 5L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (4 + col) + ".png");
            }
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (3 + col) + ".png");
        }
        if (radiation.getLevel() == EnumLevelRadiation.MEDIUM) {
            int col = (int)(radiation.getRadiation() / 800.0 * 3.0);
            if (Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() % 20L == 0L) {
                Minecraft.m_91087_().f_91074_.m_5496_(EnumSound.medium_radiation.getSoundEvent(), 1.0f, 1.0f);
            }
            if (worldTime % 2L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (7 + col) + ".png");
            }
            if (worldTime % 9L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (6 + col) + ".png");
            }
            if (worldTime % 5L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (8 + col) + ".png");
            }
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (7 + col) + ".png");
        }
        if (radiation.getLevel() == EnumLevelRadiation.HIGH) {
            int col = (int)(radiation.getRadiation() / 800.0 * 2.0);
            if (Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() % 30L == 0L) {
                Minecraft.m_91087_().f_91074_.m_5496_(EnumSound.high_radiation.getSoundEvent(), 1.0f, 1.0f);
            }
            if (worldTime % 2L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (11 + col) + ".png");
            }
            if (worldTime % 9L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (10 + col) + ".png");
            }
            if (worldTime % 5L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (12 + col) + ".png");
            }
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + (11 + col) + ".png");
        }
        if (radiation.getLevel() == EnumLevelRadiation.VERY_HIGH) {
            int col = (int)(radiation.getRadiation() / 800.0 * 2.0);
            if (Minecraft.m_91087_().f_91074_.m_9236_().m_46467_() % 30L == 0L) {
                Minecraft.m_91087_().f_91074_.m_5496_(EnumSound.very_high_radiation.getSoundEvent(), 1.0f, 1.0f);
            }
            if (worldTime % 2L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + Math.min(14 + col, 16) + ".png");
            }
            if (worldTime % 9L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + Math.min(13 + col, 16) + ".png");
            }
            if (worldTime % 5L == 0L) {
                return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + Math.min(15 + col, 16) + ".png");
            }
            return new ResourceLocation("industrialupgrade", "textures/gui/radiation/" + Math.min(14 + col, 16) + ".png");
        }
        return new ResourceLocation("industrialupgrade", "textures/gui/radiation/0.png");
    }
}

