/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.GasVeinSystem;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.tiles.quarry_earth.TileEntityEarthQuarryController;
import com.denfop.world.GenData;
import com.denfop.world.WorldGenGas;
import com.denfop.world.vein.AlgorithmVein;
import com.denfop.world.vein.noise.Point;
import com.denfop.world.vein.noise.ShellCluster;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldSavedDataIU
extends SavedData {
    public int col;
    Level world;
    private CompoundTag tagCompound = new CompoundTag();

    public WorldSavedDataIU() {
    }

    public WorldSavedDataIU(String name) {
    }

    public static void loadShellClusterChunks(CompoundTag tag) {
        HashMap<Integer, Map<Integer, Tuple<Color, Integer>>> result = new HashMap<Integer, Map<Integer, Tuple<Color, Integer>>>();
        ShellCluster cluster = new ShellCluster();
        cluster.point = new Point(tag.m_128469_("volcano").m_128451_("x"), tag.m_128469_("volcano").m_128451_("z"));
        AlgorithmVein.volcano = cluster;
        ListTag outerList = tag.m_128437_("shellClusterChunks", 10);
        for (int i = 0; i < outerList.size(); ++i) {
            CompoundTag outerTag = outerList.m_128728_(i);
            int outerKey = outerTag.m_128451_("outer");
            HashMap<Integer, Tuple> innerMap = new HashMap<Integer, Tuple>();
            ListTag innerList = outerTag.m_128437_("innerList", 10);
            for (int j = 0; j < innerList.size(); ++j) {
                CompoundTag innerTag = innerList.m_128728_(j);
                int innerKey = innerTag.m_128451_("inner");
                int r = innerTag.m_128451_("r");
                int g = innerTag.m_128451_("g");
                int b = innerTag.m_128451_("b");
                int a = innerTag.m_128451_("a");
                int value = innerTag.m_128451_("value");
                Color color = new Color(r, g, b, a);
                innerMap.put(innerKey, new Tuple((Object)color, (Object)value));
            }
            result.put(outerKey, innerMap);
        }
        AlgorithmVein.shellClusterChuncks = result;
        HashMap<Integer, Map<Integer, List<Integer>>> veinMap = new HashMap<Integer, Map<Integer, List<Integer>>>();
        ListTag outerVeinList = tag.m_128437_("veinCoordination", 10);
        for (int i = 0; i < outerVeinList.size(); ++i) {
            CompoundTag outerTag = outerVeinList.m_128728_(i);
            int outerKey = outerTag.m_128451_("outer");
            HashMap innerMap = new HashMap();
            ListTag innerList = outerTag.m_128437_("innerList", 10);
            for (int j = 0; j < innerList.size(); ++j) {
                CompoundTag innerTag = innerList.m_128728_(j);
                int innerKey = innerTag.m_128451_("inner");
                ListTag coordsList = innerTag.m_128437_("coords", 3);
                ArrayList<Integer> coords = new ArrayList<Integer>();
                for (int k = 0; k < coordsList.size(); ++k) {
                    coords.add(coordsList.m_128763_(k));
                }
                innerMap.put(innerKey, coords);
            }
            veinMap.put(outerKey, innerMap);
        }
        AlgorithmVein.veinCoordination = veinMap;
    }

    public static CompoundTag saveShellClusterChunks() {
        CompoundTag tag = new CompoundTag();
        ListTag outerList = new ListTag();
        CompoundTag volcanoTag = new CompoundTag();
        if (AlgorithmVein.volcano != null) {
            volcanoTag.m_128405_("x", (int)AlgorithmVein.volcano.point.x);
            volcanoTag.m_128405_("z", (int)AlgorithmVein.volcano.point.y);
            tag.m_128365_("volcano", (Tag)volcanoTag);
        }
        for (Map.Entry<Integer, Map<Integer, Tuple<Color, Integer>>> outer : AlgorithmVein.shellClusterChuncks.entrySet()) {
            int outerKey = outer.getKey();
            CompoundTag outerTag = new CompoundTag();
            outerTag.m_128405_("outer", outerKey);
            ListTag innerList = new ListTag();
            for (Map.Entry<Integer, Tuple<Color, Integer>> inner : outer.getValue().entrySet()) {
                int innerKey = inner.getKey();
                Tuple<Color, Integer> tuple = inner.getValue();
                Color color = (Color)tuple.m_14418_();
                int number = (Integer)tuple.m_14419_();
                CompoundTag innerTag = new CompoundTag();
                innerTag.m_128405_("inner", innerKey);
                innerTag.m_128405_("r", color.getRed());
                innerTag.m_128405_("g", color.getGreen());
                innerTag.m_128405_("b", color.getBlue());
                innerTag.m_128405_("a", color.getAlpha());
                innerTag.m_128405_("value", number);
                innerList.add((Object)innerTag);
            }
            outerTag.m_128365_("innerList", (Tag)innerList);
            outerList.add((Object)outerTag);
        }
        tag.m_128365_("shellClusterChunks", (Tag)outerList);
        ListTag veinOuterList = new ListTag();
        for (Map.Entry<Integer, Map<Integer, List<Integer>>> outer : AlgorithmVein.veinCoordination.entrySet()) {
            int outerKey = outer.getKey();
            CompoundTag outerTag = new CompoundTag();
            outerTag.m_128405_("outer", outerKey);
            ListTag innerList = new ListTag();
            for (Map.Entry<Integer, List<Integer>> inner : outer.getValue().entrySet()) {
                int innerKey = inner.getKey();
                List<Integer> coords = inner.getValue();
                CompoundTag innerTag = new CompoundTag();
                innerTag.m_128405_("inner", innerKey);
                ListTag coordsList = new ListTag();
                for (Integer coord : coords) {
                    coordsList.add((Object)IntTag.m_128679_((int)coord));
                }
                innerTag.m_128365_("coords", (Tag)coordsList);
                innerList.add((Object)innerTag);
            }
            outerTag.m_128365_("innerList", (Tag)innerList);
            veinOuterList.add((Object)outerTag);
        }
        tag.m_128365_("veinCoordination", (Tag)veinOuterList);
        return tag;
    }

    public WorldSavedDataIU(@Nonnull CompoundTag compound) {
        int i;
        if (compound.m_128441_("shells")) {
            AlgorithmVein.shellClusterChuncks.clear();
            WorldSavedDataIU.loadShellClusterChunks(compound.m_128469_("shells"));
        }
        SpaceNet.instance.getFakeSpaceSystem().unload();
        if (compound.m_128441_("fakePlayers")) {
            ListTag fakePlayersList = compound.m_128437_("fakePlayers", 10);
            for (i = 0; i < fakePlayersList.size(); ++i) {
                CompoundTag nbt = fakePlayersList.m_128728_(i);
                UUID name = nbt.m_128342_("name");
                ListTag fakesBody = nbt.m_128437_("fakesBody", 10);
                ListTag dataBody = nbt.m_128437_("dataBody", 10);
                HashMap<IBody, Data> map = new HashMap<IBody, Data>();
                for (int ii = 0; ii < dataBody.size(); ++ii) {
                    CompoundTag nbt1 = dataBody.m_128728_(ii);
                    Data data = new Data(nbt1.m_128469_("data"));
                    map.put(data.getBody(), data);
                }
                SpaceNet.instance.getFakeSpaceSystem().addDataBody(name, map);
                LinkedList<IFakeBody> fakeBodies = new LinkedList<IFakeBody>();
                for (int ii = 0; ii < fakesBody.size(); ++ii) {
                    IFakeBody fakePlanet;
                    CompoundTag nbt1 = fakesBody.m_128728_(ii);
                    byte id = nbt1.m_128445_("id");
                    if (id == 0) {
                        fakePlanet = new FakePlanet(nbt1);
                        fakeBodies.add(fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().addFakePlanet((FakePlanet)fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakePlanet)fakePlanet).getPlayer()).put(((FakePlanet)fakePlanet).getPlanet(), ((FakePlanet)fakePlanet).getSpaceOperation());
                    }
                    if (id == 1) {
                        fakePlanet = new FakeSatellite(nbt1);
                        fakeBodies.add(fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().addFakeSatellite((FakeSatellite)fakePlanet);
                        SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakeSatellite)fakePlanet).getPlayer()).put(((FakeSatellite)fakePlanet).getSatellite(), ((FakeSatellite)fakePlanet).getSpaceOperation());
                    }
                    if (id != 2) continue;
                    fakePlanet = new FakeAsteroid(nbt1);
                    fakeBodies.add(fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().addFakeAsteroid((FakeAsteroid)fakePlanet);
                    SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(((FakeAsteroid)fakePlanet).getPlayer()).put(((FakeAsteroid)fakePlanet).getAsteroid(), ((FakeAsteroid)fakePlanet).getSpaceOperation());
                }
                SpaceNet.instance.getFakeSpaceSystem().getBodyMap().put(name, new ArrayList(fakeBodies));
            }
        }
        VeinSystem.system.unload();
        if (compound.m_128441_("veins")) {
            ListTag veinsList = compound.m_128437_("veins", 10);
            for (i = 0; i < veinsList.size(); ++i) {
                CompoundTag veinTag = veinsList.m_128728_(i);
                VeinSystem.system.addVein(veinTag);
            }
        }
        SpaceNet.instance.getColonieNet().unload();
        if (compound.m_128441_("colonies")) {
            ListTag coloniesList = compound.m_128437_("colonies", 10);
            for (i = 0; i < coloniesList.size(); ++i) {
                CompoundTag colonyTag = coloniesList.m_128728_(i);
                SpaceNet.instance.getColonieNet().addColony(colonyTag);
            }
        }
        RadiationSystem.rad_system.clear();
        if (compound.m_128441_("radiations")) {
            ListTag radiationsList = compound.m_128437_("radiations", 10);
            for (i = 0; i < radiationsList.size(); ++i) {
                CompoundTag radiationTag = radiationsList.m_128728_(i);
                RadiationSystem.rad_system.addRadiation(radiationTag);
            }
        }
        IUCore.mapStreakInfo.clear();
        if (compound.m_128441_("streaks")) {
            ListTag streaksList = compound.m_128437_("streaks", 10);
            for (i = 0; i < streaksList.size(); ++i) {
                CompoundTag streakTag = streaksList.m_128728_(i);
                String nick = streakTag.m_128461_("nick");
                PlayerStreakInfo streakInfo = new PlayerStreakInfo(streakTag.m_128469_("streak"));
                IUCore.mapStreakInfo.putIfAbsent(nick, streakInfo);
            }
        }
        if (compound.m_128441_("pollution")) {
            CompoundTag pollutionTag = compound.m_128469_("pollution");
            PollutionManager.pollutionManager.loadData(pollutionTag);
        }
        TileEntityEarthQuarryController.chunkPos.clear();
        if (compound.m_128441_("earth_quarry")) {
            ListTag earthQuarryList = compound.m_128437_("earth_quarry", 10);
            for (i = 0; i < earthQuarryList.size(); ++i) {
                CompoundTag chunkTag = earthQuarryList.m_128728_(i);
                int x = chunkTag.m_128451_("x");
                int z = chunkTag.m_128451_("z");
                TileEntityEarthQuarryController.chunkPos.add(new ChunkPos(x, z));
            }
        }
        WorldGenGas.gasMap.clear();
        if (compound.m_128441_("gen_gas")) {
            ListTag gasMapList = compound.m_128437_("gen_gas", 10);
            for (i = 0; i < gasMapList.size(); ++i) {
                CompoundTag gasTag = gasMapList.m_128728_(i);
                int x = gasTag.m_128451_("x");
                int z = gasTag.m_128451_("z");
                CompoundTag dataTag = gasTag.m_128469_("data");
                WorldGenGas.gasMap.put(new ChunkPos(x, z), new GenData(dataTag));
            }
        }
        PrimitiveHandler.getMapPrimitives().clear();
        if (compound.m_128441_("primitive")) {
            ListTag primitiveList = compound.m_128437_("primitive", 10);
            for (i = 0; i < primitiveList.size(); ++i) {
                CompoundTag primitiveCompound = primitiveList.m_128728_(i);
                ListTag playersList = primitiveCompound.m_128437_("listPlayers", 10);
                HashMap<UUID, Double> playerMap = new HashMap<UUID, Double>();
                for (int j = 0; j < playersList.size(); ++j) {
                    CompoundTag playerCompound = playersList.m_128728_(j);
                    UUID playerUUID = playerCompound.m_128342_("uuid");
                    double value = playerCompound.m_128459_("value");
                    playerMap.put(playerUUID, value);
                }
                EnumPrimitive primitiveType = EnumPrimitive.values()[primitiveCompound.m_128451_("id")];
                PrimitiveHandler.getMapPrimitives().put(primitiveType, playerMap);
            }
        }
        GasVeinSystem.system.unload();
        if (compound.m_128441_("gasvein")) {
            ListTag gasVeinsList = compound.m_128437_("gasvein", 10);
            for (i = 0; i < gasVeinsList.size(); ++i) {
                CompoundTag gasVeinTag = gasVeinsList.m_128728_(i);
                GasVeinSystem.system.addVein(gasVeinTag);
            }
        }
        RelocatorNetwork.instance.onUnload();
        if (compound.m_128441_("relocator")) {
            CompoundTag tag8 = compound.m_128469_("relocator");
            ListTag nbtTagList = tag8.m_128437_("worldUUID", 10);
            for (int i2 = 0; i2 < nbtTagList.size(); ++i2) {
                CompoundTag tag9 = nbtTagList.m_128728_(i2);
                ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag9.m_128461_("id")));
                ListTag nbtTagList1 = tag9.m_128437_("listUUID", 10);
                HashMap uuidMap = new HashMap();
                for (int j = 0; j < nbtTagList1.size(); ++j) {
                    CompoundTag tag10 = nbtTagList1.m_128728_(j);
                    if (tag10.m_128441_("listPoint")) {
                        UUID uuid = tag10.m_128342_("uuid");
                        ListTag nbtTagList2 = tag10.m_128437_("listPoint", 10);
                        LinkedList<com.denfop.items.relocator.Point> points = new LinkedList<com.denfop.items.relocator.Point>();
                        for (int k = 0; k < nbtTagList2.size(); ++k) {
                            CompoundTag pointTag = nbtTagList2.m_128728_(k);
                            com.denfop.items.relocator.Point point = new com.denfop.items.relocator.Point(pointTag);
                            points.add(point);
                        }
                        uuidMap.put(uuid, points);
                    }
                    RelocatorNetwork.instance.getWorldDataPoints().put((ResourceKey<Level>)resourceKey, uuidMap);
                }
            }
        } else {
            compound.m_128365_("relocator", (Tag)new CompoundTag());
        }
        HashMap<UUID, Map<String, List<String>>> mapData = new HashMap<UUID, Map<String, List<String>>>();
        GuideBookCore.uuidGuideMap.clear();
        if (compound.m_128441_("guide_book")) {
            CompoundTag data = compound.m_128469_("guide_book");
            ListTag list = data.m_128437_("list", 10);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                CompoundTag data1 = list.m_128728_(i3);
                UUID uuid = data1.m_128342_("uuid");
                HashMap mapQuest = new HashMap();
                ListTag list1 = data1.m_128437_("list", 10);
                for (int j = 0; j < list1.size(); ++j) {
                    CompoundTag data2 = list1.m_128728_(j);
                    String tab = data2.m_128461_("tab");
                    ListTag list2 = data2.m_128437_("list", 8);
                    ArrayList<String> names = new ArrayList<String>();
                    for (int k = 0; k < list2.size(); ++k) {
                        names.add(list2.m_128778_(k));
                    }
                    mapQuest.put(tab, names);
                }
                mapData.put(uuid, mapQuest);
            }
        }
        GuideBookCore.uuidGuideMap = mapData;
    }

    public Level getWorld() {
        return this.world;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public CompoundTag getTagCompound() {
        return this.tagCompound;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        compound = new CompoundTag();
        ListTag fakePlayersList = new ListTag();
        for (UUID uUID : SpaceNet.instance.getFakeSpaceSystem().getBodyMap().keySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("name", uUID);
            List<IFakeBody> list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().get(uUID);
            Map<IBody, Data> map = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(uUID);
            ListTag listTag = new ListTag();
            for (IFakeBody iFakeBody : list) {
                CompoundTag compoundTag2 = new CompoundTag();
                if (iFakeBody instanceof IFakePlanet) {
                    compoundTag2.m_128344_("id", (byte)0);
                }
                if (iFakeBody instanceof IFakeSatellite) {
                    compoundTag2.m_128344_("id", (byte)1);
                }
                if (iFakeBody instanceof IFakeAsteroid) {
                    compoundTag2.m_128344_("id", (byte)2);
                }
                iFakeBody.writeNBTTagCompound(compoundTag2);
                listTag.add((Object)compoundTag2);
            }
            compoundTag.m_128365_("fakesBody", (Tag)listTag);
            ListTag listTag2 = new ListTag();
            for (Map.Entry<IBody, Data> entry : map.entrySet()) {
                CompoundTag compoundTag3 = new CompoundTag();
                compoundTag3.m_128365_("data", (Tag)entry.getValue().writeNBT());
                listTag2.add((Object)compoundTag3);
            }
            compoundTag.m_128365_("dataBody", (Tag)listTag2);
            fakePlayersList.add((Object)compoundTag);
        }
        compound.m_128365_("fakePlayers", (Tag)fakePlayersList);
        ListTag veinsList = new ListTag();
        for (Vein vein : VeinSystem.system.getVeinsList()) {
            veinsList.add((Object)vein.writeTag());
        }
        compound.m_128365_("veins", (Tag)veinsList);
        ListTag listTag = new ListTag();
        for (UUID uUID : SpaceNet.instance.getColonieNet().getList()) {
            listTag.add((Object)SpaceNet.instance.getColonieNet().writeNBT(new CompoundTag(), uUID));
        }
        compound.m_128365_("colonies", (Tag)listTag);
        ListTag listTag3 = new ListTag();
        for (Radiation radiation : RadiationSystem.rad_system.radiationList) {
            listTag3.add((Object)radiation.writeCompound());
        }
        compound.m_128365_("radiations", (Tag)listTag3);
        ListTag listTag4 = new ListTag();
        for (Map.Entry<EnumPrimitive, Map<UUID, Double>> entry : PrimitiveHandler.getMapPrimitives().entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            ListTag listTag5 = new ListTag();
            for (Map.Entry<UUID, Double> entry2 : entry.getValue().entrySet()) {
                CompoundTag player = new CompoundTag();
                player.m_128362_("uuid", entry2.getKey());
                player.m_128347_("value", entry2.getValue().doubleValue());
                listTag5.add((Object)player);
            }
            compoundTag.m_128365_("listPlayers", (Tag)listTag5);
            compoundTag.m_128405_("id", entry.getKey().ordinal());
            listTag4.add((Object)compoundTag);
        }
        compound.m_128365_("primitive", (Tag)listTag4);
        ListTag listTag6 = new ListTag();
        for (Map.Entry<String, PlayerStreakInfo> entry : IUCore.mapStreakInfo.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("nick", entry.getKey());
            compoundTag.m_128365_("streak", (Tag)entry.getValue().writeNBT());
            listTag6.add((Object)compoundTag);
        }
        compound.m_128365_("streaks", (Tag)listTag6);
        compound.m_128365_("pollution", (Tag)PollutionManager.pollutionManager.writeCompound());
        ListTag listTag7 = new ListTag();
        for (ChunkPos chunkPos : TileEntityEarthQuarryController.chunkPos) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("x", chunkPos.f_45578_);
            compoundTag.m_128405_("z", chunkPos.f_45579_);
            listTag7.add((Object)compoundTag);
        }
        compound.m_128365_("earth_quarry", (Tag)listTag7);
        ListTag listTag8 = new ListTag();
        for (Map.Entry<ChunkPos, GenData> entry : WorldGenGas.gasMap.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("x", entry.getKey().f_45578_);
            compoundTag.m_128405_("z", entry.getKey().f_45579_);
            compoundTag.m_128365_("data", (Tag)entry.getValue().writeNBT());
            listTag8.add((Object)compoundTag);
        }
        compound.m_128365_("gen_gas", (Tag)listTag8);
        ListTag listTag9 = new ListTag();
        for (GasVein gasVein : GasVeinSystem.system.getVeinsList()) {
            listTag9.add((Object)gasVein.writeTag());
        }
        compound.m_128365_("gasvein", (Tag)listTag9);
        Map<ResourceKey<Level>, Map<UUID, List<com.denfop.items.relocator.Point>>> map = RelocatorNetwork.instance.getWorldDataPoints();
        CompoundTag compoundTag = new CompoundTag();
        ListTag worldListTag = new ListTag();
        for (Map.Entry<ResourceKey<Level>, Map<UUID, List<com.denfop.items.relocator.Point>>> worldEntry : map.entrySet()) {
            CompoundTag worldTag = new CompoundTag();
            worldTag.m_128359_("id", worldEntry.getKey().m_135782_().toString());
            ListTag uuidListTag = new ListTag();
            for (Map.Entry<UUID, List<com.denfop.items.relocator.Point>> uuidEntry : worldEntry.getValue().entrySet()) {
                CompoundTag uuidTag = new CompoundTag();
                uuidTag.m_128362_("uuid", uuidEntry.getKey());
                ListTag pointsListTag = new ListTag();
                for (com.denfop.items.relocator.Point point : uuidEntry.getValue()) {
                    pointsListTag.add((Object)point.writeToNBT(new CompoundTag()));
                }
                uuidTag.m_128365_("listPoint", (Tag)pointsListTag);
                uuidListTag.add((Object)uuidTag);
            }
            worldTag.m_128365_("listUUID", (Tag)uuidListTag);
            worldListTag.add((Object)worldTag);
        }
        compoundTag.m_128365_("worldUUID", (Tag)worldListTag);
        compound.m_128365_("relocator", (Tag)compoundTag);
        Map<UUID, Map<String, List<String>>> mapData = GuideBookCore.uuidGuideMap;
        if (!mapData.isEmpty()) {
            CompoundTag data = new CompoundTag();
            ListTag list = new ListTag();
            for (Map.Entry<UUID, Map<String, List<String>>> entry : mapData.entrySet()) {
                CompoundTag data1 = new CompoundTag();
                data1.m_128362_("uuid", entry.getKey());
                ListTag list1 = new ListTag();
                Map<String, List<String>> mapQuest = entry.getValue();
                for (Map.Entry entry3 : mapQuest.entrySet()) {
                    CompoundTag data2 = new CompoundTag();
                    data2.m_128359_("tab", (String)entry3.getKey());
                    ListTag list2 = new ListTag();
                    ((List)entry3.getValue()).forEach(name -> list2.add((Object)StringTag.m_129297_((String)name)));
                    data2.m_128365_("list", (Tag)list2);
                    list1.add((Object)data2);
                }
                data1.m_128365_("list", (Tag)list1);
                list.add((Object)data1);
            }
            data.m_128365_("list", (Tag)list);
            compound.m_128365_("guide_book", (Tag)data);
        }
        compound.m_128365_("shells", (Tag)WorldSavedDataIU.saveShellClusterChunks());
        this.tagCompound = compound;
        return compound;
    }
}

