/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.container.ContainerFluidCoolMachine;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.cooling.TileFluidCooling;
import com.denfop.utils.ListInformationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class GuiFluidCoolMachine<T extends ContainerFluidCoolMachine>
extends GuiIU<ContainerFluidCoolMachine> {
    public ContainerFluidCoolMachine container;
    public String name;

    public GuiFluidCoolMachine(ContainerFluidCoolMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((TileFluidCooling)guiContainer.base).getName());
        this.addComponent(new GuiComponent(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.componentList.add(new GuiComponent(this, 51, 41, EnumTypeComponent.COOL_ENERGY_WEIGHT, new Component<CoolComponent>(((TileFluidCooling)this.container.base).cold)));
        this.componentList.add(new GuiComponent(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new Component<1>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((TileFluidCooling)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((TileFluidCooling)this.getEntityBlock()).work;
            }
        })));
        this.componentList.add(new GuiComponent(this, 53, 60, EnumTypeComponent.PLUS_BUTTON, new Component<2>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return "+4";
            }
        })));
        this.componentList.add(new GuiComponent(this, 78, 60, EnumTypeComponent.MINUS_BUTTON, new Component<3>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 1, ""){

            @Override
            public String getText() {
                return "-4";
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.cool_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.cooling;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        TankGauge.createNormal(this, 112, 20, (IFluidTank)((TileFluidCooling)this.container.base).tank).drawForeground(poseStack, par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiFluidCoolMachine.bindTexture(this.getTexture());
        int xOffset = this.guiLeft;
        int yOffset = this.guiTop;
        GuiFluidCoolMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xOffset + 3, yOffset + 3, 0, 0, 10, 10);
        GuiFluidCoolMachine.bindTexture(this.getTexture());
        TankGauge.createNormal(this, 112, 20, (IFluidTank)((TileFluidCooling)this.container.base).tank).drawBackground(poseStack, this.guiLeft, this.guiTop);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

