/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.geothermal;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.TankGauge;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.blocks.mechanism.BlockGeothermalPump;
import com.denfop.componets.ComponentProgress;
import com.denfop.container.ContainerImpOilRefiner;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.geothermal.GeoThermalHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileEntityRefrigeratorFluids;
import com.denfop.tiles.mechanism.TileImpOilRefiner;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.IFluidTank;

public class GeoThermalCategory
extends GuiIU
implements IRecipeCategory<GeoThermalHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private final ContainerImpOilRefiner container1;
    private final GuiComponent progress_bar;
    private int progress = 0;
    private int energy = 0;

    public GeoThermalCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileImpOilRefiner)BlockBaseMachine3.imp_refiner.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/common3.png"), 3, 3, 140, 140);
        this.componentList.clear();
        this.container1 = (ContainerImpOilRefiner)((Object)this.getContainer());
        this.progress_bar = new GuiComponent(this, 70, 35, EnumTypeComponent.PROCESS, new com.denfop.api.gui.Component<ComponentProgress>(new ComponentProgress((TileEntityInventory)this.container1.base, 1, 100)));
        this.componentList.add(this.progress_bar);
        this.addElement(TankGauge.createNormal(this, 40, 4, (IFluidTank)((TileEntityRefrigeratorFluids)BlockBaseMachine3.refrigerator_fluids.getDummyTe()).fluidTank1));
        this.addElement(TankGauge.createNormal(this, 100, 4, (IFluidTank)((TileEntityRefrigeratorFluids)BlockBaseMachine3.refrigerator_fluids.getDummyTe()).fluidTank2));
    }

    public RecipeType<GeoThermalHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockGeothermalPump.geothermal_controller).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(GeoThermalHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        if (this.energy < 100) {
            ++this.energy;
        }
        double energylevel = (double)this.energy / 100.0;
        double xScale = (double)this.progress / 100.0;
        if (xScale >= 1.0) {
            this.progress = 0;
        }
        this.drawSplitString(stack, Localization.translate("cost.name") + " " + ModUtils.getString(10.0) + " QE", 10, 65, 130, 0x404040);
        int y = 80;
        int x = 35;
        for (int i = 0; i < 4; ++i) {
            double percent = 2.0;
            if (i > 0) {
                percent = 0.5;
            }
            this.drawSplitString(stack, "-> " + percent + "%", x, y, 140 - x, 0x404040);
            y += 16;
        }
        GeoThermalCategory.bindTexture(this.getTexture());
        this.progress_bar.renderBar(stack, 0, 0, xScale);
        for (GuiElement element : this.elements) {
            element.drawBackground(stack, this.guiLeft, this.guiTop);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeoThermalHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 8).setFluidRenderer(10000L, true, 12, 47).addFluidStack(recipe.getInput().getFluid(), (long)recipe.getInput().getAmount());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 8).setFluidRenderer(10000L, true, 12, 47).addFluidStack(recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 15, 75).addItemStack(ItemStackHelper.fromData(IUItem.crafting_elements, 1, 457));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 15, 93).addItemStack(ItemStackHelper.fromData(IUItem.crafting_elements, 1, 461));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 15, 108).addItemStack(ItemStackHelper.fromData(IUItem.crafting_elements, 1, 462));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 15, 126).addItemStack(ItemStackHelper.fromData(IUItem.crafting_elements, 1, 463));
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

