/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.synthesis;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.synthesis.SynthesisHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileEntityStampMechanism;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SynthesisCategory
extends GuiIU
implements IRecipeCategory<SynthesisHandler> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;
    JeiInform jeiInform;

    public SynthesisCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityStampMechanism)BlockBaseMachine3.stamp_mechanism.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guisynthesis.png"), 3, 3, 148, 80);
    }

    public RecipeType<SynthesisHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine, 1, 11).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(SynthesisHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = 15 * this.progress / 100;
        int xScale1 = 20 * this.progress / 100;
        if (xScale > 15) {
            this.progress = 0;
        }
        SynthesisCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 129, 46 - energylevel, 176, 14 - energylevel, 14, energylevel);
        this.drawTexturedModalRect(stack, 39, 32, 177, 33, xScale + 1, 14);
        this.drawTexturedModalRect(stack, 75, 30, 177, 52, xScale1 + 1, 23);
        this.draw(stack, Localization.translate("chance") + recipe.getPercent() + "%", 64, 64, ModUtils.convertRGBcolorToInt(255, 255, 255));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SynthesisHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 31).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 31).addItemStack(recipe.getInput1());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 31).addItemStack(recipe.getOutput());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getContainer().input.getAllStackInputs());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guisynthesis.png");
    }
}

