/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemCraftingElements;
import com.denfop.items.modules.EnumQuarryModules;
import com.denfop.items.modules.EnumQuarryType;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.mechanism.quarry.QuarryItem;
import com.denfop.tiles.mechanism.quarry.TileBaseQuantumQuarry;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;

public class InvSlotQuantumQuarry
extends InvSlot
implements ITypeSlot {
    public final int type;
    public final TileBaseQuantumQuarry tile;
    public int stackSizeLimit;

    public InvSlotQuantumQuarry(TileBaseQuantumQuarry base1, int oldStartIndex1, int type) {
        super(base1, InvSlot.TypeItemSlot.INPUT, oldStartIndex1);
        this.tile = base1;
        this.stackSizeLimit = 1;
        this.type = type;
    }

    @Override
    public void update() {
        switch (this.type) {
            case 0: {
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.polisher = false;
                this.tile.separator = false;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                if (!this.isEmpty()) {
                    ItemStack type1 = this.get(0);
                    EnumQuarryModules module = EnumQuarryModules.getFromID(IUItem.module9.getMeta(this.get(0)));
                    EnumQuarryType type = module.type;
                    switch (type) {
                        case SPEED: {
                            this.tile.original = true;
                            break;
                        }
                        case DEPTH: {
                            this.tile.col = module.efficiency * module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case LUCKY: {
                            this.tile.chance = module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case FURNACE: {
                            this.tile.furnace = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_ingot_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case COMB_MAC: {
                            this.tile.comb_mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_comb_crushed_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case MACERATOR: {
                            this.tile.mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_crushed_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case POLISHER: {
                            this.tile.polisher = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_polisher_quarry);
                            this.tile.original = false;
                        }
                    }
                    this.tile.consume = (double)this.tile.energyconsume * (1.0 + module.cost);
                    this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                    break;
                }
                this.tile.consume = this.tile.energyconsume;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.polisher = false;
                this.tile.separator = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.original = true;
                break;
            }
            case 1: {
                this.tile.list_modules = this.get(0).m_41619_() ? null : EnumQuarryModules.getFromID(IUItem.module9.getMeta(this.get(0)));
                this.tile.list = ModUtils.getQuarryListFromModule(this.get(0));
                this.tile.main_list = this.tile.furnace ? new ArrayList<QuarryItem>(IUCore.get_ingot_quarry) : (this.tile.comb_mac_enabled ? new ArrayList<QuarryItem>(IUCore.get_comb_crushed_quarry) : (this.tile.mac_enabled ? new ArrayList<QuarryItem>(IUCore.get_crushed_quarry) : (this.tile.polisher ? new ArrayList<QuarryItem>(IUCore.get_polisher_quarry) : (this.tile.separator ? new ArrayList<QuarryItem>(IUCore.get_separator_quarry) : new ArrayList<QuarryItem>(IUCore.list_quarry)))));
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.inputslot.update();
                break;
            }
            case 2: {
                this.tile.analyzer = !this.get(0).m_41619_();
                new PacketUpdateFieldTile(this.tile, "analyzer", this.tile.analyzer);
                break;
            }
            case 3: {
                this.tile.plasma = !this.get(0).m_41619_();
            }
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        switch (this.type) {
            case 0: {
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.polisher = false;
                this.tile.separator = false;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                if (!this.isEmpty()) {
                    ItemStack type1 = this.get(0);
                    EnumQuarryModules module = EnumQuarryModules.getFromID(IUItem.module9.getMeta(this.get(0)));
                    EnumQuarryType type = module.type;
                    switch (type) {
                        case SPEED: {
                            this.tile.original = true;
                            break;
                        }
                        case DEPTH: {
                            this.tile.col = module.efficiency * module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case LUCKY: {
                            this.tile.chance = module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case FURNACE: {
                            this.tile.furnace = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_ingot_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case COMB_MAC: {
                            this.tile.comb_mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_comb_crushed_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case MACERATOR: {
                            this.tile.mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_crushed_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case POLISHER: {
                            this.tile.polisher = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_polisher_quarry);
                            this.tile.original = false;
                        }
                    }
                    this.tile.consume = (double)this.tile.energyconsume * (1.0 + module.cost);
                    this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                    break;
                }
                this.tile.consume = this.tile.energyconsume;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.polisher = false;
                this.tile.separator = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.original = true;
                break;
            }
            case 1: {
                this.tile.list_modules = this.get(0).m_41619_() ? null : EnumQuarryModules.getFromID(IUItem.module9.getMeta(this.get(0)));
                this.tile.list = ModUtils.getQuarryListFromModule(this.get(0));
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.inputslot.update();
                break;
            }
            case 2: {
                this.tile.analyzer = !this.get(0).m_41619_();
                new PacketUpdateFieldTile(this.tile, "analyzer", this.tile.analyzer);
                break;
            }
            case 3: {
                this.tile.plasma = !this.get(0).m_41619_();
            }
        }
        return content;
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.type == 0) {
            return itemStack.m_41720_() instanceof ItemQuarryModule && EnumQuarryModules.getFromID((int)IUItem.module9.getMeta((ItemStack)itemStack)).type != EnumQuarryType.WHITELIST && EnumQuarryModules.getFromID((int)IUItem.module9.getMeta((ItemStack)itemStack)).type != EnumQuarryType.BLACKLIST;
        }
        if (this.type == 1) {
            if (itemStack.m_41720_() instanceof ItemQuarryModule && (EnumQuarryModules.getFromID((int)IUItem.module9.getMeta((ItemStack)itemStack)).type == EnumQuarryType.WHITELIST || EnumQuarryModules.getFromID((int)IUItem.module9.getMeta((ItemStack)itemStack)).type == EnumQuarryType.BLACKLIST)) {
                ((TileBaseQuantumQuarry)this.base).list = ModUtils.getQuarryListFromModule(itemStack);
                return !itemStack.m_41720_().equals(IUItem.analyzermodule.getItem());
            }
            return false;
        }
        if (this.type == 3) {
            return itemStack.m_41720_() instanceof ItemCraftingElements && IUItem.crafting_elements.getMeta(itemStack) == 646;
        }
        return itemStack.m_41720_().equals(IUItem.analyzermodule.getItem());
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        switch (this.type) {
            case 0: {
                return EnumTypeSlot.QUARRY1;
            }
            case 1: {
                return EnumTypeSlot.LIST;
            }
            case 2: {
                return EnumTypeSlot.QUARRY;
            }
            case 3: {
                return EnumTypeSlot.PLASM;
            }
        }
        return null;
    }
}

