/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.container.ContainerBeeAnalyzer;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bee.ItemStackBeeAnalyzer;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemBeeAnalyzer
extends Item
implements IItemStackInventory,
IItemTab {
    private final int slots;
    private String nameItem;

    public ItemBeeAnalyzer() {
        super(new Item.Properties().m_41487_(1));
        this.slots = 1;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237113_((String)Localization.translate("iu.bee_analyzer.info")));
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        return new ItemStackBeeAnalyzer(player, stack, 1);
    }

    public void save(ItemStack stack, Player player) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128379_("open", true);
        nbt.m_128405_("slot_inventory", player.m_150109_().f_35977_);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackBeeAnalyzer toolbox;
        int slotId;
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("open") && (slotId = nbt.m_128451_("slot_inventory")) != itemSlot && !world.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.m_6915_();
            nbt.m_128379_("open", false);
        }
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackBeeAnalyzer toolbox;
        if (!player.m_9236_().f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.m_6915_();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        BlockHitResult blockhitresult = ItemBeeAnalyzer.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (!player.m_9236_().f_46443_ && world.m_7702_(blockhitresult.m_82425_()) == null) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public boolean canInsert(Player player, ItemStack stack, ItemStack stack1) {
        return true;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }
}

