/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.network.EncoderHandler;
import com.denfop.network.NetworkManager;
import com.denfop.network.WorldData;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateOvertimeTile;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.tiles.base.TileEntityBlock;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;

public class UpdateTileEntityPacket {
    public static void send(WorldData worldData) throws IOException {
        CustomPacketBuffer commonBuffer;
        ServerPlayer player;
        Object playersInRange;
        if (!worldData.listUpdateTile.isEmpty()) {
            for (TileEntityBlock tileEntityBlock : new ArrayList<TileEntityBlock>(worldData.listUpdateTile)) {
                playersInRange = NetworkManager.getPlayersInRange(tileEntityBlock.m_58904_(), tileEntityBlock.m_58899_(), new ArrayList());
                Iterator iterator = playersInRange.iterator();
                while (iterator.hasNext()) {
                    player = (ServerPlayer)iterator.next();
                    commonBuffer = new CustomPacketBuffer();
                    commonBuffer.writeByte(0);
                    EncoderHandler.encode(commonBuffer, tileEntityBlock.m_58899_(), false);
                    commonBuffer.writeBytes((ByteBuf)tileEntityBlock.writePacket());
                    new PacketUpdateTile(commonBuffer, player);
                }
            }
        }
        worldData.listUpdateTile.clear();
        if (worldData.getWorld().m_46467_() % 80L == 0L) {
            for (TileEntityBlock tileEntityBlock : worldData.mapUpdateOvertimeField.values()) {
                playersInRange = NetworkManager.getPlayersInRange(tileEntityBlock.m_58904_(), tileEntityBlock.m_58899_(), new ArrayList());
                Iterator iterator = playersInRange.iterator();
                while (iterator.hasNext()) {
                    player = (ServerPlayer)iterator.next();
                    commonBuffer = new CustomPacketBuffer();
                    commonBuffer.writeByte(25);
                    EncoderHandler.encode(commonBuffer, tileEntityBlock.m_58899_(), false);
                    commonBuffer.writeBytes((ByteBuf)tileEntityBlock.writeUpdatePacket());
                    new PacketUpdateOvertimeTile(commonBuffer, player);
                }
            }
        }
        for (Map.Entry entry : worldData.mapUpdateContainer.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                CustomPacketBuffer playerBuffer = new CustomPacketBuffer();
                playerBuffer.writeByte(8);
                EncoderHandler.encode(playerBuffer, ((TileEntityBlock)((Object)entry.getKey())).m_58899_(), false);
                playerBuffer.writeBytes((ByteBuf)entry2.getValue());
                new PacketUpdateFieldContainerTile(playerBuffer, (ServerPlayer)entry2.getKey());
            }
        }
        for (Map.Entry entry : worldData.mapUpdateField.entrySet()) {
            TileEntityBlock te = (TileEntityBlock)((Object)entry.getKey());
            List list = NetworkManager.getPlayersInRange(te.m_58904_(), te.m_58899_(), new ArrayList());
            for (CustomPacketBuffer buffer : (List)entry.getValue()) {
                byte[] bytes = new byte[buffer.writerIndex() - buffer.readerIndex()];
                buffer.readBytes(bytes);
                for (ServerPlayer player2 : list) {
                    CustomPacketBuffer playerBuffer = new CustomPacketBuffer();
                    playerBuffer.writeByte(12);
                    EncoderHandler.encode(playerBuffer, te.m_58899_(), false);
                    playerBuffer.writeBytes(bytes);
                    new PacketUpdateFieldTile(playerBuffer, player2);
                }
            }
        }
        worldData.mapUpdateField.clear();
        worldData.mapUpdateContainer.clear();
    }
}

