/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.ColonyRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ColonySerializer
implements RecipeSerializer<ColonyRecipe> {
    public static final ColonySerializer INSTANCE = new ColonySerializer();

    public ColonyRecipe fromJson(ResourceLocation id, JsonObject json) {
        String bodyName = GsonHelper.m_13906_((JsonObject)json, (String)"body");
        ArrayList<IInputItemStack> input = new ArrayList<IInputItemStack>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs")) {
            JsonArray inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            block10: for (JsonElement el : inArray) {
                JsonObject obj = el.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
                String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                switch (type) {
                    case "item": {
                        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(new InputItemStack(stack));
                        continue block10;
                    }
                    case "tag": {
                        input.add(new InputOreDict(itemId, amount));
                        continue block10;
                    }
                    case "fluid": {
                        FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(new InputFluidStack(fluidStack));
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unknown input type: " + type);
            }
        }
        int level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
        IBody body = SpaceNet.instance.getBodyFromName(bodyName.toLowerCase());
        for (IInputItemStack itemStack : input) {
            if (itemStack instanceof InputItemStack) {
                SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addItemStack(body, (short)level, ((InputItemStack)itemStack).input));
            }
            if (itemStack instanceof InputFluidStack) {
                SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addFluidStack(body, (short)level, ((InputFluidStack)itemStack).getFluid()));
            }
            if (!(itemStack instanceof InputOreDict)) continue;
            SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addItemStack(body, (short)level, ((InputOreDict)itemStack).getInputs().get(0)));
        }
        return new ColonyRecipe(id, "", Collections.emptyList(), "");
    }

    public ColonyRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new ColonyRecipe(id, "", new ArrayList<ItemStack>(), "");
    }

    public void toNetwork(FriendlyByteBuf buf, ColonyRecipe recipe) {
    }
}

