/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.BaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.SpaceBodyRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SpaceBodySerializer
implements RecipeSerializer<SpaceBodyRecipe> {
    public static final SpaceBodySerializer INSTANCE = new SpaceBodySerializer();

    public SpaceBodyRecipe fromJson(ResourceLocation id, JsonObject json) {
        String bodyName = GsonHelper.m_13906_((JsonObject)json, (String)"body");
        ArrayList<IInputItemStack> input = new ArrayList<IInputItemStack>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs")) {
            JsonArray inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            block22: for (JsonElement el : inArray) {
                JsonObject obj = el.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
                String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                switch (type) {
                    case "item": {
                        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(new InputItemStack(stack));
                        continue block22;
                    }
                    case "tag": {
                        input.add(new InputOreDict(itemId, amount));
                        continue block22;
                    }
                    case "fluid": {
                        FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(new InputFluidStack(fluidStack));
                        continue block22;
                    }
                }
                throw new IllegalArgumentException("Unknown input type: " + type);
            }
        }
        String roverType = GsonHelper.m_13906_((JsonObject)json, (String)"typeRover");
        String operationType = GsonHelper.m_13906_((JsonObject)json, (String)"typeOperation");
        int percent = GsonHelper.m_13927_((JsonObject)json, (String)"percent");
        int chance = GsonHelper.m_13927_((JsonObject)json, (String)"chance");
        IBody body = SpaceNet.instance.getBodyFromName(bodyName.toLowerCase());
        if (body != null && operationType.equals("add")) {
            switch (roverType) {
                case "rover": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, body, EnumTypeRovers.ROVERS));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, body, EnumTypeRovers.ROVERS));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, body, EnumTypeRovers.ROVERS));
                    }
                    break;
                }
                case "probe": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, body, EnumTypeRovers.PROBE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, body, EnumTypeRovers.PROBE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, body, EnumTypeRovers.PROBE));
                    }
                    break;
                }
                case "satellite": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, body, EnumTypeRovers.SATELLITE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, body, EnumTypeRovers.SATELLITE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, body, EnumTypeRovers.SATELLITE));
                    }
                    break;
                }
                case "rocket": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, body, EnumTypeRovers.ROCKET));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, body, EnumTypeRovers.ROCKET));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, body, EnumTypeRovers.ROCKET));
                    }
                    break;
                }
            }
        }
        return new SpaceBodyRecipe(id, "", Collections.emptyList(), "");
    }

    public SpaceBodyRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new SpaceBodyRecipe(id, "", new ArrayList<ItemStack>(), "");
    }

    public void toNetwork(FriendlyByteBuf buf, SpaceBodyRecipe recipe) {
    }
}

