/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class RenderFluidBlock {
    private static final Map<Integer, Map<BlockPos, TickLerp>> lerpMap = new WeakHashMap<Integer, Map<BlockPos, TickLerp>>();

    private static float getCurrentLerpHeight(TickLerp lerp, long currentTick) {
        float progress = (float)(currentTick - lerp.startTick) / 20.0f;
        if (progress >= 1.0f) {
            return lerp.targetAmount;
        }
        return lerp.startAmount + (lerp.targetAmount - lerp.startAmount) * progress;
    }

    public static void renderFluid(FluidStack fluidStack, MultiBufferSource bufferSource, Level level, BlockPos pos, PoseStack poseStack, float scale, float scale1, int tank) {
        if (fluidStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        FluidState state = fluidStack.getFluid().m_76145_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        long gameTime = level.m_46467_();
        float rawHeight = scale;
        TickLerp lerp = (TickLerp)lerpMap.computeIfAbsent(tank, k -> new HashMap()).get(pos);
        if (lerp == null) {
            lerp = new TickLerp();
            lerp.startTick = gameTime;
            lerp.startAmount = rawHeight;
            lerp.targetAmount = rawHeight;
            lerpMap.get(tank).put(pos, lerp);
        } else if (lerp.targetAmount != rawHeight) {
            lerp.startAmount = RenderFluidBlock.getCurrentLerpHeight(lerp, gameTime);
            lerp.targetAmount = rawHeight;
            lerp.startTick = gameTime;
        }
        float height = 1.0f;
        scale = (float)((double)RenderFluidBlock.getCurrentLerpHeight(lerp, gameTime) * 0.99 * (double)scale);
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        poseStack.m_85841_(2.0f * scale1, scale, 2.0f * scale1);
        VertexConsumer builder = bufferSource.m_6299_(ItemBlockRenderTypes.m_109287_((FluidState)state));
        int i = level != null ? LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos) : 0xF000F0;
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(-1.0f, 0.0f, -1.5f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.75f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        poseStack.m_252880_(0.0f, 0.0f, -1.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.01, 1.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
    }

    public static void renderFluid(FluidStack fluidStack, MultiBufferSource bufferSource, Level level, BlockPos pos, PoseStack poseStack, float scale, float scale1, float scale2) {
        if (fluidStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getFlowingTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        FluidState state = fluidStack.getFluid().m_76145_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        float height = 1.0f;
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        poseStack.m_85841_(2.0f * scale1, scale, 2.0f * scale2);
        MultiBufferSource pBuffer = bufferSource;
        VertexConsumer builder = pBuffer.m_6299_(ItemBlockRenderTypes.m_109287_((FluidState)state));
        int i = level != null ? LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos) : 0xF000F0;
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(-1.0f, 0.0f, -1.5f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.75f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_252880_(-1.0f, 0.0f, 0.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        poseStack.m_252880_(0.0f, 0.0f, -1.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.01, 1.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), i, tintColor);
        poseStack.m_85849_();
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_193479_(color).m_7421_(u, v).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void drawQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        RenderFluidBlock.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        RenderFluidBlock.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        RenderFluidBlock.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        RenderFluidBlock.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }

    private static class TickLerp {
        long startTick;
        float startAmount;
        float targetAmount;

        private TickLerp() {
        }
    }
}

