/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.brewage.EnumBeerVariety;
import com.denfop.api.brewage.EnumTimeVariety;
import com.denfop.api.brewage.EnumWaterVariety;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBarrel;
import com.denfop.componets.Fluids;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import com.denfop.utils.Timer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityBarrel
extends TileEntityInventory {
    private final Fluids fluids;
    private final Fluids.InternalFluidTank tank;
    EnumBeerVariety beerVariety;
    EnumTimeVariety timeVariety = EnumTimeVariety.BREW;
    EnumWaterVariety waterVariety;
    byte hops;
    byte wheat;
    int time;
    private int prev;

    public TileEntityBarrel(BlockPos pos, BlockState state) {
        super(BlockBarrel.barrel, pos, state);
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 64000, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.f_76193_}));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.barrel.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBarrel.barrel;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.barrel.info"));
        tooltip.add(Localization.translate("iu.barrel.info1"));
        tooltip.add(Localization.translate("iu.barrel.info2"));
        if (this.f_58857_ != null) {
            tooltip.add(Localization.translate("iu.beer.recipe"));
            tooltip.add(Localization.translate("iu.beer.recipe1") + " " + this.hops);
            tooltip.add(Localization.translate("iu.beer.recipe2") + " " + this.wheat);
            tooltip.add(Localization.translate("iu.beer.recipe3") + " " + this.tank.getFluidAmount() / 1000);
            tooltip.add(Localization.translate("iu.beer.recipe4") + " " + new Timer(this.time / 20).getDisplay());
            if (this.waterVariety != null && this.timeVariety != null && this.beerVariety != null) {
                tooltip.add(Localization.translate("iu.beer.recipe5") + " " + this.waterVariety.name() + " " + this.beerVariety.name() + " " + this.timeVariety.name());
            }
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null && this.tank.getFluidAmount() + 1000 <= this.tank.getCapacity()) {
            ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
            this.prev = this.tank.getFluidAmount();
            this.waterVariety = EnumWaterVariety.getVarietyFromLevelWater(this.tank.getFluidAmount() / 1000);
            this.time = 0;
            return true;
        }
        if (!this.getWorld().f_46443_ && stack.m_41720_() == Items.f_42405_ && this.hops + this.wheat < 10) {
            this.wheat = (byte)(this.wheat + 1);
            stack.m_41774_(1);
        }
        if (!this.getWorld().f_46443_ && stack.m_41720_() == IUItem.hops.getItem() && this.hops + this.wheat < 10) {
            this.hops = (byte)(this.hops + 1);
            stack.m_41774_(1);
        }
        if (!this.getWorld().f_46443_ && this.hops + this.wheat == 10 && this.beerVariety == null) {
            this.beerVariety = EnumBeerVariety.getBeerVarietyFromRatio(this.wheat, this.hops);
        }
        if (!this.getWorld().f_46443_ && stack.m_41720_() == IUItem.booze_mug.getItem() && !ModUtils.nbt(stack).m_128441_("beer") && this.waterVariety != null && this.beerVariety != null) {
            CompoundTag nbt = ModUtils.nbt(stack);
            nbt.m_128379_("beer", true);
            nbt.m_128344_("amount", (byte)5);
            nbt.m_128344_("waterVariety", (byte)this.waterVariety.ordinal());
            nbt.m_128344_("timeVariety", (byte)this.timeVariety.ordinal());
            nbt.m_128344_("beerVariety", (byte)this.beerVariety.ordinal());
            this.hops = 0;
            this.wheat = 0;
            this.time = 0;
            this.prev = 0;
            this.tank.drain(this.tank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.beerVariety = null;
            this.timeVariety = EnumTimeVariety.BREW;
            this.waterVariety = null;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.prev != this.tank.getFluidAmount()) {
            this.prev = this.tank.getFluidAmount();
            this.waterVariety = EnumWaterVariety.getVarietyFromLevelWater(this.prev / 1000);
            this.time = 0;
        }
        if (this.hops + this.wheat == 10 && this.waterVariety != null) {
            ++this.time;
            if (this.f_58857_.m_46467_() % 5L == 0L) {
                ParticleUtils.spawnFermenterParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
            }
            if (this.time % 1200 == 0) {
                this.timeVariety = EnumTimeVariety.getVarietyFromTime((double)this.time / 72000.0);
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.prev = nbtTagCompound.m_128451_("prev");
        this.timeVariety = EnumTimeVariety.values()[nbtTagCompound.m_128445_("timeVariety")];
        if (nbtTagCompound.m_128471_("hasBeerVariety")) {
            this.beerVariety = EnumBeerVariety.values()[nbtTagCompound.m_128445_("hasBeerVariety")];
        }
        if (nbtTagCompound.m_128471_("hasWaterVariety")) {
            this.waterVariety = EnumWaterVariety.values()[nbtTagCompound.m_128445_("waterVariety")];
        }
        this.time = nbtTagCompound.m_128451_("time");
        this.wheat = nbtTagCompound.m_128445_("wheat");
        this.hops = nbtTagCompound.m_128445_("hops");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128405_("prev", this.prev);
        nbtTagCompound.m_128344_("timeVariety", (byte)this.timeVariety.ordinal());
        if (this.beerVariety != null) {
            nbtTagCompound.m_128379_("hasBeerVariety", true);
            nbtTagCompound.m_128344_("beerVariety", (byte)this.beerVariety.ordinal());
        } else {
            nbtTagCompound.m_128379_("hasBeerVariety", false);
        }
        if (this.waterVariety != null) {
            nbtTagCompound.m_128379_("hasWaterVariety", true);
            nbtTagCompound.m_128344_("waterVariety", (byte)this.waterVariety.ordinal());
        } else {
            nbtTagCompound.m_128379_("hasWaterVariety", false);
        }
        nbtTagCompound.m_128405_("time", this.time);
        nbtTagCompound.m_128344_("wheat", this.wheat);
        nbtTagCompound.m_128344_("hops", this.hops);
        return nbtTagCompound;
    }
}

