/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class TileEntityTeleporter
extends TileElectricMachine {
    private BlockPos target;
    private int targetCheckTicker = IUCore.random.nextInt(1024);
    private int cooldown = 0;

    public TileEntityTeleporter(BlockPos pos, BlockState state) {
        super(500000.0, 14, 0, BlockBaseMachine3.teleporter_iu, pos, state);
    }

    private static int getStackCost(ItemStack stack) {
        return ModUtils.isEmpty(stack) ? 0 : 100 * ModUtils.getSize(stack) / stack.m_41741_();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.teleporter_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        if (nbt.m_128441_("targetX")) {
            this.target = new BlockPos(nbt.m_128451_("targetX"), nbt.m_128451_("targetY"), nbt.m_128451_("targetZ"));
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        if (this.target != null) {
            nbt.m_128405_("targetX", this.target.m_123341_());
            nbt.m_128405_("targetY", this.target.m_123342_());
            nbt.m_128405_("targetZ", this.target.m_123343_());
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        Level level;
        boolean coolingDown;
        super.updateEntityServer();
        boolean bl = coolingDown = this.cooldown > 0;
        if (coolingDown) {
            --this.cooldown;
            new PacketUpdateFieldTile(this, "cooldown", this.cooldown);
        }
        if ((level = this.f_58857_).m_276867_(this.f_58858_) && this.target != null) {
            List entitiesNearby;
            this.setActive(true);
            if (coolingDown) {
                entitiesNearby = Collections.emptyList();
            } else {
                AABB aabb = new AABB((double)(this.f_58858_.m_123341_() - 1), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() - 1), (double)(this.f_58858_.m_123341_() + 2), (double)(this.f_58858_.m_123342_() + 3), (double)(this.f_58858_.m_123343_() + 2));
                entitiesNearby = level.m_45976_(Entity.class, aabb);
            }
            if (!entitiesNearby.isEmpty() && this.verifyTarget()) {
                double minDistanceSquared = Double.MAX_VALUE;
                Entity closestEntity = null;
                for (Entity entity : entitiesNearby) {
                    double distSquared;
                    if (entity.m_20202_() != null || !((distSquared = entity.m_20238_(Vec3.m_82512_((Vec3i)this.f_58858_))) < minDistanceSquared)) continue;
                    minDistanceSquared = distSquared;
                    closestEntity = entity;
                }
                if (closestEntity != null) {
                    level.m_5594_(null, this.f_58858_, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.teleport(closestEntity, Math.sqrt(Vec3.m_82512_((Vec3i)this.f_58858_).m_82557_(Vec3.m_82512_((Vec3i)this.target))));
                }
            } else if (++this.targetCheckTicker % 1024 == 0) {
                this.verifyTarget();
            }
        } else {
            this.setActive(false);
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.teleporter.getSoundEvent();
    }

    private boolean verifyTarget() {
        if (this.getWorld().m_7702_(this.target) instanceof TileEntityTeleporter) {
            return true;
        }
        this.target = null;
        this.setActive(false);
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            if (this.cooldown > 0) {
                this.spawnGreenParticles(2, this.pos);
            } else {
                this.spawnBlueParticles(2, this.pos);
            }
        }
    }

    public void teleport(Entity user, double distance) {
        int energyCost;
        int weight = this.getWeightOf(user);
        if (weight != 0 && (energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0)) <= this.getAvailableEnergy()) {
            this.consumeEnergy(energyCost);
            double targetX = (double)this.target.m_123341_() + 0.5;
            double targetY = (double)this.target.m_123342_() + 1.5;
            double targetZ = (double)this.target.m_123343_() + 0.5;
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                serverPlayer.m_6021_(targetX, targetY, targetZ);
            } else {
                user.m_6021_(targetX, targetY, targetZ);
                user.m_146922_(user.m_146908_());
                user.m_146926_(user.m_146909_());
            }
            BlockEntity be = this.f_58857_.m_7702_(this.target);
            if (be instanceof TileEntityTeleporter) {
                TileEntityTeleporter teleporter = (TileEntityTeleporter)be;
                teleporter.onTeleportTo();
            }
        }
    }

    public void spawnBlueParticles(int n, BlockPos pos) {
        this.spawnParticles(n, pos, 0.0f, 1.0f);
    }

    public void spawnGreenParticles(int n, BlockPos pos) {
        this.spawnParticles(n, pos, 1.0f, 0.0f);
    }

    private void spawnParticles(int n, BlockPos pos, float green, float blue) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        RandomSource rnd = this.f_58857_.f_46441_;
        for (int i = 0; i < n; ++i) {
            float x = (float)pos.m_123341_() + rnd.m_188501_();
            float y1 = (float)(pos.m_123342_() + 1) + rnd.m_188501_();
            float y2 = (float)(pos.m_123342_() + 2) + rnd.m_188501_();
            float z = (float)pos.m_123343_() + rnd.m_188501_();
            DustParticleOptions particle = new DustParticleOptions(new Vector3f(1.0f, green, blue), 1.0f);
            this.f_58857_.m_7106_((ParticleOptions)particle, (double)x, (double)y1, (double)z, 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)particle, (double)x, (double)y2, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public void consumeEnergy(int energy) {
        this.energy.useEnergy(energy);
    }

    public int getAvailableEnergy() {
        return (int)this.energy.getEnergy();
    }

    public int getWeightOf(Entity user) {
        boolean teleporterUseInventoryWeight = true;
        int weight = 0;
        if (user instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)user;
            ItemStack is = itemEntity.m_32055_();
            weight += 100 * ModUtils.getSize(is) / is.m_41741_();
        } else if (!(user instanceof Animal || user instanceof AbstractMinecart || user instanceof Boat)) {
            if (user instanceof Player) {
                Player player = (Player)user;
                weight += 1000;
                if (teleporterUseInventoryWeight) {
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        weight += TileEntityTeleporter.getStackCost(stack);
                    }
                }
            } else if (user instanceof Ghast) {
                weight += 2500;
            } else if (user instanceof WitherBoss) {
                weight += 5000;
            } else if (user instanceof EnderDragon) {
                weight += 10000;
            } else if (user instanceof PathfinderMob) {
                weight += 500;
            }
        } else {
            weight += 100;
        }
        if (user instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)user;
            for (ItemStack stack : living.m_6168_()) {
                weight += TileEntityTeleporter.getStackCost(stack);
            }
            if (user instanceof Player) {
                ItemStack stack = living.m_21205_();
                weight -= TileEntityTeleporter.getStackCost(stack);
            }
        }
        for (Entity passenger : user.m_20197_()) {
            weight += this.getWeightOf(passenger);
        }
        return weight;
    }

    private void onTeleportTo() {
        this.cooldown = 20;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public void setTarget(BlockPos pos) {
        this.target = pos;
        new PacketUpdateFieldTile(this, "target", this.target);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("cooldown")) {
            try {
                this.cooldown = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("target")) {
            try {
                this.target = (BlockPos)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.target);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.target = (BlockPos)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

