/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class TileEntityChargepadExperience
extends TileEntityInventory {
    private final ComponentBaseEnergy energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.EXPERIENCE, this, 2.0E9, 14));
    private Player player;

    public TileEntityChargepadExperience(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.exp_chargepad, pos, state);
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        super.onEntityCollision(entity);
        if (!this.getWorld().f_46443_ && entity instanceof Player && this.canEntityDestroy(entity)) {
            this.updatePlayer((Player)entity);
        }
    }

    protected void getItems(Player player) {
        if (!this.canEntityDestroy((Entity)player)) {
            IUCore.proxy.messagePlayer(player, Localization.translate("iu.error"));
            return;
        }
        this.chargeitems(player);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.exp_chargepad;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.player != null && this.energy.getEnergy() >= 1.0) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.getItems(this.player);
            this.player = null;
        } else if (this.getActive()) {
            this.setActive(false);
        }
        this.updatePlayer(null);
    }

    protected void updatePlayer(Player entity) {
        this.player = entity;
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0));
    }

    protected void chargeitems(Player player) {
        double value = Math.min(this.energy.getEnergy(), 1.0);
        this.energy.storage -= value - (double)ExperienceUtils.addPlayerXP1(player, (int)value);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            RandomSource rnd = this.f_58857_.f_46441_;
            int n = 4;
            float red = 0.0f;
            float green = 1.0f;
            float blue = 0.0f;
            float size = 1.0f;
            DustParticleOptions redstoneGreen = new DustParticleOptions(new Vector3f(red, green, blue), size);
            for (int i = 0; i < 4; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)redstoneGreen, (double)((float)this.f_58858_.m_123341_() + rnd.m_188501_()), (double)((float)(this.f_58858_.m_123342_() + 1) + rnd.m_188501_()), (double)((float)this.f_58858_.m_123343_() + rnd.m_188501_()), 0.0, 0.0, 0.0);
                this.f_58857_.m_7106_((ParticleOptions)redstoneGreen, (double)((float)this.f_58858_.m_123341_() + rnd.m_188501_()), (double)((float)(this.f_58858_.m_123342_() + 2) + rnd.m_188501_()), (double)((float)this.f_58858_.m_123343_() + rnd.m_188501_()), 0.0, 0.0, 0.0);
            }
        }
    }
}

