/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.multimechanism.triple;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMoreMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.tiles.mechanism.multimechanism.IFarmer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TileTripleFermer
extends TileMultiMachine
implements IFarmer {
    private final InvSlot fertilizerSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.m_41720_() == IUItem.fertilizer.getItem();
        }

        @Override
        public EnumTypeSlot getTypeSlot() {
            return EnumTypeSlot.FERTILIZER;
        }
    };
    private final SoilPollutionComponent pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
    private final AirPollutionComponent pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.075));
    int col = 0;

    public TileTripleFermer(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.TRIPLE_Fermer.usagePerTick, EnumMultiMachine.TRIPLE_Fermer.lenghtOperation, BlockMoreMachine3.triple_farmer, pos, state);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.col = customPacketBuffer.readInt();
    }

    @Override
    public int getFertilizer() {
        return this.col;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        packetBuffer.writeInt(this.col);
        return packetBuffer;
    }

    @Override
    public InvSlot getFertilizerSlot() {
        return this.fertilizerSlot;
    }

    @Override
    public int getSize(int size) {
        size = Math.min(super.getSize(size), this.fertilizerSlot.get(0).m_41613_() * 8 + this.col);
        return size;
    }

    @Override
    public boolean canoperate(int size) {
        return !this.fertilizerSlot.isEmpty() && this.fertilizerSlot.get(0).m_41613_() * 8 + this.col >= size;
    }

    @Override
    public void consume(int size) {
        int size1 = size;
        while (size1 > 0) {
            if (this.col == 0) {
                this.col += 16;
                this.fertilizerSlot.get(0).m_41774_(1);
            }
            if (size1 <= this.col) {
                this.col -= size1;
                size1 = 0;
                continue;
            }
            size1 -= this.col;
            this.col = 0;
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockMoreMachine3.triple_farmer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines_base3.getBlock(this.getTeBlock().getId());
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.TRIPLE_Fermer;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockFermer2.name");
    }

    public String getStartSoundFile() {
        return "Machines/Fermer.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

