/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.transport.tiles;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerCable;
import com.denfop.gui.GuiCable;
import com.denfop.gui.GuiCore;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.transport.DataCable;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.transport.types.ICableItem;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMultiCable
extends TileEntityInventory
implements IUpdatableTileEvent {
    public static List<BlockEntityType<? extends TileEntityMultiCable>> list = new ArrayList<BlockEntityType<? extends TileEntityMultiCable>>();
    public ICableItem cableItem;
    public byte connectivity;
    public ItemStack stackFacade = ItemStack.f_41583_;
    @OnlyIn(value=Dist.CLIENT)
    public DataCable dataCable;
    private ResourceLocation texture;
    private List<Direction> blackList = new ArrayList<Direction>();
    public static final NumberFormat lossFormat = new DecimalFormat("0.00#");

    public TileEntityMultiCable(ICableItem name, IMultiTileBlock tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
        this.cableItem = name;
        this.connectivity = 0;
        if (list != null && pos.equals((Object)BlockPos.f_121853_)) {
            list.add(tileBlock.getBlockType());
        }
    }

    public List<Direction> getBlackList() {
        return this.blackList;
    }

    public ICableItem getCableItem() {
        return this.cableItem;
    }

    public ResourceLocation getTexture() {
        if (this.texture == null) {
            this.texture = new ResourceLocation("industrialupgrade", "blocks/wiring/" + this.getCableItem().getMainPath() + "/" + this.getCableItem().getNameCable());
        }
        return this.texture;
    }

    public void removeConductor() {
        this.getWorld().m_7731_(this.pos, Blocks.f_50016_.m_49966_(), 3);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt = super.writeToNBT(nbt);
        CompoundTag nbt1 = new CompoundTag();
        if (!this.blackList.isEmpty()) {
            nbt1.m_128405_("size", this.blackList.size());
            for (int i = 0; i < this.blackList.size(); ++i) {
                nbt1.m_128405_(String.valueOf(i), this.blackList.get(i).ordinal());
            }
            nbt.m_128365_("list", (Tag)nbt1);
        }
        if (this.stackFacade != null && !this.stackFacade.m_41619_()) {
            CompoundTag nbt2 = new CompoundTag();
            this.stackFacade.m_41739_(nbt2);
            nbt.m_128365_("stackFacade", (Tag)nbt2);
        }
        return nbt;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.m_128441_("list")) {
            CompoundTag tagList = nbtTagCompound.m_128469_("list");
            int size = tagList.m_128451_("size");
            for (int i = 0; i < size; ++i) {
                this.blackList.add(Direction.values()[tagList.m_128451_(String.valueOf(i))]);
            }
        }
        if (nbtTagCompound.m_128441_("stackFacade")) {
            CompoundTag stackFacade = nbtTagCompound.m_128469_("stackFacade");
            this.stackFacade = ItemStack.m_41712_((CompoundTag)stackFacade);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
            this.updateConnectivity();
        }
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    @Override
    public SoundType getBlockSound(Entity entity) {
        return SoundType.f_56745_;
    }

    @Override
    public AABB getVisualBoundingBox() {
        return super.getVisualBoundingBox();
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        if (this.stackFacade == null || this.stackFacade.m_41619_() && !forCollision) {
            Direction[] var5;
            float th = this.cableItem.getThickness();
            float sp = (1.0f - th) / 2.0f;
            ArrayList<AABB> ret = new ArrayList<AABB>();
            ret.add(new AABB((double)sp, (double)sp, (double)sp, (double)(sp + th), (double)(sp + th), (double)(sp + th)));
            for (Direction facing : var5 = Direction.values()) {
                float zE;
                boolean hasConnection;
                boolean bl = hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                if (!hasConnection) continue;
                float zS = sp;
                float yS = sp;
                float xS = sp;
                float yE = zE = sp + th;
                float xE = zE;
                switch (facing) {
                    case DOWN: {
                        xS = sp + th;
                        xE = 1.0f;
                        break;
                    }
                    case UP: {
                        xS = 0.0f;
                        xE = sp;
                        break;
                    }
                    case NORTH: {
                        zS = sp + th;
                        zE = 1.0f;
                        break;
                    }
                    case SOUTH: {
                        zS = 0.0f;
                        zE = sp;
                        break;
                    }
                    case WEST: {
                        yS = sp + th;
                        yE = 1.0f;
                        break;
                    }
                    case EAST: {
                        yS = 0.0f;
                        yE = sp;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                ret.add(new AABB((double)xS, (double)yS, (double)zS, (double)xE, (double)yE, (double)zE));
            }
            return ret;
        }
        return super.getAabbs(forCollision);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }

    public void setConnectivity(byte connectivity) {
        if (this.connectivity != connectivity) {
            this.connectivity = connectivity;
            new PacketUpdateFieldTile(this, "connectivity", this.connectivity);
            Direction[] var5 = Direction.values();
            HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
            for (Direction facing : var5) {
                boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                booleanMap.put(facing, hasConnection);
            }
            this.m_155250_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_58900_().m_61124_((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).m_61124_((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).m_61124_((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).m_61124_((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).m_61124_((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).m_61124_((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST))));
            this.getWorld().m_7731_(this.f_58858_, this.m_58900_(), 3);
        }
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.f_58857_.f_46443_) {
            return false;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() && !this.stackFacade.m_41619_()) {
            this.stackFacade = ItemStack.f_41583_;
            new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
        }
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player var1, ContainerBase<?> var2) {
        return new GuiCable(this.getGuiContainer(var1));
    }

    public ContainerCable getGuiContainer(Player var1) {
        return new ContainerCable(var1, this);
    }

    @Override
    public BlockState m_58900_() {
        if (this.f_58856_ == null) {
            try {
                Direction[] var5 = Direction.values();
                HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
                for (Direction facing : var5) {
                    boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                    booleanMap.put(facing, hasConnection);
                }
                this.f_58856_ = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.block.m_49966_().m_61124_((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).m_61124_(this.block.facingProperty, (Comparable)this.getFacing())).m_61124_((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).m_61124_((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).m_61124_((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).m_61124_((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).m_61124_((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).m_61124_((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST)));
            }
            catch (Exception e) {
                this.f_58856_ = this.block.m_49966_();
            }
            return this.f_58856_;
        }
        return this.f_58856_;
    }

    public void updateConnectivity() {
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getWorld().f_46443_ && stack.m_41720_() == IUItem.facadeItem.getItem()) {
            Block block;
            CompoundTag nbt = ModUtils.nbt(stack);
            ListTag contentList = nbt.m_128437_("Items", 10);
            for (int i = 0; i < 1; ++i) {
                CompoundTag slotNbt = contentList.m_128728_(i);
                this.stackFacade = ItemStack.m_41712_((CompoundTag)slotNbt);
            }
            Block block2 = block = this.stackFacade.m_41720_() instanceof BlockItem ? ((BlockItem)this.stackFacade.m_41720_()).m_40614_() : Blocks.f_50016_;
            if (block != Blocks.f_50016_) {
                this.stackFacade = this.stackFacade.m_41777_();
                new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
            } else {
                this.stackFacade = ItemStack.f_41583_;
            }
        } else if (stack.m_41720_() == IUItem.connect_item.getItem()) {
            return super.onActivated(player, hand, side, vec3);
        }
        if (this instanceof ITransportConductor) {
            boolean can;
            boolean bl = can = ((ITransportConductor)((Object)this)).isInput() || ((ITransportConductor)((Object)this)).isOutput();
            if (can) {
                return super.onActivated(player, hand, side, vec3);
            }
            return false;
        }
        return false;
    }

    public void rerenderCable(ItemStack stack) {
        this.stackFacade = stack != ItemStack.f_41583_ ? stack.m_41777_() : stack;
        new PacketUpdateFieldTile(this, "stackFacade", this.stackFacade);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("connectivity")) {
            try {
                this.connectivity = (Byte)DecoderHandler.decode(is);
                Direction[] var5 = Direction.values();
                HashMap<Direction, Boolean> booleanMap = new HashMap<Direction, Boolean>();
                for (Direction facing : var5) {
                    boolean hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
                    booleanMap.put(facing, hasConnection);
                }
                this.m_155250_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.block.m_49966_().m_61124_((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).m_61124_(this.block.facingProperty, (Comparable)this.getFacing())).m_61124_((Property)BlockTileEntity.NORTH, (Comparable)((Boolean)booleanMap.get(Direction.SOUTH)))).m_61124_((Property)BlockTileEntity.SOUTH, (Comparable)((Boolean)booleanMap.get(Direction.NORTH)))).m_61124_((Property)BlockTileEntity.WEST, (Comparable)((Boolean)booleanMap.get(Direction.UP)))).m_61124_((Property)BlockTileEntity.EAST, (Comparable)((Boolean)booleanMap.get(Direction.DOWN)))).m_61124_((Property)BlockTileEntity.UP, (Comparable)((Boolean)booleanMap.get(Direction.WEST)))).m_61124_((Property)BlockTileEntity.DOWN, (Comparable)((Boolean)booleanMap.get(Direction.EAST))));
                this.getWorld().m_7731_(this.f_58858_, super.m_58900_(), 3);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("stackFacade")) {
            try {
                this.stackFacade = (ItemStack)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.stackFacade);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.stackFacade = (ItemStack)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer buffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(buffer, this.blackList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.blackList = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasSpecialModel() {
        return true;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        byte event1 = (byte)var2;
        Direction facing1 = Direction.values()[event1];
        if (this.blackList.contains(facing1)) {
            this.blackList.remove(facing1);
        } else {
            this.blackList.add(facing1);
        }
    }
}

