/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.sytem.InfoTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyForge
implements IEnergyTile {
    private final BlockEntity blockEntity;
    protected final Map<Direction, IEnergyStorage> storages;
    private long id;
    List<InfoTile<IEnergyTile>> validReceivers = new ArrayList<InfoTile<IEnergyTile>>();
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();

    public EnergyForge(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.storages = new HashMap<Direction, IEnergyStorage>();
        for (Direction direction : Direction.values()) {
            this.storages.put(direction, (IEnergyStorage)blockEntity.getCapability(ForgeCapabilities.ENERGY, direction).orElse((Object)new EnergyStorage(0, 0, 0, 0)));
        }
    }

    public Map<Direction, IEnergyStorage> getStorages() {
        return this.storages;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public BlockPos getPos() {
        return this.blockEntity.m_58899_();
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.blockEntity.m_58904_().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.blockEntity.m_58904_().f_46443_ && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public int getHashCodeSource() {
        return 0;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
    }
}

