/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item;

import com.denfop.api.radiationsystem.EnumLevelRadiation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IHazmatLike {
    public static boolean hasCompleteHazmat(LivingEntity living) {
        return IHazmatLike.hasCompleteHazmat(living, EnumLevelRadiation.LOW);
    }

    public static boolean hasCompleteHazmat(LivingEntity living, EnumLevelRadiation levelRadiation) {
        EquipmentSlot[] var1 = EquipmentSlot.values();
        int var2 = var1.length;
        block8: for (EquipmentSlot slot : var1) {
            Item item;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack stack = living.m_6844_(slot);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof IHazmatLike)) {
                return false;
            }
            IHazmatLike hazmat = (IHazmatLike)item;
            if (!hazmat.addsProtection(living, slot, stack)) {
                return false;
            }
            if (hazmat.fullyProtects(living, slot, stack)) {
                switch (levelRadiation) {
                    case LOW: 
                    case DEFAULT: 
                    case MEDIUM: {
                        return hazmat.getLevel() >= 1;
                    }
                    case HIGH: 
                    case VERY_HIGH: {
                        return hazmat.getLevel() > 1;
                    }
                }
                return false;
            }
            switch (levelRadiation) {
                case LOW: 
                case DEFAULT: 
                case MEDIUM: {
                    if (hazmat.getLevel() >= 1) continue block8;
                    return false;
                }
                case HIGH: 
                case VERY_HIGH: {
                    if (hazmat.getLevel() > 1) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    default public int getLevel() {
        return 1;
    }

    public boolean addsProtection(LivingEntity var1, EquipmentSlot var2, ItemStack var3);

    default public boolean fullyProtects(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        return false;
    }
}

