/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.building.StorageBuilding;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Storage
implements IStorage {
    private final StorageBuilding storageBuilding;
    private final int maxvaluefluid;
    List<ItemStack> itemStackList;
    List<FluidStack> fluidStackList;
    private int max;
    private int fluidmax;

    public Storage(StorageBuilding storageBuilding) {
        this.itemStackList = new LinkedList<ItemStack>();
        this.fluidStackList = new LinkedList<FluidStack>();
        this.max = 5;
        this.fluidmax = 10;
        this.maxvaluefluid = 10000;
        this.storageBuilding = storageBuilding;
    }

    public Storage(CompoundTag tag, StorageBuilding storageBuilding) {
        this.maxvaluefluid = 10000;
        this.storageBuilding = storageBuilding;
        this.readNBT(tag);
    }

    public Storage(CustomPacketBuffer packetBuffer, StorageBuilding storageBuilding) {
        this.maxvaluefluid = 10000;
        this.storageBuilding = storageBuilding;
        this.readPacket(packetBuffer);
    }

    @Override
    public StorageBuilding getStorageBuilding() {
        return this.storageBuilding;
    }

    @Override
    public List<ItemStack> getStacks() {
        return this.itemStackList;
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        return this.fluidStackList;
    }

    @Override
    public int getMaxStorage() {
        return this.max;
    }

    @Override
    public int getMaxStorageForFluid() {
        return this.fluidmax;
    }

    @Override
    public void addMaxStorage(int storage) {
        this.max += storage;
    }

    @Override
    public void addMaxStorageForFluid(int storage) {
        this.fluidmax += storage;
    }

    @Override
    public boolean canAddFluidStack(FluidStack fluidStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        if (fluidStack == null) {
            return false;
        }
        List<FluidStack> fluidStacks = this.getFluidStacks();
        boolean added = false;
        fluidStacks.removeIf(Objects::isNull);
        for (FluidStack stack : fluidStacks) {
            if (!stack.isFluidEqual(fluidStack)) continue;
            if (stack.getAmount() + fluidStack.getAmount() <= this.maxvaluefluid) {
                stack.grow(fluidStack.getAmount());
                return true;
            }
            if (stack.getAmount() >= this.maxvaluefluid) continue;
            int amount = this.maxvaluefluid - stack.getAmount();
            stack.grow(amount);
            fluidStack.shrink(amount);
            added = true;
        }
        if (added && fluidStack.getAmount() > 0 && this.getFluidStacks().size() < this.fluidmax) {
            fluidStacks.add(fluidStack);
            return true;
        }
        if (this.getFluidStacks().size() >= this.fluidmax) {
            return false;
        }
        this.getFluidStacks().add(fluidStack);
        return true;
    }

    @Override
    public boolean canRemoveFluidStack(FluidStack fluidStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        List<FluidStack> fluidStacks = this.getFluidStacks();
        for (FluidStack stack : fluidStacks) {
            if (!stack.isFluidEqual(fluidStack) || stack.getAmount() - fluidStack.getAmount() < 0) continue;
            stack.shrink(fluidStack.getAmount());
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddItemStack(ItemStack itemStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        List<ItemStack> stackList = this.getStacks();
        int size = itemStack.m_41613_();
        boolean added = false;
        for (ItemStack stack : stackList) {
            if (!ModUtils.checkItemEquality(itemStack, stack)) continue;
            if (stack.m_41613_() + size <= stack.m_41741_()) {
                stack.m_41769_(size);
                return true;
            }
            if (stack.m_41613_() >= stack.m_41741_()) continue;
            int amount = stack.m_41741_() - stack.m_41613_();
            stack.m_41769_(amount);
            itemStack.m_41774_(amount);
            size = itemStack.m_41613_();
            added = true;
        }
        if (added && itemStack.m_41613_() > 0 && this.getStacks().size() < this.max) {
            this.itemStackList.add(itemStack);
            return true;
        }
        if (this.getStacks().size() >= this.max) {
            return false;
        }
        this.getStacks().add(itemStack);
        return true;
    }

    @Override
    public boolean canRemoveItemStack(ItemStack itemStack) {
        if (!this.getStorageBuilding().getWork()) {
            return false;
        }
        List<ItemStack> itemStackList = this.getStacks();
        for (ItemStack stack : itemStackList) {
            if (!ModUtils.checkItemEquality(itemStack, stack) || stack.m_41613_() - itemStack.m_41613_() < 0) continue;
            stack.m_41774_(itemStack.m_41613_());
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeNBT(CompoundTag tag) {
        tag.m_128405_("max", this.max);
        tag.m_128405_("fluidmax", this.fluidmax);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("col", this.getStacks().size());
        for (int i = 0; i < this.getStacks().size(); ++i) {
            nbt.m_128365_(String.valueOf(i), (Tag)this.getStacks().get(i).m_41739_(new CompoundTag()));
        }
        tag.m_128365_("stacks", (Tag)nbt);
        CompoundTag nbt1 = new CompoundTag();
        nbt1.m_128405_("col_fluid", this.getFluidStacks().size());
        for (int i = 0; i < this.getFluidStacks().size(); ++i) {
            if (this.fluidStackList.get(i) == null) continue;
            nbt1.m_128365_(String.valueOf(i), (Tag)this.getFluidStacks().get(i).writeToNBT(new CompoundTag()));
        }
        tag.m_128365_("fluids", (Tag)nbt1);
        return tag;
    }

    public void readPacket(CustomPacketBuffer tag) {
        this.max = tag.readInt();
        this.fluidmax = tag.readInt();
        CompoundTag nbt = tag.m_130260_();
        assert (nbt != null);
        int size = nbt.m_128451_("col");
        this.itemStackList = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            this.itemStackList.add(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(String.valueOf(i))));
        }
        CompoundTag nbt1 = tag.m_130260_();
        assert (nbt1 != null);
        size = nbt1.m_128451_("col_fluid");
        this.fluidStackList = new ArrayList<FluidStack>();
        for (int i = 0; i < size; ++i) {
            this.fluidStackList.add(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt1.m_128469_(String.valueOf(i))));
        }
    }

    @Override
    public void readNBT(CompoundTag tag) {
        this.max = tag.m_128451_("max");
        this.fluidmax = tag.m_128451_("fluidmax");
        CompoundTag nbt = tag.m_128469_("stacks");
        int size = nbt.m_128451_("col");
        this.itemStackList = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            this.itemStackList.add(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(String.valueOf(i))));
        }
        CompoundTag nbt1 = tag.m_128469_("fluids");
        size = nbt1.m_128451_("col_fluid");
        this.fluidStackList = new ArrayList<FluidStack>();
        for (int i = 0; i < size; ++i) {
            this.fluidStackList.add(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt1.m_128469_(String.valueOf(i))));
        }
    }

    @Override
    public boolean work() {
        return this.storageBuilding.work;
    }

    @Override
    public void writePacket(CustomPacketBuffer customPacketBuffer) {
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.fluidmax);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("col", this.getStacks().size());
        for (int i = 0; i < this.getStacks().size(); ++i) {
            nbt.m_128365_(String.valueOf(i), (Tag)this.getStacks().get(i).m_41739_(new CompoundTag()));
        }
        customPacketBuffer.m_130079_(nbt);
        CompoundTag nbt1 = new CompoundTag();
        nbt1.m_128405_("col_fluid", this.getStacks().size());
        for (int i = 0; i < this.getFluidStacks().size(); ++i) {
            if (this.getFluidStacks().get(i) == null) continue;
            nbt1.m_128365_(String.valueOf(i), (Tag)this.getFluidStacks().get(i).writeToNBT(new CompoundTag()));
        }
        customPacketBuffer.m_130079_(nbt1);
    }
}

