/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataBlock;
import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.api.item.IVolcanoArmor;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.world.WorldBaseGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class BlockBasalts<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public static final BooleanProperty BOOL_PROPERTY = BooleanProperty.m_61465_((String)"hasdamage");

    public BlockBasalts(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60977_().m_60953_(blockState -> ((ISubEnum)((Object)element)).getId() == 4 ? 8 : 0).m_155954_(((Type)element).getHardness()).m_155956_(((Type)element).getExplosionResistance()).m_60918_(((Type)element).metal ? SoundType.f_56743_ : SoundType.f_56742_).m_60999_(), elements, element, dataBlock);
        BlockTagsProvider.list.add(this);
    }

    @Override
    public List<ItemStack> getDrops(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int fortune) {
        Random rand = WorldBaseGen.random;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int meta = ((ISubEnum)this.getElement()).getId();
        if (meta == 6) {
            drops.add(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(31), rand.nextInt(2) + 1 + rand.nextInt(fortune + 1)));
        } else if (meta == 7) {
            drops.add(new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(477), rand.nextInt(2) + 1 + rand.nextInt(fortune + 1)));
        } else if (meta == 5) {
            drops.add(new ItemStack((ItemLike)IUItem.basalts.getItem(2), 1));
        } else if (meta == 1) {
            drops.add(new ItemStack((ItemLike)IUItem.basalts.getItem(8), 1));
        } else {
            drops.add(new ItemStack((ItemLike)this.getBlock()));
        }
        return drops;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        boolean damage = (Boolean)state.m_61143_((Property)BOOL_PROPERTY);
        if (!damage) {
            return;
        }
        AABB axisAlignedBB = new AABB((double)(pos.m_123341_() - 2), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 2), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
        List players = level.m_45976_(Player.class, axisAlignedBB);
        for (Player player : players) {
            if (IVolcanoArmor.hasCompleteHazmat((LivingEntity)player)) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)IUPotion.poison_gas, 200, 0));
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        state = (BlockState)state.m_61124_((Property)BOOL_PROPERTY, (Comparable)Boolean.valueOf(false));
        level.m_46597_(pos, state);
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_);
        p_49915_.m_61104_(new Property[]{BOOL_PROPERTY});
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOOL_PROPERTY, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.f_49792_.m_61090_()).m_60734_()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)1);
    }

    public static enum Type implements ISubEnum
    {
        basalt(5.0f, 45.0f, false),
        basalt_cobblestone(5.0f, 45.0f, false),
        basalt_melted(10.0f, 45.0f, false),
        basalt_blocked(5.0f, 45.0f, false),
        basalt_magma(2.5f, 45.0f, false),
        basalt_pylon(5.0f, 45.0f, false),
        basalt_sulfur_ore(5.0f, 45.0f, false),
        basalt_boron_ore(10.0f, 45.0f, false),
        basalt_spongy(5.0f, 45.0f, false),
        basalt_smooth(5.0f, 45.0f, false);

        private final float hardness;
        private final float explosionResistance;
        private final boolean metal;
        private final int metadata = this.ordinal();
        private final String name = this.name().toLowerCase(Locale.US);

        private Type(float hardness, float explosionResistance, boolean metal) {
            this.hardness = hardness;
            this.explosionResistance = explosionResistance;
            this.metal = metal;
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public float getExplosionResistance() {
            return this.explosionResistance;
        }

        public float getHardness() {
            return this.hardness;
        }

        public boolean isMetal() {
            return this.metal;
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "blockbasalts";
        }

        public int getLight() {
            return 0;
        }
    }
}

