/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.pressure.IPressureAcceptor;
import com.denfop.api.pressure.IPressureEmitter;
import com.denfop.api.pressure.IPressureSink;
import com.denfop.api.pressure.IPressureSource;
import com.denfop.api.pressure.IPressureTile;
import com.denfop.api.pressure.event.PressureTileLoadEvent;
import com.denfop.api.pressure.event.PressureTileUnloadEvent;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class PressureComponent
extends AbstractComponent {
    public final Level world;
    public final boolean fullEnergy;
    private final double defaultCapacity;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public List<InvSlot> managedSlots;
    public boolean multiSource = false;
    public int sourcePackets = 1;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public boolean need;
    public boolean auto;
    public boolean allow;
    Random rand = new Random();
    private long id;
    Map<Direction, IPressureTile> energyConductorMap = new HashMap<Direction, IPressureTile>();
    List<InfoTile<IPressureTile>> validReceivers = new LinkedList<InfoTile<IPressureTile>>();

    public PressureComponent(TileEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public PressureComponent(TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public PressureComponent(TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.capacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.fullEnergy = fullEnergy;
        this.world = parent.m_58904_();
        this.defaultCapacity = capacity;
        this.need = true;
        this.allow = false;
    }

    public static PressureComponent asBasicSink(TileEntityInventory parent, double capacity) {
        return PressureComponent.asBasicSink(parent, capacity, 1);
    }

    public static PressureComponent asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new PressureComponent(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static PressureComponent asBasicSource(TileEntityInventory parent, double capacity) {
        return PressureComponent.asBasicSource(parent, capacity, 1);
    }

    public static PressureComponent asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new PressureComponent(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.storage = nbt.m_128459_("storage");
        this.capacity = nbt.m_128459_("capacity");
        this.need = nbt.m_128471_("need");
        this.allow = nbt.m_128471_("allow");
        this.auto = nbt.m_128471_("auto");
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        packet.writeDouble(this.capacity);
        packet.writeDouble(this.storage);
        packet.writeBoolean(this.need);
        packet.writeBoolean(this.allow);
        packet.writeBoolean(this.auto);
        return packet;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.m_128347_("storage", this.storage);
        ret.m_128347_("capacity", this.capacity);
        ret.m_128379_("need", this.need);
        ret.m_128379_("allow", this.allow);
        ret.m_128379_("auto", this.auto);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.capacity < this.defaultCapacity) {
            this.capacity = this.defaultCapacity;
        }
        if (!this.parent.m_58904_().f_46443_) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                MinecraftForge.EVENT_BUS.post((Event)new PressureTileLoadEvent(this.delegate, this.parent.m_58904_()));
            }
            this.loaded = true;
        }
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return false;
    }

    public void createDelegate() {
        if (this.delegate == null) {
            assert (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty());
            if (this.sinkDirections.isEmpty()) {
                this.delegate = new EnergyNetDelegateSource();
            } else if (this.sourceDirections.isEmpty()) {
                this.delegate = new EnergyNetDelegateSink();
            }
            if (this.delegate == null) {
                return;
            }
            this.delegate.m_142339_(this.parent.m_58904_());
        }
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        super.onBlockActivated(player, hand);
        return false;
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            MinecraftForge.EVENT_BUS.post((Event)new PressureTileUnloadEvent(this.delegate, this.parent.m_58904_()));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        buffer.writeBoolean(this.need);
        buffer.writeBoolean(this.allow);
        buffer.writeBoolean(this.auto);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
        this.need = is.readBoolean();
        this.allow = is.readBoolean();
        this.auto = is.readBoolean();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        if (this.storage > this.capacity) {
            this.storage = this.capacity;
        }
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFillRatio() {
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        this.storage += amount;
        this.storage = Math.min(this.storage, this.capacity);
        this.storage = Math.max(this.storage, 0.0);
        return amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            if (this.storage < 0.0) {
                this.storage = 0.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.parent.m_58904_().m_46467_() % 120L == 0L) {
            this.useEnergy(1.0);
        }
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
            if (this.storage < 0.0) {
                this.storage = 0.0;
            }
        }
        return ret;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<Direction> sinkDirections, Set<Direction> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.m_58904_().f_46443_);
            MinecraftForge.EVENT_BUS.post((Event)new PressureTileUnloadEvent(this.delegate, this.world));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.m_58904_().f_46443_);
            MinecraftForge.EVENT_BUS.post((Event)new PressureTileLoadEvent(this.delegate, this.world));
        }
    }

    public long getIdNetwork() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Map<Direction, IPressureTile> getConductors() {
        return this.energyConductorMap;
    }

    public void RemoveTile(IPressureTile tile, Direction facing1) {
        if (!this.parent.m_58904_().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IPressureTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IPressureTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    public List<InfoTile<IPressureTile>> getValidReceivers() {
        return this.validReceivers;
    }

    public void AddTile(IPressureTile tile, Direction facing1) {
        if (!this.parent.m_58904_().f_46443_) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IPressureTile>(tile, facing1.m_122424_()));
        }
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<Direction> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public IPressureTile getDelegate() {
        return this.delegate;
    }

    private abstract class EnergyNetDelegate
    extends BlockEntity
    implements IPressureTile {
        private int hashCodeSource;

        private EnergyNetDelegate() {
            super(PressureComponent.this.parent.m_58903_(), PressureComponent.this.parent.m_58899_(), PressureComponent.this.parent.m_58900_());
        }

        @Override
        public long getIdNetwork() {
            return PressureComponent.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            PressureComponent.this.setId(id);
        }

        @Override
        public void AddTile(IPressureTile tile, Direction dir) {
            PressureComponent.this.AddTile(tile, dir);
        }

        @Override
        public void RemoveTile(IPressureTile tile, Direction dir) {
            PressureComponent.this.RemoveTile(tile, dir);
        }

        @Override
        public Map<Direction, IPressureTile> getTiles() {
            return PressureComponent.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<IPressureTile>> getValidReceivers() {
            return PressureComponent.this.validReceivers;
        }
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements IPressureSource {
        private EnergyNetDelegateSource() {
        }

        public int getSourceTier() {
            return PressureComponent.this.sourceTier;
        }

        @Override
        public boolean emitsPressureTo(IPressureAcceptor receiver, Direction dir) {
            return PressureComponent.this.sourceDirections.contains(dir);
        }

        @Override
        public double getOfferedPressure() {
            return PressureComponent.this.storage;
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return PressureComponent.this.parent.m_58899_();
        }

        @Override
        public void drawPressure(double amount) {
        }

        @Override
        public boolean isAllowed() {
            return PressureComponent.this.allow;
        }

        @Override
        public boolean setAllowed(boolean allowed) {
            PressureComponent.this.allow = allowed;
            return PressureComponent.this.allow;
        }

        @Override
        public BlockEntity getTile() {
            return PressureComponent.this.parent;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements IPressureSink {
        List<IPressureSource> systemTicks = new LinkedList<IPressureSource>();

        private EnergyNetDelegateSink() {
        }

        public int getSinkTier() {
            return PressureComponent.this.sinkTier;
        }

        @Override
        public boolean acceptsPressureFrom(IPressureEmitter emitter, Direction dir) {
            return PressureComponent.this.sinkDirections.contains(dir);
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return PressureComponent.this.parent.m_58899_();
        }

        @Override
        public double getDemandedPressure() {
            return PressureComponent.this.capacity;
        }

        @Override
        public void receivedPressure(double amount) {
            this.setPressureStored(amount);
        }

        @Override
        public boolean needTemperature() {
            return PressureComponent.this.need;
        }

        @Override
        public List<IPressureSource> getEnergyTickList() {
            return this.systemTicks;
        }

        public void setPressureStored(double amount) {
            if (PressureComponent.this.storage < amount) {
                PressureComponent.this.storage = amount;
            }
        }

        @Override
        public BlockEntity getTile() {
            return PressureComponent.this.parent;
        }
    }
}

