/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.container.ContainerEFReader;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GUIEFReader<T extends ContainerEFReader>
extends GuiIU<ContainerEFReader> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guitooleumeter.png");
    private final String name;
    private final ItemStack itemStack;
    private double min = Double.MAX_VALUE;
    private double max = 0.0;
    private double average = 0.0;
    private double col = 0.0;
    private double energySink = 0.0;
    private double energySource = 0.0;
    private long tick = 0L;
    private byte mode = 0;

    public GUIEFReader(ContainerEFReader container, ItemStack itemStack1) {
        super(container);
        this.componentList.clear();
        this.name = itemStack1.m_41611_().getString();
        this.itemStack = itemStack1;
        this.f_97727_ = 121;
        this.f_97726_ = 188;
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.f_96547_.m_92883_(poseStack, this.name, (float)((this.f_97726_ - this.getStringWidth(this.name)) / 2), 6.0f, 0);
        this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.mode") + " Sink", (float)((169 + this.getStringWidth(Localization.translate("itemToolMEter.mode") + " Sink")) / 2), 18.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
        this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.mode") + " Source", (float)((169 + this.getStringWidth(Localization.translate("itemToolMEter.mode") + " Sink")) / 2), 78.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
        if (this.mode == 0) {
            this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.mode.EnergyIn") + ":", 12.0f, 18.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, ModUtils.getString(this.energySink) + " EF/t", 12.0f, 28.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.avg") + " " + ModUtils.getString(this.average / (double)this.tick) + " EF/t", 8.0f, 38.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.max/min") + ": ", 12.0f, 48.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, ModUtils.getString(this.max) + "/" + ModUtils.getString(this.min), 12.0f, 58.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
        }
        if (this.mode == 1) {
            this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.mode.EnergyOut") + ":", 12.0f, 18.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, ModUtils.getString(this.energySource) + " EF/t", 12.0f, 28.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.avg") + " " + ModUtils.getString(this.average / (double)this.tick) + " EF/t", 8.0f, 38.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.max/min") + ": ", 12.0f, 48.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.f_96547_.m_92883_(poseStack, ModUtils.getString(this.max) + "/" + ModUtils.getString(this.min), 12.0f, 58.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
        }
        this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.cycle", ModUtils.getString((double)this.tick / 40.0)), 12.0f, 78.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
        this.f_96547_.m_92883_(poseStack, Localization.translate("itemToolMEter.mode.reset"), 38.0f, 101.0f, ModUtils.convertRGBcolorToInt(0, 0, 0));
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
        if (this.mode == 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 130, this.guiTop + 34, 198, 35, 19, 17);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 130, this.guiTop + 54, 198, 55, 19, 17);
        }
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = mouseX - xMin;
        int y = mouseY - yMin;
        if (x >= 130 && y >= 34 && x <= 149 && y <= 51) {
            this.mode = 0;
            this.average = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.tick = 0L;
            this.col = 0.0;
        }
        if (x >= 130 && y >= 54 && x <= 149 && y <= 71) {
            this.mode = 1;
            this.average = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.tick = 0L;
            this.col = 0.0;
        }
        if (x >= 18 && y >= 96 && x <= 82 && y <= 113) {
            this.average = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = 0.0;
            this.tick = 0L;
            this.col = 0.0;
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }

    public void readField(String string, CustomPacketBuffer packetBuffer) {
        packetBuffer.readByte();
        if (string.equals("energySink")) {
            this.energySink = packetBuffer.readDouble();
        }
        if (string.equals("energySource")) {
            this.energySource = packetBuffer.readDouble();
        }
        if (this.mode == 0) {
            if (this.min > this.energySink) {
                this.min = this.energySink;
            }
            if (this.max < this.energySink) {
                this.max = this.energySink;
            }
            this.average += this.energySink;
        }
        if (this.mode == 1) {
            if (this.min > this.energySource) {
                this.min = this.energySource;
            }
            if (this.max < this.energySource) {
                this.max = this.energySource;
            }
            this.average += this.energySource;
        }
        ++this.tick;
    }
}

