/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.ImageInterface;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.recipe.InvSlotMultiRecipes;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcessRender;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerMultiMachine;
import com.denfop.container.SlotInvSlot;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GuiMultiMachine<T extends ContainerMultiMachine>
extends GuiIU<ContainerMultiMachine> {
    private final ContainerMultiMachine container;
    private final GuiComponent process;
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public GuiMultiMachine(ContainerMultiMachine container1) {
        super(container1, ((TileMultiMachine)container1.base).getMachine().getComponent());
        this.container = container1;
        if (((TileMultiMachine)container1.base).getMachine().sizeWorkingSlot == 8) {
            this.f_97726_ += 60;
            this.addElement(new ImageInterface(this, 0, 0, this.f_97726_, this.f_97727_));
        } else {
            this.f_97726_ = 192;
        }
        this.process = new GuiComponent(this, 0, 0, EnumTypeComponent.MULTI_PROCESS, new Component<ComponentProcessRender>(new ComponentProcessRender(((TileMultiMachine)container1.base).multi_process, ((TileMultiMachine)container1.base).getTypeMachine())));
        this.addComponent(new GuiComponent(this, 4, 15, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addComponent(new GuiComponent(this, 10, 45, EnumTypeComponent.ENERGY, new Component<Energy>(((TileMultiMachine)this.container.base).energy)));
        if (((TileMultiMachine)this.container.base).getMachine().type != EnumTypeMachines.Centrifuge && ((TileMultiMachine)this.container.base).sizeWorkingSlot != 8) {
            this.addComponent(new GuiComponent(this, 27, 47, EnumTypeComponent.COLD, new Component<CoolComponent>(((TileMultiMachine)this.container.base).cold)));
        }
        if (((TileMultiMachine)this.container.base).tank != null) {
            this.addComponent(new GuiComponent(this, 27, 63, EnumTypeComponent.WATER, new Component<FluidTank>(((TileMultiMachine)this.container.base).tank)));
        }
        if (((TileMultiMachine)this.container.base).getMachine().type == EnumTypeMachines.Centrifuge) {
            this.addComponent(new GuiComponent(this, 27, 63, EnumTypeComponent.COLD, new Component<HeatComponent>(((TileMultiMachine)this.container.base).heat)));
        }
        this.addComponent(new GuiComponent(this, 27, 63, EnumTypeComponent.EXP, new Component<ComponentBaseEnergy>(((TileMultiMachine)this.container.base).exp)));
        this.isBlack = false;
        if (((TileMultiMachine)this.container.base).multi_process.quickly) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_quickly.getItem()));
        }
        if (((TileMultiMachine)this.container.base).multi_process.modulesize) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_stack.getItem()));
        }
        if (((TileMultiMachine)this.container.base).multi_process.modulestorage) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_storage.getItem()));
        }
        if (((TileMultiMachine)this.container.base).multi_process.module_infinity_water) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()));
        }
        if (((TileMultiMachine)this.container.base).multi_process.module_separate) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module_separate.getItem()));
        }
        if (((TileMultiMachine)this.container.base).solartype != null) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.module6.getStack(((TileMultiMachine)this.container.base).solartype.meta), 1));
        }
        if (((TileMultiMachine)this.container.base).cold.upgrade && ((TileMultiMachine)this.container.base).getTypeMachine() != EnumTypeMachines.Centrifuge) {
            this.itemStackList.add(new ItemStack((ItemLike)IUItem.coolupgrade.getStack(((TileMultiMachine)this.container.base).cold.meta), 1));
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.drawForeground(poseStack, mouseX, mouseY);
        if (((TileMultiMachine)this.container.base).getMachine().type == EnumTypeMachines.FARMER) {
            this.draw(poseStack, String.valueOf(((TileMultiMachine)this.container.base).getFertilizer()), 12, 35, ModUtils.convertRGBcolorToInt(0, 0, 0));
            ((Area)new Area(this, 10, 33, 10, 10).withTooltip(Localization.translate("iu.farmer.fertilizer.info") + "\n" + Localization.translate("iu.farmer.fertilizer.info1"))).drawForeground(poseStack, mouseX, mouseY);
        }
        int i = 0;
        for (Slot slot : this.container.f_38839_) {
            if (!(slot instanceof SlotInvSlot)) continue;
            int xX = slot.f_40220_;
            int yY = slot.f_40221_;
            SlotInvSlot slotInv = (SlotInvSlot)slot;
            if (!(slotInv.invSlot instanceof InvSlotMultiRecipes)) continue;
            this.process.setIndex(i);
            this.process.setX(xX);
            this.process.setY(yY + 19);
            this.process.drawForeground(poseStack, mouseX, mouseY);
            ++i;
        }
        i = 0;
        for (ItemStack stack : this.itemStackList) {
            ((Area)new Area(this, this.f_97726_, 5 + i * 18, 16, 16).withTooltip(stack.m_41611_().getString())).drawForeground(poseStack, mouseX, mouseY);
            ++i;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiMultiMachine.bindTexture(this.getTexture());
        int j = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, j, k, 0, 0, 176, this.f_97727_);
        for (GuiElement guiElement : this.elements) {
            guiElement.drawBackground(poseStack, x - this.guiLeft, y - this.guiTop);
        }
        GuiMultiMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
        GuiMultiMachine.bindTexture(this.getTexture());
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        this.drawBackground(poseStack);
        int i = 0;
        for (Slot slot : this.container.f_38839_) {
            if (!(slot instanceof SlotInvSlot)) continue;
            int xX = slot.f_40220_;
            int yY = slot.f_40221_;
            SlotInvSlot slotInv = (SlotInvSlot)slot;
            if (!(slotInv.invSlot instanceof InvSlotMultiRecipes)) continue;
            this.process.setIndex(i);
            this.process.setX(xX);
            this.process.setY(yY + 19);
            this.process.drawBackground(poseStack, xoffset, yoffset);
            ++i;
        }
        GuiMultiMachine.bindTexture(this.getTexture());
        String name = Localization.translate(((TileMultiMachine)this.container.base).getName());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.f_97726_ / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 6) / scale);
        this.f_96547_.m_92883_(poseStack, name, (float)textX, (float)textY, 0x404040);
        poseStack.m_85849_();
        i = 0;
        for (ItemStack stack : this.itemStackList) {
            new ItemStackImage(this, this.f_97726_, 5 + i * 18, () -> stack).drawBackground(poseStack, this.guiLeft, this.guiTop);
            ++i;
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine_main.png");
    }
}

