/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.heavyanvil;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class HeavyAnvilHandler {
    private static final List<HeavyAnvilHandler> recipes = new ArrayList<HeavyAnvilHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public HeavyAnvilHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public static List<HeavyAnvilHandler> getRecipes() {
        if (recipes.isEmpty()) {
            HeavyAnvilHandler.initRecipes();
        }
        return recipes;
    }

    public static HeavyAnvilHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        HeavyAnvilHandler recipe = new HeavyAnvilHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("strong_anvil")) {
            HeavyAnvilHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

