/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.brewage.EnumBeerVariety;
import com.denfop.api.brewage.EnumTimeVariety;
import com.denfop.api.brewage.EnumWaterVariety;
import com.denfop.items.IProperties;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBooze
extends Item
implements IProperties {
    public int[] baseDuration = new int[]{300, 900, 1200, 1600, 2000, 2400};
    public float[] baseIntensity = new float[]{0.4f, 0.75f, 1.0f, 1.5f, 2.0f};
    private String nameItem;

    public ItemBooze() {
        super(new Item.Properties().m_41491_(IUCore.EnergyTab).m_41487_(1).setNoRepair());
        IUCore.proxy.addProperties(this);
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity living) {
        CompoundTag nbtTagCompound = stack.m_41784_();
        if (!nbtTagCompound.m_128441_("beer")) {
            return new ItemStack((ItemLike)this);
        }
        EnumWaterVariety waterVariety = EnumWaterVariety.values()[nbtTagCompound.m_128445_("waterVariety")];
        EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbtTagCompound.m_128445_("timeVariety")];
        EnumBeerVariety beerVariety = EnumBeerVariety.values()[nbtTagCompound.m_128445_("beerVariety")];
        if (timeVariety == EnumTimeVariety.BLACK_STUFF || waterVariety == EnumWaterVariety.BLACK_STUFF || beerVariety == EnumBeerVariety.BLACKSTUFF) {
            return this.drinkBlackStuff(living);
        }
        int solidRatio = waterVariety.ordinal();
        int level = beerVariety.ordinal();
        int duration = this.baseDuration[solidRatio];
        float intensity = this.baseIntensity[timeVariety.ordinal()];
        if (living instanceof Player) {
            ((Player)living).m_36324_().m_38707_(5 - level, (float)solidRatio * 0.15f);
        }
        int max = (int)(intensity * (float)level * 0.5f);
        MobEffectInstance slow = living.m_21124_(MobEffects.f_19599_);
        level = -1;
        if (slow != null) {
            level = slow.m_19564_();
        }
        nbtTagCompound.m_128344_("amount", (byte)(nbtTagCompound.m_128445_("amount") - 1));
        this.amplifyEffect(living, MobEffects.f_19599_, max, intensity, duration);
        if (level > -1) {
            this.amplifyEffect(living, MobEffects.f_19600_, max, intensity, duration);
            if (level > 0) {
                this.amplifyEffect(living, MobEffects.f_19597_, max / 2, intensity, duration);
                if (level > 1) {
                    this.amplifyEffect(living, MobEffects.f_19606_, max - 1, intensity, duration);
                    if (level > 2) {
                        this.amplifyEffect(living, MobEffects.f_19604_, 0, intensity, duration);
                        if (level > 3) {
                            living.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 1, world.f_46441_.m_188503_(3)));
                        }
                    }
                }
            }
        }
        return nbtTagCompound.m_128445_("amount") > 0 ? stack : new ItemStack((ItemLike)this);
    }

    public void amplifyEffect(LivingEntity living, MobEffect effect, int max, float intensity, int duration) {
        MobEffectInstance eff = living.m_21124_(effect);
        if (eff == null) {
            living.m_7292_(new MobEffectInstance(effect, duration, 0));
        } else {
            int currentDuration = eff.m_19557_();
            int maxNewDuration = (int)(((float)duration * (1.0f + intensity * 2.0f) - (float)currentDuration) / 2.0f);
            if (maxNewDuration < 0) {
                maxNewDuration = 0;
            }
            if (maxNewDuration < duration) {
                duration = maxNewDuration;
            }
            currentDuration += duration;
            int newAmp = eff.m_19564_();
            if (newAmp < max) {
                ++newAmp;
            }
            living.m_7292_(new MobEffectInstance(effect, currentDuration, newAmp));
        }
    }

    public ItemStack drinkBlackStuff(LivingEntity living) {
        switch (living.m_20193_().f_46441_.m_188503_(6)) {
            case 1: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 1200, 0));
                break;
            }
            case 2: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 2400, 0));
                break;
            }
            case 3: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 2400, 0));
                break;
            }
            case 4: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 2));
                break;
            }
            case 5: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 1, living.m_20193_().f_46441_.m_188503_(4)));
            }
        }
        return new ItemStack((ItemLike)this);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_("beer")) {
            EnumWaterVariety waterVariety = EnumWaterVariety.values()[nbtTagCompound.m_128445_("waterVariety")];
            EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbtTagCompound.m_128445_("timeVariety")];
            EnumBeerVariety beerVariety = EnumBeerVariety.values()[nbtTagCompound.m_128445_("beerVariety")];
            tooltip.add((Component)Component.m_237113_((String)Localization.translate("iu.beer.recipe.info")));
            tooltip.add((Component)Component.m_237113_((String)Localization.translate("iu.beer.recipe")));
            tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.beer.recipe1") + " " + beerVariety.getRatioOfComponents().get(0).m_14419_())));
            tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.beer.recipe2") + " " + beerVariety.getRatioOfComponents().get(0).m_14418_())));
            tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.beer.recipe3") + " " + waterVariety.getAmount().get(0))));
            tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.beer.recipe4") + " " + new Timer((int)(timeVariety.getTime() * 60.0 * 60.0)).getDisplay())));
            tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.beer.recipe5") + " " + waterVariety.name() + " " + beerVariety.name() + " " + timeVariety.name())));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound == null || !nbtTagCompound.m_128441_("beer")) {
            return Component.m_237113_((String)Localization.translate(this.m_5671_(stack).replace("item.", "iu.") + ".name"));
        }
        EnumWaterVariety waterVariety = EnumWaterVariety.values()[nbtTagCompound.m_128445_("waterVariety")];
        EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbtTagCompound.m_128445_("timeVariety")];
        EnumBeerVariety beerVariety = EnumBeerVariety.values()[nbtTagCompound.m_128445_("beerVariety")];
        return Component.m_237113_((String)(waterVariety.name() + " " + beerVariety.name() + " " + timeVariety.name()));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return ModUtils.nbt(stack).m_128441_("beer") ? UseAnim.DRINK : UseAnim.NONE;
    }

    @Override
    public String[] properties() {
        return new String[]{"time_variety"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        boolean hasKey = nbt.m_128441_("beer");
        if (!hasKey) {
            return 0.0f;
        }
        EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbt.m_128445_("timeVariety")];
        return timeVariety.ordinal() + 1;
    }
}

