/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.items.relocator.Point;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PacketUpdateRelocator
implements IPacket {
    public PacketUpdateRelocator() {
    }

    public PacketUpdateRelocator(Player player) {
        if (player instanceof ServerPlayer) {
            List points;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
            Map<ResourceKey<Level>, Map<UUID, List<Point>>> map = RelocatorNetwork.instance.getWorldDataPoints();
            HashMap<ResourceKey<Level>, List> playerData = new HashMap<ResourceKey<Level>, List>();
            for (Map.Entry<ResourceKey<Level>, Map<UUID, List<Point>>> entry : RelocatorNetwork.instance.getWorldDataPoints().entrySet()) {
                points = entry.getValue().get(serverPlayer.m_20148_());
                if (points == null) continue;
                playerData.put(entry.getKey(), points);
            }
            customPacketBuffer.writeByte(this.getId());
            customPacketBuffer.writeInt(playerData.size());
            for (Map.Entry<Object, Map<UUID, List<Point>>> entry : playerData.entrySet()) {
                customPacketBuffer.m_236858_((ResourceKey)entry.getKey());
                points = (List)((Object)entry.getValue());
                customPacketBuffer.writeInt(points.size());
                for (Point point : points) {
                    point.writeToBuffer(customPacketBuffer);
                }
            }
            IUCore.network.getServer().sendPacket(customPacketBuffer, serverPlayer);
        }
    }

    @Override
    public byte getId() {
        return 55;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        int worldsCount = customPacketBuffer.readInt();
        for (int i = 0; i < worldsCount; ++i) {
            ResourceKey levelKey = customPacketBuffer.m_236801_(Registry.f_122819_);
            int pointsCount = customPacketBuffer.readInt();
            ArrayList<Point> points = new ArrayList<Point>();
            for (int j = 0; j < pointsCount; ++j) {
                points.add(new Point(customPacketBuffer));
            }
            RelocatorNetwork.instance.addPoints(entityPlayer, (ResourceKey<Level>)levelKey, points);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

