/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.proxy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.inv.IStackInventory;
import com.denfop.api.inv.ITileInventory;
import com.denfop.api.item.IMultiBlockItem;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.blocks.mechanism.BlockCreativeBlocks;
import com.denfop.container.ContainerBase;
import com.denfop.effects.BreakingItemParticle;
import com.denfop.effects.EffectsRegister;
import com.denfop.effects.SteamAshParticle;
import com.denfop.events.ElectricItemTooltipHandler;
import com.denfop.events.TickHandler;
import com.denfop.events.client.EventAutoQuests;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.items.IProperties;
import com.denfop.items.upgradekit.ItemUpgradeMachinesKit;
import com.denfop.mixin.access.RenderChunkRegionAccessor;
import com.denfop.proxy.CommonProxy;
import com.denfop.register.Register;
import com.denfop.render.TileEntityRenderGasChamber;
import com.denfop.render.advoilrefiner.TileEntityAdvOilRefinerRender;
import com.denfop.render.anvil.RenderItemAnvil;
import com.denfop.render.base.DynamicFluidContainerModel;
import com.denfop.render.base.NuclearBombRenderer;
import com.denfop.render.base.RenderCoreProcess;
import com.denfop.render.base.SmallBeeRenderer;
import com.denfop.render.compressor.TileEntityRenderCompressor;
import com.denfop.render.dryer.TileEntityRenderDryer;
import com.denfop.render.fluidheater.TileEntityRenderFluidHeater;
import com.denfop.render.fluidintegrator.PrimalFluidIntegratorRenderer;
import com.denfop.render.imp_refiner.TileEntityImpOilRefinerRender;
import com.denfop.render.macerator.TileEntityRenderMacerator;
import com.denfop.render.oilquarry.QuarryOilRenderer;
import com.denfop.render.oilrefiner.TileEntityOilRefinerRender;
import com.denfop.render.panel.TileEntityMiniPanelRender;
import com.denfop.render.panel.TileEntitySolarPanelRender;
import com.denfop.render.primal_laser_polisher.PrimalLaserPolisherRender;
import com.denfop.render.primal_silicon_crystal_handler.PrimalSiliconCrystalHandlerRender;
import com.denfop.render.pump.TileEntityRenderPump;
import com.denfop.render.rolling.RenderItemRolling;
import com.denfop.render.sintezator.TileEntitySintezatorRenderer;
import com.denfop.render.squeezer.TileEntityRenderSqueezer;
import com.denfop.render.steam.SteamTankBoilerRenderer;
import com.denfop.render.steam.TileEntityRenderSteamStorage;
import com.denfop.render.steam_turbine_tank.TileEntityRenderSteamTurbineTank;
import com.denfop.render.streak.EventSpectralSuitEffect;
import com.denfop.render.stronganvil.RenderItemStrongAnvil;
import com.denfop.render.tank.TileEntityTankRender;
import com.denfop.render.transport.TileEntityCableRenderer;
import com.denfop.render.water.WaterGeneratorRenderer;
import com.denfop.render.windgenerator.KineticGeneratorRenderer;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.tiles.transport.tiles.TileEntityMultiCable;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ClientProxy
extends CommonProxy {
    private final Minecraft mc = Minecraft.m_91087_();
    List<IProperties> propertiesList = new ArrayList<IProperties>();

    public ClientProxy() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onRegisterAdditionalModels);
        modEventBus.addListener(this::registerParticleFactories);
        modEventBus.addListener(this::registerBlockColor);
        modEventBus.addListener(this::registerItemColor);
        modEventBus.addListener(this::registerRenderers);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::registerKeys);
        modEventBus.addListener(this::onRegisterGeometryLoaders);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventAutoQuests());
        new GlobalRenderManager();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("fluid_container", (IGeometryLoader)DynamicFluidContainerModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)IUItem.entity_nuclear_bomb.get(), NuclearBombRenderer::new);
        event.registerEntityRenderer((EntityType)IUItem.entity_bee.get(), SmallBeeRenderer::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onServerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (++ItemUpgradeMachinesKit.tick % 40 == 0) {
                for (int i = 0; i < ItemUpgradeMachinesKit.inform.length; ++i) {
                    List<ItemStack> list1 = IUItem.map_upgrades.get(i);
                    if (list1 == null) continue;
                    int n = i;
                    int n2 = ItemUpgradeMachinesKit.inform[n] + 1;
                    ItemUpgradeMachinesKit.inform[n] = n2;
                    ItemUpgradeMachinesKit.inform[i] = n2 % list1.size();
                }
            }
            if (++ListInformationUtils.tick % 40 == 0) {
                if (ListInformationUtils.mechanism_info.size() > 0) {
                    ListInformationUtils.index = (ListInformationUtils.index + 1) % ListInformationUtils.mechanism_info.size();
                }
                if (ListInformationUtils.mechanism_info1.size() > 0) {
                    ListInformationUtils.index1 = (ListInformationUtils.index1 + 1) % ListInformationUtils.mechanism_info1.values().size();
                }
                if (ListInformationUtils.mechanism_info2.size() > 0) {
                    ListInformationUtils.index2 = (ListInformationUtils.index2 + 1) % ListInformationUtils.mechanism_info2.size();
                }
            }
        }
    }

    @SubscribeEvent
    public void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)EffectsRegister.STEAM_ASH.get(), SteamAshParticle.Factory::new);
        event.register((ParticleType)EffectsRegister.ANVIL.get(), BreakingItemParticle.AnvilProvider::new);
    }

    @SubscribeEvent
    public void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> {
            Level level = null;
            if (world instanceof RenderChunkRegion) {
                level = ((RenderChunkRegionAccessor)world).getLevel();
            }
            if (world instanceof Level) {
                level = (Level)world;
            }
            if (level == null) {
                return ModUtils.convertRGBcolorToInt(10, 96, 8);
            }
            Holder biome = level.m_204166_(pos);
            if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                return ModUtils.convertRGBcolorToInt(105, 122, 93);
            }
            if (biome.m_203656_(BiomeTags.f_207610_)) {
                return ModUtils.convertRGBcolorToInt(12, 82, 32);
            }
            return ModUtils.convertRGBcolorToInt(10, 96, 8);
        }, new Block[]{(Block)IUItem.leaves.getBlock().get()});
    }

    @SubscribeEvent
    public void registerItemColor(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> ModUtils.convertRGBcolorToInt(10, 96, 8), new ItemLike[]{(ItemLike)IUItem.leaves.getBlock().get()});
        event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{IUItem.fluidCell.getItem()});
    }

    @Override
    public Level getWorld(ResourceKey<Level> dim) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null && dim != null ? server.m_129880_(dim) : (Minecraft.m_91087_() == null ? null : Minecraft.m_91087_().f_91073_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeys(RegisterKeyMappingsEvent event) {
        IUCore.keyboard.register(event);
    }

    @Override
    public void preInit() {
        super.preInit();
        MenuScreens.m_96206_((MenuType)((MenuType)Register.containerBase.get()), (menu, inventory, p_96217_) -> ((ITileInventory)menu.base.getParent()).getGui(inventory.f_35978_, (ContainerBase<? extends IAdvInventory>)menu));
        MenuScreens.m_96206_((MenuType)((MenuType)Register.inventory_container.get()), (menu, inventory, p_96217_) -> {
            IStackInventory stackInventory = (IStackInventory)menu.base.getParent();
            return stackInventory.getGui(inventory.f_35978_, (ContainerBase<?>)menu);
        });
        BlockEntityRenderers.m_173590_(IUItem.anvil.getBlock(0).getValue().getBlockType(), RenderItemAnvil::new);
        BlockEntityRenderers.m_173590_(IUItem.primalFluidHeater.getBlock(0).getValue().getBlockType(), TileEntityRenderFluidHeater::new);
        BlockEntityRenderers.m_173590_(IUItem.gasChamber.getBlock(0).getValue().getBlockType(), TileEntityRenderGasChamber::new);
        BlockEntityRenderers.m_173590_(IUItem.squeezer.getBlock(0).getValue().getBlockType(), TileEntityRenderSqueezer::new);
        BlockEntityRenderers.m_173590_(IUItem.primalPolisher.getBlock(0).getValue().getBlockType(), PrimalLaserPolisherRender::new);
        BlockEntityRenderers.m_173590_(IUItem.tank.getBlock(0).getValue().getBlockType(), TileEntityTankRender::new);
        BlockEntityRenderers.m_173590_(IUItem.tank.getBlock(1).getValue().getBlockType(), TileEntityTankRender::new);
        BlockEntityRenderers.m_173590_(IUItem.tank.getBlock(2).getValue().getBlockType(), TileEntityTankRender::new);
        BlockEntityRenderers.m_173590_(IUItem.tank.getBlock(3).getValue().getBlockType(), TileEntityTankRender::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.oak_tank).getValue().getBlockType(), TileEntityTankRender::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.steel_tank).getValue().getBlockType(), TileEntityTankRender::new);
        BlockEntityRenderers.m_173590_(IUItem.dryer.getBlock().getValue().getBlockType(), TileEntityRenderDryer::new);
        BlockEntityRenderers.m_173590_(IUItem.primalSiliconCrystal.getBlock().getValue().getBlockType(), PrimalSiliconCrystalHandlerRender::new);
        BlockEntityRenderers.m_173590_(IUItem.blockmolecular.getBlock().getValue().getBlockType(), RenderCoreProcess::new);
        BlockEntityRenderers.m_173590_(IUItem.blockCompressor.getBlock().getValue().getBlockType(), TileEntityRenderCompressor::new);
        BlockEntityRenderers.m_173590_(IUItem.oilquarry.getBlock().getValue().getBlockType(), QuarryOilRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.blockdoublemolecular.getBlock().getValue().getBlockType(), RenderCoreProcess::new);
        TileEntityMultiCable.list.forEach(cable -> BlockEntityRenderers.m_173590_((BlockEntityType)cable, TileEntityCableRenderer::new));
        TileSolarPanel.list.forEach(panel -> BlockEntityRenderers.m_173590_((BlockEntityType)panel, TileEntitySolarPanelRender::new));
        BlockEntityRenderers.m_173590_(IUItem.fluidIntegrator.getBlock().getValue().getBlockType(), PrimalFluidIntegratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.oilrefiner.getBlock().getValue().getBlockType(), TileEntityOilRefinerRender::new);
        BlockEntityRenderers.m_173590_(IUItem.oiladvrefiner.getBlock().getValue().getBlockType(), TileEntityAdvOilRefinerRender::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.imp_refiner).getValue().getBlockType(), TileEntityImpOilRefinerRender::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.rolling_machine).getValue().getBlockType(), RenderItemRolling::new);
        BlockEntityRenderers.m_173590_(IUItem.blockMacerator.getBlock().getValue().getBlockType(), TileEntityRenderMacerator::new);
        BlockEntityRenderers.m_173590_(IUItem.primal_pump.getBlock().getValue().getBlockType(), TileEntityRenderPump::new);
        BlockEntityRenderers.m_173590_(IUItem.strong_anvil.getBlock(0).getValue().getBlockType(), RenderItemStrongAnvil::new);
        BlockEntityRenderers.m_173590_(IUItem.blocksintezator.getBlock(0).getValue().getBlockType(), TileEntitySintezatorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.steam_boiler.getBlock(2).getValue().getBlockType(), SteamTankBoilerRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.minipanel).getValue().getBlockType(), TileEntityMiniPanelRender::new);
        BlockEntityRenderers.m_173590_(IUItem.steam_turbine.getBlock(13).getValue().getBlockType(), TileEntityRenderSteamTurbineTank::new);
        BlockEntityRenderers.m_173590_(IUItem.steam_turbine.getBlock(14).getValue().getBlockType(), TileEntityRenderSteamTurbineTank::new);
        BlockEntityRenderers.m_173590_(IUItem.steam_turbine.getBlock(15).getValue().getBlockType(), TileEntityRenderSteamTurbineTank::new);
        BlockEntityRenderers.m_173590_(IUItem.steam_turbine.getBlock(16).getValue().getBlockType(), TileEntityRenderSteamTurbineTank::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.steam_storage).getValue().getBlockType(), TileEntityRenderSteamStorage::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.crystallize).getValue().getBlockType(), RenderCoreProcess::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.quantum_transformer).getValue().getBlockType(), RenderCoreProcess::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.simple_wind_generator).getValue().getBlockType(), KineticGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.adv_wind_generator).getValue().getBlockType(), KineticGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.imp_wind_generator).getValue().getBlockType(), KineticGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.per_wind_generator).getValue().getBlockType(), KineticGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.simple_water_generator).getValue().getBlockType(), WaterGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.adv_water_generator).getValue().getBlockType(), WaterGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.imp_water_generator).getValue().getBlockType(), WaterGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.basemachine2.getBlock(BlockBaseMachine3.per_water_generator).getValue().getBlockType(), WaterGeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(IUItem.creativeBlock.getBlock(BlockCreativeBlocks.creative_steam_storage).getValue().getBlockType(), TileEntityRenderSteamStorage::new);
        BlockEntityRenderers.m_173590_(IUItem.creativeBlock.getBlock(BlockCreativeBlocks.creative_tank_storage).getValue().getBlockType(), TileEntityTankRender::new);
        MinecraftForge.EVENT_BUS.register((Object)new EventSpectralSuitEffect());
        EnumMultiMachine.write();
        new TickHandler();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onRegisterAdditionalModels(ModelEvent.BakingCompleted event) {
        for (RegistryObject registryObject : Register.ITEMS.getEntries()) {
            Item item = (Item)registryObject.get();
            if (!(item instanceof ItemBlockCore)) continue;
            ItemBlockCore blockCore = (ItemBlockCore)item;
            ModelResourceLocation model = new ModelResourceLocation(blockCore.getRegistryName(), "inventory");
            ModelResourceLocation modelBlock = BlockModelShaper.m_110895_((BlockState)blockCore.m_40614_().m_49966_());
            if (blockCore instanceof ItemBlockTileEntity) {
                ItemBlockTileEntity blockTileEntity = (ItemBlockTileEntity)blockCore;
                if (blockTileEntity.getElement() instanceof IMultiBlockItem) {
                    IMultiBlockItem blockItem = (IMultiBlockItem)blockTileEntity.getElement();
                    if (blockItem.hasUniqueRender(null)) continue;
                    event.getModels().replace(model, (BakedModel)event.getModels().get(modelBlock));
                    continue;
                }
                event.getModels().replace(model, (BakedModel)event.getModels().get(modelBlock));
                continue;
            }
            event.getModels().replace(model, (BakedModel)event.getModels().get(modelBlock));
        }
    }

    @Override
    public void messagePlayer(Player player, String message) {
        if (player != null) {
            player.m_5661_((Component)Component.m_237115_((String)message), false);
        }
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> IUCore.proxy.getPropertiesList().forEach(properties -> {
            for (String property : properties.properties()) {
                ItemProperties.register((Item)((Item)properties), (ResourceLocation)new ResourceLocation(property), (p_174676_, p_174677_, p_174678_, p_174679_) -> properties.getItemProperty(p_174676_, p_174677_, p_174678_, p_174679_, property));
            }
        }));
        new ElectricItemTooltipHandler();
    }

    @Override
    public List<IProperties> getPropertiesList() {
        return this.propertiesList;
    }

    @Override
    public void addProperties(IProperties properties) {
        if (!this.propertiesList.contains(properties)) {
            this.propertiesList.add(properties);
        }
    }

    @Override
    public Player getPlayerInstance() {
        return this.mc.f_91074_;
    }
}

