/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.Satellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.SatelliteRecipe;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SatelliteSerializer
implements RecipeSerializer<SatelliteRecipe> {
    public static final SatelliteSerializer INSTANCE = new SatelliteSerializer();

    public SatelliteRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        ISystem system = SpaceNet.instance.getSystem().stream().filter(systems -> systems.getName().equals(json.get("system").getAsString().toLowerCase())).toList().get(0);
        ResourceLocation texture = new ResourceLocation(json.get("texture").getAsString() + ".png");
        EnumLevels level = EnumLevels.valueOf(json.get("level").getAsString().toUpperCase());
        IPlanet planet = (IPlanet)SpaceNet.instance.getBodyFromName(json.get("planet").getAsString());
        int temperature = json.get("temperature").getAsInt();
        boolean pressure = json.get("pressure").getAsBoolean();
        double distance = json.get("distance").getAsDouble();
        EnumType type = EnumType.valueOf(json.get("type").getAsString().toUpperCase());
        boolean oxygen = json.get("oxygen").getAsBoolean();
        boolean colonies = json.get("colonies").getAsBoolean();
        int angle = json.get("angle").getAsInt();
        double time = json.get("time").getAsDouble();
        double size = json.get("size").getAsDouble();
        double rotation = json.get("rotation").getAsDouble();
        SpaceInit.regSatellite.add(() -> new Satellite(name, system, texture, level, planet, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
        return new SatelliteRecipe(id, "", Collections.emptyList(), "");
    }

    public SatelliteRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new SatelliteRecipe(id, "", new ArrayList<ItemStack>(), "");
    }

    public void toNetwork(FriendlyByteBuf buf, SatelliteRecipe recipe) {
    }
}

