/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.register;

import com.denfop.blocks.BlockFluidIU;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.blocks.fluid.IUFluidType;
import com.denfop.items.ItemBucket;
import com.denfop.mixin.invoker.MaterialInvoker;
import com.denfop.register.Register;
import java.util.function.Supplier;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidHandler {
    public final RegistryObject<IUFluid> source;
    public final RegistryObject<IUFluid> flowing;
    private final IUFluidType fluidType;
    private final RegistryObject<LiquidBlock> liquedBlock;
    private ForgeFlowingFluid.Properties properties;

    public FluidHandler(IUFluidType fluidType, FluidName fluidName) {
        RegistryObject blockRegistryObject;
        this.fluidType = fluidType;
        this.source = Register.FLUIDS.register(fluidName.getName().toLowerCase(), () -> new IUFluid(this.properties, true));
        this.flowing = Register.FLUIDS.register(fluidName.getName().toLowerCase() + "_flowing", () -> new IUFluid(this.properties, false));
        Material steam = ((MaterialInvoker)new Material.Builder(MaterialColor.f_76419_).m_76350_()).getNotSolidBlocking().m_76356_().m_76359_();
        RegistryObject bucket = Register.ITEMS.register("bucket/" + fluidName.name().toLowerCase().replace("fluid", ""), () -> new ItemBucket((Supplier<? extends Fluid>)this.source, fluidName));
        this.liquedBlock = blockRegistryObject = Register.BLOCKS.register("fluid/" + fluidName.name().toLowerCase(), () -> new BlockFluidIU((Supplier<? extends FlowingFluid>)this.source, BlockBehaviour.Properties.m_60939_((Material)steam)));
        this.properties = new ForgeFlowingFluid.Properties(() -> this.fluidType, this.source, this.flowing).slopeFindDistance(2).levelDecreasePerBlock(2).bucket((Supplier)bucket).block((Supplier)blockRegistryObject);
    }

    public RegistryObject<LiquidBlock> getLiquedBlock() {
        return this.liquedBlock;
    }

    public IUFluidType getFluidType() {
        return this.fluidType;
    }

    public ForgeFlowingFluid.Properties getProperties() {
        return this.properties;
    }

    public void setProperties(ForgeFlowingFluid.Properties properties) {
        this.properties = properties;
    }
}

