/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicFluidContainerModel
implements IUnbakedGeometry<DynamicFluidContainerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Transformation FLUID_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.002f), Quaternion.f_80118_);
    private static final Transformation COVER_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.004f), Quaternion.f_80118_);
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;
    private final boolean deprecatedLoader;
    private final Map<String, String> deprecationWarnings;

    public DynamicFluidContainerModel(Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this(fluid, flipGas, coverIsMask, applyFluidLuminosity, false, Map.of());
    }

    private DynamicFluidContainerModel(Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity, boolean deprecatedLoader, Map<String, String> deprecationWarnings) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
        this.deprecatedLoader = deprecatedLoader;
        this.deprecationWarnings = deprecationWarnings;
    }

    public static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(RenderType.m_110466_(), unlit ? ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public DynamicFluidContainerModel withFluid(Fluid newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity, false, Map.of());
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        List quads;
        List unbaked;
        SimpleModelState transformedState;
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        if (this.deprecatedLoader) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated loader \"forge:bucket\" instead of \"forge:fluid_container\". This loader will be removed in 1.20.");
        }
        for (Map.Entry<String, String> entry : this.deprecationWarnings.entrySet()) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"" + entry.getKey() + "\" field in its fluid container model instead of \"" + entry.getValue() + "\". This field will be removed in 1.20.");
        }
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid") ? context.getMaterial("fluid") : null;
        Material coverLocation = context.hasMaterial("cover") ? context.getMaterial("cover") : null;
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != Fluids.f_76191_ && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(new Transformation(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, bakery, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes(false);
        if (baseLocation != null && baseSprite != null) {
            List unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
            List quads2 = UnbakedGeometryHelper.bakeElements((List)unbaked2, $ -> baseSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(FLUID_TRANSFORM), modelState.m_7538_());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)templateSprite);
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes(emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite2 = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(COVER_TRANSFORM), modelState.m_7538_());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (TextureAtlasSprite)coverSprite);
                quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
                modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        if (context.hasMaterial("particle")) {
            textures.add(context.getMaterial("particle"));
        }
        if (context.hasMaterial("base")) {
            textures.add(context.getMaterial("base"));
        }
        if (context.hasMaterial("fluid")) {
            textures.add(context.getMaterial("fluid"));
        }
        if (context.hasMaterial("cover")) {
            textures.add(context.getMaterial("cover"));
        }
        return textures;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IGeometryBakingContext owner;
        private final DynamicFluidContainerModel parent;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBakery bakery, IGeometryBakingContext owner, DynamicFluidContainerModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.m_173464_(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            IFluidHandlerItem fs = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)stack.m_41720_().initCapabilities(stack, stack.m_41783_())));
            @NotNull FluidStack fluidStack = fs.getFluidInTank(0);
            if (fluidStack.getFluid() == Fluids.f_76191_) {
                return originalModel;
            }
            Fluid fluid = fluidStack.getFluid();
            String name = ForgeRegistries.FLUIDS.getKey((Object)fluid).toString();
            if (!this.cache.containsKey(name)) {
                DynamicFluidContainerModel unbaked = this.parent.withFluid(fluid);
                BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("forge:bucket_override"));
                this.cache.put(name, bakedModel);
                return bakedModel;
            }
            return this.cache.get(name);
        }
    }

    public static class Colors
    implements ItemColor {
        public int m_92671_(@NotNull ItemStack stack, int tintIndex) {
            if (tintIndex != 1) {
                return -1;
            }
            IFluidHandlerItem fs = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)stack.m_41720_().initCapabilities(stack, stack.m_41783_())));
            @NotNull FluidStack fluidStack = fs.getFluidInTank(0);
            return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        }
    }

    public static final class Loader
    implements IGeometryLoader<DynamicFluidContainerModel> {
        public static final Loader INSTANCE = new Loader(false);
        private final boolean deprecated;

        private Loader(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public DynamicFluidContainerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            ResourceLocation fluidName = new ResourceLocation("minecraft:empty");
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
            boolean flip = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            ImmutableMap.Builder deprecationWarningsBuilder = ImmutableMap.builder();
            if (jsonObject.has("flipGas")) {
                flip = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"flipGas");
                deprecationWarningsBuilder.put((Object)"flipGas", (Object)"flip_gas");
            }
            if (jsonObject.has("coverIsMask")) {
                coverIsMask = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"coverIsMask");
                deprecationWarningsBuilder.put((Object)"coverIsMask", (Object)"cover_is_mask");
            }
            if (jsonObject.has("applyFluidLuminosity")) {
                applyFluidLuminosity = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"applyFluidLuminosity");
                deprecationWarningsBuilder.put((Object)"applyFluidLuminosity", (Object)"apply_fluid_luminosity");
            }
            return new DynamicFluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity, this.deprecated, (Map<String, String>)deprecationWarningsBuilder.build());
        }
    }
}

