/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerElectrolyzer;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiElectrolyzer;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotElectrolyzer;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ParticleUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileElectrolyzer
extends TileElectricMachine
implements IManufacturerBlock,
IUpgradableBlock,
IHasRecipe {
    public final InvSlotElectrolyzer cathodeslot;
    public final InvSlotElectrolyzer anodeslot;
    public final Fluids.InternalFluidTank fluidTank2;
    public final Fluids.InternalFluidTank fluidTank1;
    public final Fluids.InternalFluidTank fluidTank3;
    public final FluidHandlerRecipe fluid_handler;
    public final InvSlotFluidByList fluidSlot1;
    public final InvSlotFluidByList fluidSlot2;
    public final InvSlotFluidByList fluidSlot3;
    public final InvSlotUpgrade upgradeSlot;
    private final Fluids fluids = this.addComponent(new Fluids(this));
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private int levelMech;

    public TileElectrolyzer(BlockPos pos, BlockState state) {
        super(24000.0, 1, 2, BlockBaseMachine2.electrolyzer_iu, pos, state);
        this.fluidTank1 = this.fluids.addTank("fluidTank1", 12000, InvSlot.TypeItemSlot.INPUT);
        this.fluidTank2 = this.fluids.addTank("fluidTank2", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluidTank3 = this.fluids.addTank("fluidTank3", 12000, InvSlot.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("electrolyzer", this.fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.fluidTank3.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(1)));
        this.fluidSlot1 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getFluids(0));
        this.fluidSlot2 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot3 = new InvSlotFluidByList((TileEntityInventory)this, 1, this.fluid_handler.getOutputFluids(1));
        this.fluidSlot2.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.fluidSlot3.setTypeFluidSlot(InvSlotFluid.TypeFluidSlot.OUTPUT);
        this.cathodeslot = new InvSlotElectrolyzer(this, 1);
        this.anodeslot = new InvSlotElectrolyzer(this, 0);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        CompoundTag compoundTag = super.writeToNBT(nbttagcompound);
        compoundTag.m_128405_("levelMech", this.levelMech);
        return compoundTag;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.levelMech = nbttagcompound.m_128451_("levelMech");
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void init() {
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 4)), Arrays.asList(new FluidStack((Fluid)FluidName.fluidhyd.getInstance().get(), 2), new FluidStack((Fluid)FluidName.fluidoxy.getInstance().get(), 1))));
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidfluorhyd.getInstance().get(), 5)), Arrays.asList(new FluidStack((Fluid)FluidName.fluidhyd.getInstance().get(), 3), new FluidStack((Fluid)FluidName.fluidfluor.getInstance().get(), 1))));
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidhydrogenbromide.getInstance().get(), 5)), Arrays.asList(new FluidStack((Fluid)FluidName.fluidhyd.getInstance().get(), 3), new FluidStack((Fluid)FluidName.fluidbromine.getInstance().get(), 1))));
        Recipes.recipes.getRecipeFluid().addRecipe("electrolyzer", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidwastesulfuricacid.getInstance().get(), 2)), Arrays.asList(new FluidStack((Fluid)FluidName.fluidsulfurtrioxide.getInstance().get(), 1), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.f_76193_, 1))));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.electrolyzer_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    public ContainerElectrolyzer getGuiContainer(Player entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.setOverclockRates();
            this.fluid_handler.load();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiElectrolyzer((ContainerElectrolyzer)isAdmin);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "25" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.f_58857_.m_46467_() % 5L == 0L) {
            ParticleUtils.spawnElectrolyzerParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
        }
        MutableObject output1 = new MutableObject();
        boolean check = false;
        if (this.fluidTank1.getFluidAmount() + 1000 <= this.fluidTank1.getCapacity() && this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank2.getFluidAmount() - 1000 >= 0 && this.fluidSlot2.transferFromTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot2.transferFromTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank3.getFluidAmount() - 1000 >= 0 && this.fluidSlot3.transferFromTank((IFluidTank)this.fluidTank3, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot3.transferFromTank((IFluidTank)this.fluidTank3, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (check || this.fluid_handler.output() == null && this.fluidTank1.getFluidAmount() >= 1) {
            this.fluid_handler.getOutput();
        } else if (this.fluid_handler.output() != null && !this.fluid_handler.checkFluids()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.cathodeslot.isEmpty() || this.anodeslot.isEmpty()) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
        } else {
            boolean drain = false;
            boolean drain1 = false;
            if (this.fluid_handler.output() != null && this.fluid_handler.canOperate() && this.fluid_handler.canFillFluid() && this.energy.canUseEnergy(25.0)) {
                FluidStack fluidStack;
                BaseFluidMachineRecipe output = this.fluid_handler.output();
                FluidStack inputFluidStack = output.input.getInputs().get(0);
                int size = this.getFluidTank(0).getFluidAmount() / inputFluidStack.getAmount();
                size = Math.min(this.levelMech + 1, size);
                int cap = this.getFluidTank(1).getCapacity() - this.getFluidTank(1).getFluidAmount();
                FluidStack outputFluidStack = output.output_fluid.get(0);
                cap /= outputFluidStack.getAmount();
                cap = Math.min(cap, size);
                int cap1 = this.getFluidTank(2).getCapacity() - this.getFluidTank(2).getFluidAmount();
                FluidStack outputFluidStack1 = output.output_fluid.get(1);
                size = Math.min(Math.min(size, cap1 /= outputFluidStack1.getAmount()), cap);
                if (this.getFluidTank(1).getCapacity() - this.getFluidTank(1).getFluidAmount() >= outputFluidStack.getAmount()) {
                    fluidStack = new FluidStack(outputFluidStack.getFluid(), outputFluidStack.getAmount() * size);
                    this.fluidTank2.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    drain = true;
                }
                if (this.getFluidTank(2).getCapacity() - this.getFluidTank(2).getFluidAmount() >= outputFluidStack1.getAmount()) {
                    fluidStack = new FluidStack(outputFluidStack1.getFluid(), outputFluidStack1.getAmount() * size);
                    this.fluidTank3.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    drain1 = true;
                }
                if (drain || drain1) {
                    int drains = size * inputFluidStack.getAmount();
                    this.getFluidTank(0).drain(drains, IFluidHandler.FluidAction.EXECUTE);
                    if (!this.getActive()) {
                        this.setActive(true);
                        this.initiate(0);
                    }
                    this.energy.useEnergy(25.0);
                    this.setActive(true);
                    ItemStack cathode = this.cathodeslot.get(0);
                    ItemStack anode = this.anodeslot.get(0);
                    if (cathode.m_41773_() < cathode.m_41776_()) {
                        DamageHandler.damage(cathode, 1, null);
                    }
                    if (anode.m_41773_() < anode.m_41776_()) {
                        DamageHandler.damage(anode, 1, null);
                    }
                    if (cathode.m_41773_() == cathode.m_41776_()) {
                        this.cathodeslot.consume(1);
                    }
                    if (anode.m_41773_() == anode.m_41776_()) {
                        this.anodeslot.consume(1);
                    }
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(1);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(24000));
    }

    public FluidTank getFluidTank(int i) {
        switch (i) {
            case 1: {
                return this.fluidTank2;
            }
            case 2: {
                return this.fluidTank3;
            }
        }
        return this.fluidTank1;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        if (this.levelMech < 10) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41720_().equals((Object)IUItem.upgrade_speed_creation.getItem())) {
                return super.onActivated(player, hand, side, hitX);
            }
            stack.m_41774_(1);
            ++this.levelMech;
            return true;
        }
        return super.onActivated(player, hand, side, hitX);
    }

    @Override
    public int getLevelMechanism() {
        return this.levelMech;
    }

    @Override
    public void setLevelMech(int levelMech) {
        this.levelMech = levelMech;
    }

    @Override
    public void removeLevel(int level) {
        this.levelMech -= level;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput, UpgradableProperty.ItemInput);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.electrolyzer.getSoundEvent();
    }
}

