/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.ElectricItem;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerFisher;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiFisher;
import com.denfop.invslot.InvSlotFisher;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileFisher
extends TileElectricMachine
implements IUpgradableBlock,
IManufacturerBlock {
    public final int energyconsume;
    public final InvSlotFisher inputslot = new InvSlotFisher(this);
    private final SoilPollutionComponent pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
    private final AirPollutionComponent pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    public int progress = 0;
    private boolean checkwater = false;
    private int level = 1;
    private FakePlayerSpawner player;
    private FishingHook energyFishHook;
    private LootContext.Builder lootcontext$builder;
    private LootTable table;
    private LootPool listPool;

    public TileFisher(BlockPos pos, BlockState state) {
        super(10000.0, 14, 9, BlockBaseMachine2.fisher, pos, state);
        this.energyconsume = 100;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.fisher;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public int getLevelMechanism() {
        return this.level;
    }

    @Override
    public void setLevelMech(int levelMech) {
        this.level = levelMech;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.energyconsume + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    private boolean checkwater() {
        int x1 = this.pos.m_123341_();
        int y1 = this.pos.m_123342_() - 2;
        int z1 = this.pos.m_123343_();
        for (int i = x1 - 1; i <= x1 + 1; ++i) {
            for (int j = z1 - 1; j <= z1 + 1; ++j) {
                for (int k = y1 - 1; k <= y1 + 1; ++k) {
                    if (this.getWorld().m_8055_(new BlockPos(i, k, j)).m_60734_() == Blocks.f_49990_) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.checkwater = this.checkwater();
        this.player = new FakePlayerSpawner(this.getWorld());
        this.energyFishHook = new FishingHook((Player)this.player, this.getWorld(), 0, 0);
        this.lootcontext$builder = new LootContext.Builder((ServerLevel)this.getWorld());
        this.table = this.getWorld().m_7654_().m_129898_().m_79217_(BuiltInLootTables.f_78720_);
        this.listPool = this.table.getPool("main");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.m_58904_().m_46467_() % 5L == 0L) {
            ParticleUtils.spawnFishingMachineParticles(this.m_58904_(), this.pos, this.m_58904_().f_46441_);
        }
        if (this.getWorld().m_46467_() % 100L == 0L) {
            this.checkwater = this.checkwater();
        }
        if (this.checkwater && !this.inputslot.isEmpty()) {
            boolean need;
            if (this.inputslot.get(0).m_41720_() instanceof IEnergyItem && !(need = ElectricItem.manager.canUse(this.inputslot.get(0), 100.0))) {
                return;
            }
            if (this.progress < 100) {
                if (this.energy.getEnergy() >= (double)this.energyconsume) {
                    if (!this.getActive()) {
                        this.setActive(true);
                    }
                    if (this.getActive() && this.progress == 0) {
                        this.initiate(0);
                    }
                    this.progress += this.level;
                } else if (this.getActive()) {
                    this.initiate(2);
                    this.setActive(false);
                }
            }
        } else if (this.getActive()) {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.checkwater && this.progress >= 100) {
            if (this.getActive()) {
                this.initiate(2);
            }
            if (!this.inputslot.isEmpty()) {
                ItemStack stack = this.inputslot.get(0);
                int j = EnchantmentHelper.m_44916_((ItemStack)stack);
                int k = EnchantmentHelper.m_44904_((ItemStack)stack);
                BlockPos pos1 = this.pos.m_7495_();
                this.lootcontext$builder.m_78963_((float)k).m_78972_(LootContextParams.f_81455_, (Object)this.energyFishHook).m_78972_(LootContextParams.f_81458_, (Object)this.player).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_()));
                ArrayList list = new ArrayList();
                this.listPool.m_79053_(list::add, this.lootcontext$builder.m_78975_(LootContextParamSets.f_81414_));
                for (ItemStack var1 : list) {
                    if (this.outputSlot.add(var1)) {
                        this.energy.useEnergy(this.energyconsume);
                    }
                    this.progress = 0;
                }
                int damage = stack.m_41776_() - stack.m_41773_();
                int m = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
                if (!(stack.m_41720_() instanceof IEnergyItem)) {
                    RandomSource rand;
                    if (this.inputslot.get(0).m_41773_() > -1 && (rand = this.getWorld().f_46441_).m_188503_(1 + m) == 0 && damage > -1) {
                        this.inputslot.get(0).m_41721_(this.inputslot.get(0).m_41773_() + 1);
                    }
                    if (this.inputslot.get(0).m_41773_() >= this.inputslot.get(0).m_41776_() && damage > -1) {
                        this.inputslot.consume(1);
                    }
                } else {
                    RandomSource rand = this.getWorld().f_46441_;
                    if (stack.m_41720_() instanceof IEnergyItem && rand.m_188503_(1 + m) == 0) {
                        ElectricItem.manager.use(stack, 100.0, null);
                    }
                }
            }
        }
        if (this.getActive() && this.getWorld().m_46467_() % 20L == 0L && !this.outputSlot.isEmpty()) {
            ModUtils.tick(this.outputSlot, this);
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 1) {
            ret.add(new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), this.level));
            this.level = 1;
        }
        return ret;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hit) {
        if (this.level < 10) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41720_().equals((Object)IUItem.upgrade_speed_creation.getItem())) {
                return super.onActivated(player, hand, side, hit);
            }
            stack.m_41774_(1);
            ++this.level;
            return true;
        }
        return super.onActivated(player, hand, side, hit);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128451_("progress");
        this.level = nbttagcompound.m_128451_("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("progress", this.progress);
        nbttagcompound.m_128405_("level", this.level);
        return nbttagcompound;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiFisher((ContainerFisher)isAdmin);
    }

    public ContainerFisher getGuiContainer(Player entityPlayer) {
        return new ContainerFisher(entityPlayer, this);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemInput);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.fisher.getSoundEvent();
    }
}

