/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSintezator;
import com.denfop.componets.WirelessComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSinSolarPanel;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSintezator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotSintezator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.EnumType;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TileSintezator
extends TileEntityInventory
implements IEnergySource,
IUpdatableTileEvent {
    public final InvSlotSintezator inputslot;
    public final InvSlotSintezator inputslotA;
    public final WirelessComponent wirelessComponent;
    public int machineTire1 = 0;
    public int solartype = 0;
    public double generating;
    public double genDay = 0.0;
    public double genNight = 0.0;
    public boolean sunIsUp = false;
    public boolean skyIsVisible = false;
    public short facing;
    public boolean noSunWorld;
    public int machineTire = 0;
    public boolean addedToEnergyNet;
    public double storage = 0.0;
    public double production;
    public double maxStorage = 0.0;
    public boolean rain = false;
    public double progress;
    public boolean wetBiome;
    public EnumType f_58855_;
    public TileSolarPanel.GenerationState generationState = TileSolarPanel.GenerationState.NONE;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    int hashCodeSource;
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    private int size = 0;
    private double pastEnergy;
    private double perenergy;
    private ChunkPos chunkPos;
    private long id;

    public TileSintezator(BlockPos pos, BlockState state) {
        super(BlockSintezator.sintezator, pos, state);
        this.facing = (short)2;
        this.inputslot = new InvSlotSintezator(this, "input", 0, 9);
        this.inputslotA = new InvSlotSintezator(this, "input1", 1, 4);
        this.f_58855_ = EnumType.DEFAULT;
        this.wirelessComponent = this.addComponent(new WirelessComponent(this));
        this.wirelessComponent.setEnergySource(this);
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.inputslot.wirelessmodule();
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.generationState = TileSolarPanel.GenerationState.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.generating = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genDay = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genNight = (Double)DecoderHandler.decode(customPacketBuffer);
            this.storage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.maxStorage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.production = (Double)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.machineTire = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.machineTire1 = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.f_58855_ = EnumType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.solartype = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.generationState);
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.generating);
            EncoderHandler.encode(packet, this.genDay);
            EncoderHandler.encode(packet, this.genNight);
            EncoderHandler.encode(packet, this.storage);
            EncoderHandler.encode(packet, this.maxStorage);
            EncoderHandler.encode(packet, this.production);
            EncoderHandler.encode(packet, this.rain);
            EncoderHandler.encode(packet, this.machineTire);
            EncoderHandler.encode(packet, this.machineTire1);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, (Object)this.f_58855_);
            EncoderHandler.encode(packet, this.solartype);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockSintezator.sintezator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blocksintezator.getBlock();
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    public void intialize() {
        this.noSunWorld = this.getWorld().m_6042_().f_223549_();
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.wetBiome = ((Biome)this.f_58857_.m_204166_(this.pos).m_203334_()).m_47548_() > 0.0f;
        this.noSunWorld = this.getWorld().m_6042_().f_223549_();
        this.rain = this.wetBiome && (this.f_58857_.m_46471_() || this.f_58857_.m_46470_());
        this.sunIsUp = this.f_58857_.m_46461_();
        this.skyIsVisible = true;
        if (this.sunIsUp) {
            this.generationState = !this.rain ? TileSolarPanel.GenerationState.DAY : TileSolarPanel.GenerationState.RAINDAY;
        }
        if (!this.sunIsUp) {
            this.generationState = !this.rain ? TileSolarPanel.GenerationState.NIGHT : TileSolarPanel.GenerationState.RAINNIGHT;
        }
        if (this.f_58857_.m_46472_() == Level.f_46430_) {
            this.generationState = TileSolarPanel.GenerationState.END;
        }
        if (this.f_58857_.m_46472_() == Level.f_46429_) {
            this.generationState = TileSolarPanel.GenerationState.NETHER;
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.m_128451_("solarType") != 0) {
            this.solartype = nbttagcompound.m_128451_("solarType");
        }
        if (nbttagcompound.m_128459_("storage") > 0.0) {
            this.storage = nbttagcompound.m_128459_("storage");
        }
        if (nbttagcompound.m_128459_("maxStorage") > 0.0) {
            this.genDay = nbttagcompound.m_128459_("genDay");
            this.genNight = nbttagcompound.m_128459_("genNight");
            this.maxStorage = nbttagcompound.m_128459_("maxStorage");
            this.production = nbttagcompound.m_128459_("production");
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("solarType", this.solartype);
        if (this.storage > 0.0) {
            nbttagcompound.m_128347_("storage", this.storage);
        }
        if (this.maxStorage > 0.0) {
            nbttagcompound.m_128347_("genDay", this.genDay);
            nbttagcompound.m_128347_("genNight", this.genNight);
            nbttagcompound.m_128347_("production", this.production);
            nbttagcompound.m_128347_("maxStorage", this.maxStorage);
        }
        return nbttagcompound;
    }

    public double gaugeEnergyScaled(float i) {
        return this.progress * (double)i;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_ && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), this));
            this.addedToEnergyNet = true;
            new PacketUpdateFieldTile(this, "slot", this.inputslot);
        }
        this.updateVisibility();
        this.intialize();
        this.inputslot.update();
        this.inputslotA.update();
    }

    @Override
    public void onUnloaded() {
        if (!this.f_58857_.f_46443_ && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public double canExtractEnergy() {
        return Math.min(this.storage, this.production);
    }

    @Override
    public void extractEnergy(double amount) {
        this.storage -= amount;
    }

    @Override
    public int getSourceTier() {
        return this.machineTire;
    }

    public void updateTileEntityField() {
        if (this.f_58857_ != null) {
            new PacketUpdateFieldTile(this, "type", (Object)this.f_58855_);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("type")) {
            try {
                this.f_58855_ = EnumType.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot")) {
            try {
                InvSlot slot = (InvSlot)DecoderHandler.decode(is);
                for (int i = 0; i < slot.size(); ++i) {
                    this.inputslot.set(i, slot.get(i));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public ContainerSinSolarPanel getGuiContainer(Player entityPlayer) {
        return new ContainerSinSolarPanel(entityPlayer, this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.gainFuel();
        if (this.generating > 0.0) {
            this.storage = this.storage + this.generating <= this.maxStorage ? (this.storage += this.generating) : this.maxStorage;
        }
        this.progress = Math.min(1.0, this.storage / this.maxStorage);
        if (this.storage < 0.0) {
            this.storage = 0.0;
        }
        if (this.maxStorage <= 0.0) {
            this.storage = 0.0;
        }
        if (this.getWorld().m_46467_() % 20L == 0L) {
            int size1 = 0;
            for (ItemStack stack : this.inputslot) {
                if (stack.m_41619_()) continue;
                size1 += stack.m_41613_();
            }
            if (this.size != size1) {
                this.inputslot.update();
                this.size = size1;
            }
        }
    }

    public void gainFuel() {
        if (this.getWorld().m_46467_() % 80L == 0L) {
            new PacketUpdateFieldTile(this, "slot", this.inputslot);
        }
        if (this.getWorld().m_46467_() % 40L == 0L) {
            this.updateVisibility();
            int type = this.solartype;
            this.solartype = this.inputslotA.solartype();
            if (type != this.solartype) {
                this.updateTileEntityField();
            }
            if (this.solartype == 0) {
                this.setActive("");
            } else {
                this.setActive(EnumType.getFromID(this.solartype).getNameType());
            }
        }
        switch (this.generationState) {
            case DAY: {
                this.generating = this.f_58855_.coefficient_day * this.genDay;
                break;
            }
            case NIGHT: {
                this.generating = this.f_58855_.coefficient_night * this.genNight;
                break;
            }
            case RAINDAY: {
                this.generating = this.f_58855_.coefficient_rain * this.f_58855_.coefficient_day * this.genDay;
                break;
            }
            case RAINNIGHT: {
                this.generating = this.f_58855_.coefficient_rain * this.f_58855_.coefficient_night * this.genNight;
                break;
            }
            case NETHER: {
                this.generating = this.f_58855_.coefficient_nether * this.genDay;
                break;
            }
            case END: {
                this.generating = this.f_58855_.coefficient_end * this.genDay;
                break;
            }
            case NONE: {
                this.generating = 0.0;
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, (Object)this.f_58855_);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.f_58855_ = EnumType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSintezator((ContainerSinSolarPanel)menu);
    }

    public void setType(EnumType type) {
        this.f_58855_ = type;
    }

    public int setSolarType(EnumType type) {
        if (type == null) {
            this.setType(EnumType.DEFAULT);
            return 0;
        }
        this.setType(type);
        switch (type) {
            case AIR: {
                if (this.pos.m_123342_() < 130) break;
                return 1;
            }
            case EARTH: {
                if (this.pos.m_123342_() > 40) break;
                return 2;
            }
            case NETHER: {
                if (this.getWorld().m_46472_() != Level.f_46429_) break;
                return 3;
            }
            case END: {
                if (this.getWorld().m_46472_() != Level.f_46430_) break;
                return 4;
            }
            case NIGHT: {
                if (this.sunIsUp) break;
                return 5;
            }
            case DAY: {
                if (!this.sunIsUp) break;
                return 6;
            }
            case RAIN: {
                if (!this.getWorld().m_46471_() && !this.getWorld().m_46470_()) break;
                return 7;
            }
        }
        this.setType(EnumType.DEFAULT);
        return 0;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor var1, Direction var2) {
        return true;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
    }
}

