/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerStamp;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiStamp;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.ItemCraftingElements;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityStampMechanism
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InvSlotUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    public final InvSlotRecipes inputSlotA;
    public final ComponentUpgrade componentUpgrades;
    public final InvSlot inputSlotB;
    private final AirPollutionComponent pollutionAir;
    private final SoilPollutionComponent pollutionSoil;
    public MachineRecipe output;

    public TileEntityStampMechanism(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3.stamp_mechanism, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, 100));
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, "stamp_vent", (IUpdateTick)this);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0));
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.inputSlotB = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.m_41720_() instanceof ItemCraftingElements)) {
                    return false;
                }
                int damage = ((ISubEnum)((ItemCraftingElements)stack.m_41720_()).getElement()).getId();
                return damage == 369 || damage == 370 || damage == 412 || damage == 413 || damage == 438;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                ((TileEntityStampMechanism)this.base).inputSlotA.setRecipe("empty");
                if (content.m_41619_()) {
                    ((TileEntityStampMechanism)this.base).getOutput();
                    return content;
                }
                int damage = ((ISubEnum)((ItemCraftingElements)content.m_41720_()).getElement()).getId();
                if (damage == 369) {
                    ((TileEntityStampMechanism)this.base).inputSlotA.setRecipe("stamp_coolant");
                }
                if (damage == 370) {
                    ((TileEntityStampMechanism)this.base).inputSlotA.setRecipe("stamp_plate");
                }
                if (damage == 412) {
                    ((TileEntityStampMechanism)this.base).inputSlotA.setRecipe("stamp_exchanger");
                }
                if (damage == 413) {
                    ((TileEntityStampMechanism)this.base).inputSlotA.setRecipe("stamp_vent");
                }
                if (damage == 438) {
                    ((TileEntityStampMechanism)this.base).inputSlotA.setRecipe("stamp_capacitor");
                }
                ((TileEntityStampMechanism)this.base).getOutput();
                return content;
            }
        };
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    public static void addRecipe(String name, ItemStack output, Object ... objects) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe(name, new BaseMachineRecipe(new Input(input.getInput(objects[0]), input.getInput(objects[1]), input.getInput(objects[2]), input.getInput(objects[3])), new RecipeOutput(null, output)));
    }

    public ContainerStamp getGuiContainer(Player var1) {
        return new ContainerStamp(this, var1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiStamp((ContainerStamp)menu);
    }

    @Override
    public void init() {
        TileEntityStampMechanism.addRecipe("stamp_plate", new ItemStack((ItemLike)IUItem.reactor_plate.getItem()), "forge:plates/Iron", "forge:ingots/Lead", "forge:ingots/Tin", "forge:gems/Quartz");
        TileEntityStampMechanism.addRecipe("stamp_plate", new ItemStack((ItemLike)IUItem.adv_reactor_plate.getItem()), "forge:plates/Bronze", new ItemStack((ItemLike)IUItem.reactor_plate.getItem()), "forge:storage_blocks/Redstone", "forge:ingots/Spinel");
        TileEntityStampMechanism.addRecipe("stamp_plate", new ItemStack((ItemLike)IUItem.imp_reactor_plate.getItem()), ModUtils.setSize(IUItem.advancedAlloy, 4), "forge:ingots/Aluminium", "forge:ingots/Vanadoalumite", new ItemStack((ItemLike)IUItem.adv_reactor_plate.getItem()));
        TileEntityStampMechanism.addRecipe("stamp_plate", new ItemStack((ItemLike)IUItem.per_reactor_plate.getItem()), "forge:plateDense/Steel", new ItemStack((ItemLike)IUItem.compresscarbon.getItem(), 2), new ItemStack((ItemLike)IUItem.plast.getItem()), new ItemStack((ItemLike)IUItem.imp_reactor_plate.getItem()));
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.vent.getItem()), "forge:gears/Chromium", "forge:storage_blocks/Copper", new ItemStack((ItemLike)Items.f_42451_, 4), "forge:ingots/Iron");
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.adv_Vent.getItem()), new ItemStack((ItemLike)IUItem.vent.getItem()), "forge:plates/Gold", "forge:ingots/Electrum", "forge:ingots/Bronze");
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.imp_Vent.getItem()), new ItemStack((ItemLike)IUItem.adv_Vent.getItem()), "forge:gems/Diamond", "forge:plates/Platinum", "forge:rods/Iridium");
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.per_Vent.getItem()), new ItemStack((ItemLike)IUItem.imp_Vent.getItem()), new ItemStack((ItemLike)IUItem.iudust.getStack(24), 8), "forge:storage_blocks/Redbrass", "forge:plates/Germanium");
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.componentVent.getItem()), new ItemStack((ItemLike)IUItem.vent.getItem()), new ItemStack((ItemLike)IUItem.plastic_plate.getItem(), 4), "forge:plates/Iron", "forge:ingots/Tungsten");
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.adv_componentVent.getItem()), new ItemStack((ItemLike)IUItem.componentVent.getItem()), "forge:plates/Aluminium", "forge:ingots/Iron", new ItemStack((ItemLike)IUItem.iudust.getStack(29), 8));
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.imp_componentVent.getItem()), new ItemStack((ItemLike)IUItem.adv_componentVent.getItem()), "forge:plates/Aluminumbronze", "forge:ingots/Duralumin", "forge:storage_blocks/Redstone");
        TileEntityStampMechanism.addRecipe("stamp_vent", new ItemStack((ItemLike)IUItem.per_componentVent.getItem()), new ItemStack((ItemLike)IUItem.imp_componentVent.getItem()), "forge:storage_blocks/Diamond", new ItemStack((ItemLike)IUItem.crafting_elements.getStack(319), 4), "forge:plates/Iridium");
        TileEntityStampMechanism.addRecipe("stamp_exchanger", new ItemStack((ItemLike)IUItem.heat_exchange.getItem()), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(122), 2), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(280), 4), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(277), 1), "forge:ingots/Zinc");
        TileEntityStampMechanism.addRecipe("stamp_exchanger", new ItemStack((ItemLike)IUItem.adv_heat_exchange.getItem()), new ItemStack((ItemLike)IUItem.heat_exchange.getItem()), new ItemStack((ItemLike)IUItem.plastic_plate.getItem(), 4), "forge:storage_blocks/Redstone", "forge:ingots/Redbrass");
        TileEntityStampMechanism.addRecipe("stamp_exchanger", new ItemStack((ItemLike)IUItem.imp_heat_exchange.getItem()), new ItemStack((ItemLike)IUItem.adv_heat_exchange.getItem()), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(320), 4), "forge:ingots/Titanium", "forge:plates/Germanium");
        TileEntityStampMechanism.addRecipe("stamp_exchanger", new ItemStack((ItemLike)IUItem.per_heat_exchange.getItem()), new Object[]{new ItemStack((ItemLike)IUItem.imp_heat_exchange.getItem()), IUItem.compresscarbon.getItem(), IUItem.compressAlloy.getItem(), new ItemStack((ItemLike)IUItem.iudust.getStack(24), 16)});
        TileEntityStampMechanism.addRecipe("stamp_capacitor", new ItemStack((ItemLike)IUItem.capacitor.getItem()), new ItemStack((ItemLike)IUItem.reactor_plate.getItem()), "forge:storage_blocks/Bronze", "forge:storage_blocks/Redstone", IUItem.carbonFiber);
        TileEntityStampMechanism.addRecipe("stamp_capacitor", new ItemStack((ItemLike)IUItem.adv_capacitor.getItem()), new ItemStack((ItemLike)IUItem.capacitor.getItem()), new ItemStack((ItemLike)IUItem.plastic_plate.getItem(), 4), "forge:storage_blocks/Iron", "forge:storage_blocks/Coal");
        TileEntityStampMechanism.addRecipe("stamp_capacitor", new ItemStack((ItemLike)IUItem.imp_capacitor.getItem()), new ItemStack((ItemLike)IUItem.adv_capacitor.getItem()), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(320), 4), "forge:plates/Invar", new ItemStack((ItemLike)IUItem.crafting_elements.getStack(282), 4));
        TileEntityStampMechanism.addRecipe("stamp_capacitor", new ItemStack((ItemLike)IUItem.per_capacitor.getItem()), new ItemStack((ItemLike)IUItem.imp_capacitor.getItem()), "forge:storage_blocks/Diamond", new ItemStack((ItemLike)IUItem.crafting_elements.getStack(285), 1), "forge:plates/Vitalium");
        TileEntityStampMechanism.addRecipe("stamp_coolant", new ItemStack((ItemLike)IUItem.coolant.getItem()), ModUtils.getCellFromFluid((Fluid)FluidName.fluidhyd.getInstance().get()), "forge:storage_blocks/Iron", "forge:ingots/Lithium", "forge:ingots/Tin");
        TileEntityStampMechanism.addRecipe("stamp_coolant", new ItemStack((ItemLike)IUItem.adv_coolant.getItem()), new ItemStack((ItemLike)IUItem.coolant.getItem()), ModUtils.getCellFromFluid((Fluid)FluidName.fluidazot.getInstance().get()), "forge:storage_blocks/Steel", "forge:plates/Obsidian");
        TileEntityStampMechanism.addRecipe("stamp_coolant", new ItemStack((ItemLike)IUItem.imp_coolant.getItem()), new ItemStack((ItemLike)IUItem.adv_coolant.getItem()), ModUtils.getCellFromFluid((Fluid)FluidName.fluidHelium.getInstance().get()), "forge:plates/Tungsten", "forge:doubleplate/Duralumin");
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.stamp_mechanism;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.setRecipe("empty");
            if (!this.inputSlotB.get(0).m_41619_()) {
                int damage = ((ISubEnum)((ItemCraftingElements)this.inputSlotB.get(0).m_41720_()).getElement()).getId();
                if (damage == 369) {
                    this.inputSlotA.setRecipe("stamp_coolant");
                }
                if (damage == 370) {
                    this.inputSlotA.setRecipe("stamp_plate");
                }
                if (damage == 412) {
                    this.inputSlotA.setRecipe("stamp_exchanger");
                }
                if (damage == 413) {
                    this.inputSlotA.setRecipe("stamp_vent");
                }
                if (damage == 438) {
                    this.inputSlotA.setRecipe("stamp_capacitor");
                }
            }
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

