/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerPump;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiPump;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricLiquidTankInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class TilePump
extends TileElectricLiquidTankInventory
implements IUpgradableBlock,
IType {
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final InvSlotFluid containerSlot = new InvSlotFluid(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public double energyConsume = 1.0;
    public int operationsPerTick;
    public int operationLength;
    public ComponentProgress componentProgress;

    public TilePump(int size, int operationLength, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(20.0, 1, size, block, pos, state);
        this.defaultEnergyConsume = 1.0;
        this.defaultOperationLength = this.operationLength = operationLength;
        this.defaultTier = 1;
        this.defaultEnergyStorage = this.operationLength;
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, (short)operationLength));
        this.fluidTank.setTypeItemSlot(InvSlot.TypeItemSlot.OUTPUT);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.energy.canUseEnergy(this.energyConsume)) {
            if (this.componentProgress.getProgress() < this.componentProgress.getMaxValue()) {
                this.componentProgress.addProgress(0);
                this.energy.useEnergy(this.energyConsume);
            } else if (this.canoperate()) {
                this.componentProgress.setProgress((short)0);
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        for (int i = this.pos.m_123341_() - 5; i <= this.pos.m_123341_() + 5; ++i) {
            for (int j = this.pos.m_123343_() - 5; j <= this.pos.m_123343_() + 5; ++j) {
                for (int k = this.pos.m_123342_() - 5; k <= this.pos.m_123342_() + 5; ++k) {
                    for (Direction dir : Direction.values()) {
                        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                            return false;
                        }
                        FluidStack liquid = this.pump(new BlockPos(i + dir.m_122429_(), k + dir.m_122430_(), j + dir.m_122431_()), false);
                        if (this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                        this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.EXECUTE);
                        canOperate = true;
                    }
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        BlockState block;
        FluidStack ret = FluidStack.EMPTY;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.getWorld().m_8055_(pos)).m_60767_().m_76332_()) {
            FluidState fluidState = block.m_60734_().m_5888_(block);
            if (!fluidState.m_76170_()) {
                return FluidStack.EMPTY;
            }
            ret = new FluidStack(fluidState.m_76152_(), 1000);
            if ((this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == ret.getFluid()) && !sim) {
                this.getWorld().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        double previousProgress = this.componentProgress.getBar();
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = TilePump.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, 1.0);
        this.energy.setSinkTier(TilePump.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.energy.setCapacity(TilePump.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + (double)this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.componentProgress.setMaxValue((short)this.operationLength);
        this.componentProgress.setProgress((short)Math.floor(previousProgress * (double)this.operationLength + 0.1));
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    public ContainerPump getGuiContainer(Player entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiPump((ContainerPump)isAdmin);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return null;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

